/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.flying_things;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.network.PacketDistributor;
import org.apache.commons.lang3.tuple.Pair;
import ovh.corail.flying_things.ModFlyingThings;
import ovh.corail.flying_things.network.UpdateClientMessage;

@Mod.EventBusSubscriber(modid="flying_things", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ConfigFlyingThings {
    static final ForgeConfigSpec CLIENT_SPEC;
    public static final Client client;
    private static final ForgeConfigSpec.Builder BUILDER;
    public static final General general;
    public static final DeniedDimensionToFly deniedDimensionToFly;
    static final ForgeConfigSpec GENERAL_SPEC;

    private static String getTranslation(String name) {
        return "flying_things.config." + name;
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals("flying_things") && Minecraft.func_71410_x().func_71356_B()) {
            ConfigFlyingThings.updateServerDatas();
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onPlayerLogued(PlayerEvent.PlayerLoggedInEvent event) {
        if (event.getPlayer() != null && event.getPlayer().func_70613_aW()) {
            ModFlyingThings.HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)event.getPlayer()), (Object)new UpdateClientMessage((Integer)ConfigFlyingThings.general.speedMax.get(), (Integer)ConfigFlyingThings.general.accelerationMax.get(), (Integer)ConfigFlyingThings.general.accelerationIncrement.get(), (Integer)ConfigFlyingThings.general.speedMaxNoEnergy.get(), (Integer)ConfigFlyingThings.general.maxEnergy.get(), (Boolean)ConfigFlyingThings.general.allowTombstoneSoulbound.get()));
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onWorldLoad(WorldEvent.Load event) {
        if (!event.getWorld().func_201670_d()) {
            ConfigFlyingThings.updateServerDatas();
        }
    }

    private static void updateServerDatas() {
        General.serverSpeedMax = (Integer)ConfigFlyingThings.general.speedMax.get();
        General.serverAccelerationMax = (Integer)ConfigFlyingThings.general.accelerationMax.get();
        General.serverAccelerationIncrement = (Integer)ConfigFlyingThings.general.accelerationIncrement.get();
        General.serverSpeedMaxNoEnergy = (Integer)ConfigFlyingThings.general.speedMaxNoEnergy.get();
        General.serverMaxEnergy = (Integer)ConfigFlyingThings.general.maxEnergy.get();
        General.serverAllowTombstoneSoulbound = (Boolean)ConfigFlyingThings.general.allowTombstoneSoulbound.get();
    }

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(Client::new);
        CLIENT_SPEC = (ForgeConfigSpec)specPair.getRight();
        client = (Client)specPair.getLeft();
        BUILDER = new ForgeConfigSpec.Builder();
        general = new General(BUILDER);
        deniedDimensionToFly = new DeniedDimensionToFly(BUILDER);
        GENERAL_SPEC = BUILDER.build();
    }

    public static class DeniedDimensionToFly {
        public final ForgeConfigSpec.ConfigValue<List<String>> deniedDimensionBroom;
        public final ForgeConfigSpec.ConfigValue<List<String>> deniedDimensionCarpet;

        public DeniedDimensionToFly(ForgeConfigSpec.Builder builder) {
            builder.comment("Denied dimensions to ride a flying thing - example : minecraft:the_nether").push("denied_dimensions_to_fly");
            this.deniedDimensionBroom = builder.comment("Dimensions for the brooms").translation(ConfigFlyingThings.getTranslation("denied_dimension_broom")).define("denied_dimension_broom", new ArrayList());
            this.deniedDimensionCarpet = builder.comment("Dimensions for the carpets").translation(ConfigFlyingThings.getTranslation("denied_dimension_carpet")).define("denied_dimension_carpet", new ArrayList());
            builder.pop();
        }
    }

    public static class Client {
        public final ForgeConfigSpec.ConfigValue<Boolean> renderEffect;
        public final ForgeConfigSpec.ConfigValue<Integer> barLength;
        public final ForgeConfigSpec.ConfigValue<Integer> barHeightPos;

        public Client(ForgeConfigSpec.Builder builder) {
            builder.comment("Theses options are custom parameters for the player").push("client");
            this.renderEffect = builder.comment("Enable rendering effects [false/true|default:true]").translation(ConfigFlyingThings.getTranslation("render_effect")).define("render_effect", true);
            this.barLength = builder.comment("Length of the bars [9..182|default:182]").translation(ConfigFlyingThings.getTranslation("bar_length")).defineInRange("bar_length", 182, 9, 182);
            this.barHeightPos = builder.comment("Height of the position of the bars [0..MAX|default:62]").translation(ConfigFlyingThings.getTranslation("bar_height_pos")).defineInRange("bar_height_pos", 62, 0, Integer.MAX_VALUE);
            builder.pop();
        }
    }

    public static class General {
        public final ForgeConfigSpec.ConfigValue<Integer> speedMax;
        public final ForgeConfigSpec.ConfigValue<Integer> accelerationMax;
        public final ForgeConfigSpec.ConfigValue<Integer> accelerationIncrement;
        public final ForgeConfigSpec.ConfigValue<Integer> speedMaxNoEnergy;
        public final ForgeConfigSpec.ConfigValue<Integer> maxEnergy;
        public final ForgeConfigSpec.ConfigValue<Integer> timeToLoseEnergy;
        public final ForgeConfigSpec.ConfigValue<Integer> timeToRecoverEnergy;
        public final ForgeConfigSpec.ConfigValue<Boolean> allowTombstoneSoulbound;
        public final ForgeConfigSpec.ConfigValue<Boolean> allowToFlyInWater;
        public final ForgeConfigSpec.ConfigValue<Boolean> allowToBreakPlant;
        public final ForgeConfigSpec.ConfigValue<Boolean> allowSpecialRegen;
        public final ForgeConfigSpec.ConfigValue<Integer> chanceToFallWithProjectile;
        public final ForgeConfigSpec.ConfigValue<Boolean> persistantHolidays;
        public final ForgeConfigSpec.ConfigValue<Integer> chanceDropPhialOfAnimationOnBoss;
        public final ForgeConfigSpec.ConfigValue<Integer> chanceDropPumpkinStick;
        public final ForgeConfigSpec.ConfigValue<List<String>> treasureLootTable;
        public static int serverSpeedMax;
        public static int serverAccelerationMax;
        public static int serverAccelerationIncrement;
        public static int serverSpeedMaxNoEnergy;
        public static int serverMaxEnergy;
        public static boolean serverAllowTombstoneSoulbound;

        public static int getSpeedMax() {
            return serverSpeedMax;
        }

        public static int getAccelerationMax() {
            return serverAccelerationMax;
        }

        public static int getAccelerationIncrement() {
            return serverAccelerationIncrement;
        }

        public static int getSpeedMaxNoEnergy() {
            return serverSpeedMaxNoEnergy;
        }

        public static int getMaxEnergy() {
            return serverMaxEnergy;
        }

        public static boolean isSoulboundAllowed() {
            return serverAllowTombstoneSoulbound;
        }

        public General(ForgeConfigSpec.Builder builder) {
            builder.comment("Theses options can only be modified on the server in multiplayer").push("general");
            this.speedMax = builder.comment("Maximum Speed [0..200|default:90]").translation(ConfigFlyingThings.getTranslation("speed_max")).defineInRange("speed_max", 90, 0, 200);
            this.accelerationMax = builder.comment("Maximum acceleration [0..100|default:35]").translation(ConfigFlyingThings.getTranslation("acceleration_max")).defineInRange("acceleration_max", 35, 0, 100);
            this.accelerationIncrement = builder.comment("Acceleration increment [1..20|default:7]").translation(ConfigFlyingThings.getTranslation("acceleration_increment")).defineInRange("acceleration_increment", 7, 1, 20);
            this.speedMaxNoEnergy = builder.comment("Maximum speed with no energy [0..300|default:30]").translation(ConfigFlyingThings.getTranslation("speed_max_no_energy")).defineInRange("speed_max_no_energy", 30, 0, 300);
            this.maxEnergy = builder.comment("Maximum energy [100..MAX|default:1000]").translation(ConfigFlyingThings.getTranslation("max_energy")).defineInRange("max_energy", 1000, 100, Integer.MAX_VALUE);
            this.timeToLoseEnergy = builder.comment("Time to lose an energy point [5..MAX|default:5]").translation(ConfigFlyingThings.getTranslation("time_to_lose_energy")).defineInRange("time_to_lose_energy", 5, 5, Integer.MAX_VALUE);
            this.timeToRecoverEnergy = builder.comment("Time to recover an energy point [5..MAX|default:5]").translation(ConfigFlyingThings.getTranslation("time_to_recover_energy")).defineInRange("timeToRecoverEnergy", 5, 5, Integer.MAX_VALUE);
            this.allowTombstoneSoulbound = builder.comment("Allow applying Soulbound [false/true|default:true]").translation(ConfigFlyingThings.getTranslation("allow_tombstone_soulbound")).define("allow_tombstone_soulbound", true);
            this.allowToFlyInWater = builder.comment("Allow flying in water [false/true|default:true]").translation(ConfigFlyingThings.getTranslation("allow_to_fly_in_water")).define("allow_to_fly_in_water", true);
            this.allowToBreakPlant = builder.comment("Allow breaking plants [false/true|default:true]").translation(ConfigFlyingThings.getTranslation("allow_to_break_plant")).define("allow_to_break_plant", true);
            this.allowSpecialRegen = builder.comment("Allow special regeneration [false/true|default:true]").translation(ConfigFlyingThings.getTranslation("allow_special_regen")).define("allow_special_regen", true);
            this.chanceToFallWithProjectile = builder.comment("Chance to fall with projectiles [0..100|default:10]").translation(ConfigFlyingThings.getTranslation("chance_to_fall_with_projectile")).defineInRange("chance_to_fall_with_projectile", 10, 0, 100);
            this.persistantHolidays = builder.comment("Allow special holiday events outside periods [false/true|default:true]").translation(ConfigFlyingThings.getTranslation("persistant_holidays")).define("persistant_holidays", true);
            this.chanceDropPumpkinStick = builder.comment("Chance to get Halloween Sticks during this event [0..1000|default:10]").translation(ConfigFlyingThings.getTranslation("chance_drop_pumpkin_stick")).defineInRange("chance_drop_pumpkin_stick", 10, 0, 1000);
            this.chanceDropPhialOfAnimationOnBoss = builder.comment("Chance to get a Phial of Animation on boss [0..1000|default:10]").translation(ConfigFlyingThings.getTranslation("chance_drop_phial_of_animation_on_boss")).defineInRange("chance_drop_phial_of_animation_on_boss", 10, 0, 1000);
            this.treasureLootTable = builder.comment("Defines the loottables having a chance to contain a Phial of Animation").translation(ConfigFlyingThings.getTranslation("treasure_loot_table")).define("treasure_loot_table", (Object)Lists.newArrayList((Object[])new String[]{"minecraft:chests/end_city_treasure", "minecraft:chests/abandoned_mineshaft", "minecraft:chests/nether_bridge", "minecraft:chests/stronghold_library", "minecraft:chests/desert_pyramid", "minecraft:chests/jungle_temple", "minecraft:chests/igloo_chest", "minecraft:chests/woodland_mansion"}));
            builder.pop();
        }
    }
}

