/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.flying_things.compatibility;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import javax.annotation.Nonnull;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaRecipeCategoryUid;
import mezz.jei.api.ingredients.subtypes.ISubtypeInterpreter;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import net.minecraft.block.Blocks;
import net.minecraft.item.DyeColor;
import net.minecraft.item.DyeItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapelessRecipe;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import ovh.corail.flying_things.ConfigFlyingThings;
import ovh.corail.flying_things.helper.Helper;
import ovh.corail.flying_things.item.ItemAbstractFlyingThing;
import ovh.corail.flying_things.item.ItemEnchantedBroom;
import ovh.corail.flying_things.registry.ModItems;

@JeiPlugin
public class IntegrationJEI
implements IModPlugin {
    @Nonnull
    public ResourceLocation getPluginUid() {
        return new ResourceLocation("flying_things");
    }

    public void registerRecipes(IRecipeRegistration registry) {
        ItemStack currentStack;
        ImmutableList.Builder builder = ImmutableList.builder();
        for (DyeColor dye : DyeColor.values()) {
            currentStack = ItemEnchantedBroom.setModelType(new ItemStack((IItemProvider)ModItems.enchantedBroom), 12);
            builder.add((Object)new ShapelessRecipe(new ResourceLocation("flying_things:colored_broom"), "colored_broom", ItemEnchantedBroom.setModelType(currentStack.func_77946_l(), dye.func_196059_a()), NonNullList.func_193580_a((Object)Ingredient.field_193370_a, (Object[])new Ingredient[]{Ingredient.func_193369_a((ItemStack[])new ItemStack[]{new ItemStack((IItemProvider)DyeItem.func_195961_a((DyeColor)dye))}), Ingredient.func_193369_a((ItemStack[])new ItemStack[]{currentStack})})));
        }
        if (Helper.isDateAroundHalloween() || ((Boolean)ConfigFlyingThings.general.persistantHolidays.get()).booleanValue()) {
            for (DyeColor dye : DyeColor.values()) {
                currentStack = ItemEnchantedBroom.setModelType(new ItemStack((IItemProvider)ModItems.enchantedBroom), dye.func_196059_a());
                builder.add((Object)new ShapelessRecipe(new ResourceLocation("flying_things:pumpkin_broom"), "pumpkin_broom", ItemEnchantedBroom.setHeadType(currentStack.func_77946_l(), 1), NonNullList.func_193580_a((Object)Ingredient.field_193370_a, (Object[])new Ingredient[]{Ingredient.func_193369_a((ItemStack[])new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_150423_aK)}), Ingredient.func_193369_a((ItemStack[])new ItemStack[]{currentStack})})));
            }
        }
        registry.addRecipes((Collection)builder.build(), VanillaRecipeCategoryUid.CRAFTING);
    }

    public void registerItemSubtypes(ISubtypeRegistration registration) {
        registration.registerSubtypeInterpreter((Item)ModItems.enchantedBroom, (ISubtypeInterpreter)new FlyingThingsInterpreter());
        registration.registerSubtypeInterpreter((Item)ModItems.magicCarpet, (ISubtypeInterpreter)new FlyingThingsInterpreter());
    }

    private static class FlyingThingsInterpreter
    implements ISubtypeInterpreter {
        private FlyingThingsInterpreter() {
        }

        public String apply(ItemStack stack) {
            int modelType = ItemAbstractFlyingThing.getModelType(stack);
            return String.valueOf(modelType);
        }
    }
}

