/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.flying_things.entity;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.crash.ReportedException;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IndirectEntityDamageSource;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.dimension.DimensionType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.items.ItemHandlerHelper;
import ovh.corail.flying_things.ConfigFlyingThings;
import ovh.corail.flying_things.helper.Helper;

public abstract class EntityAbstractFlyingThing
extends Entity {
    private boolean hasSoulbound = false;
    private boolean wasOnGround = false;
    private double speedFactor = 0.01;
    public double speed;
    private double lerpX;
    private double lerpY;
    private double lerpZ;
    private double lerpYaw;
    private double lerpPitch;
    private int lerpSteps;
    private double velocityX;
    private double velocityY;
    private double velocityZ;

    public EntityAbstractFlyingThing(EntityType<?> entityType, World world) {
        super(entityType, world);
        this.field_70156_m = true;
    }

    public EntityAbstractFlyingThing(EntityType<?> entityType, World world, double x, double y, double z) {
        this(entityType, world);
        this.func_70107_b(x, y, z);
        this.func_213317_d(Vec3d.field_186680_a);
        this.field_70169_q = x;
        this.field_70167_r = y;
        this.field_70166_s = z;
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected abstract DataParameter<Integer> getDataEnergy();

    protected abstract DataParameter<Float> getDataDamageTaken();

    protected abstract DataParameter<Integer> getDataTimeSinceHit();

    protected abstract DataParameter<Integer> getDataForwardDirection();

    protected abstract DataParameter<Integer> getDataModelType();

    public abstract ItemStack getStack();

    public abstract boolean canFlyInDimension(DimensionType var1);

    protected abstract boolean onInteractWithPlayerItem(ItemStack var1, PlayerEntity var2, Hand var3);

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(this.getDataTimeSinceHit(), (Object)0);
        this.field_70180_af.func_187214_a(this.getDataForwardDirection(), (Object)1);
        this.field_70180_af.func_187214_a(this.getDataEnergy(), (Object)ConfigFlyingThings.General.getMaxEnergy());
        this.field_70180_af.func_187214_a(this.getDataDamageTaken(), (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(this.getDataModelType(), (Object)0);
    }

    public void func_213281_b(CompoundNBT tag) {
        tag.func_74768_a("model_type", this.getModelType());
        tag.func_74768_a("energy", this.getEnergy());
        tag.func_74776_a("damage_taken", this.getDamageTaken());
        tag.func_74757_a("soulbound", this.hasSoulbound);
    }

    public void func_70037_a(CompoundNBT tag) {
        if (tag.func_150297_b("model_type", 3)) {
            this.setModelType(tag.func_74762_e("model_type"));
        }
        if (tag.func_150297_b("energy", 3)) {
            this.setEnergy(tag.func_74762_e("energy"));
        }
        if (tag.func_150297_b("damage_taken", 5)) {
            this.setDamageTaken(tag.func_74760_g("damage_taken"));
        }
        if (tag.func_150297_b("soulbound", 1)) {
            this.setSoulbound(tag.func_74767_n("soulbound"));
        }
    }

    public boolean hasSoulbound() {
        return this.hasSoulbound;
    }

    public void setSoulbound(boolean flag) {
        this.hasSoulbound = flag;
    }

    public void setEnergy(int energy) {
        this.field_70180_af.func_187227_b(this.getDataEnergy(), (Object)MathHelper.func_76125_a((int)energy, (int)0, (int)ConfigFlyingThings.General.getMaxEnergy()));
    }

    public int getEnergy() {
        return MathHelper.func_76125_a((int)((Integer)this.field_70180_af.func_187225_a(this.getDataEnergy())), (int)0, (int)ConfigFlyingThings.General.getMaxEnergy());
    }

    public void setDamageTaken(float damage) {
        this.field_70180_af.func_187227_b(this.getDataDamageTaken(), (Object)Float.valueOf(damage));
    }

    public float getDamageTaken() {
        return ((Float)this.field_70180_af.func_187225_a(this.getDataDamageTaken())).floatValue();
    }

    public void setTimeSinceHit(int time) {
        this.field_70180_af.func_187227_b(this.getDataTimeSinceHit(), (Object)time);
    }

    public int getTimeSinceHit() {
        return (Integer)this.field_70180_af.func_187225_a(this.getDataTimeSinceHit());
    }

    public void setForwardDirection(int direction) {
        this.field_70180_af.func_187227_b(this.getDataForwardDirection(), (Object)direction);
    }

    public int getForwardDirection() {
        return (Integer)this.field_70180_af.func_187225_a(this.getDataForwardDirection());
    }

    public void setModelType(int modelType) {
        if (modelType >= 0) {
            this.field_70180_af.func_187227_b(this.getDataModelType(), (Object)modelType);
        }
    }

    public int getModelType() {
        return (Integer)this.field_70180_af.func_187225_a(this.getDataModelType());
    }

    public boolean func_184230_a(PlayerEntity player, Hand hand) {
        if (this.field_70170_p.field_72995_K) {
            return true;
        }
        ItemStack stack = player.func_184586_b(hand);
        if (!stack.func_190926_b() && !this.func_184207_aI() && !player.func_70093_af() && this.onInteractWithPlayerItem(stack, player, hand)) {
            return true;
        }
        if (player.func_70093_af()) {
            ItemHandlerHelper.giveItemToPlayer((PlayerEntity)player, (ItemStack)this.getStack());
            this.func_70106_y();
            return true;
        }
        assert (player.field_70170_p.func_73046_m() != null);
        if (player.field_70170_p.func_73046_m().func_71231_X()) {
            if (this.canFlyInDimension(this.field_70170_p.field_73011_w.func_186058_p())) {
                return player.func_184220_m((Entity)this);
            }
            player.func_145747_a((ITextComponent)new TranslationTextComponent("flying_things.message.denied_dimension_to_fly", new Object[]{this.func_145748_c_()}));
            return false;
        }
        if (hand == Hand.MAIN_HAND) {
            player.func_145747_a((ITextComponent)new TranslationTextComponent("flying_things.message.flight_not_allowed", new Object[0]));
            return false;
        }
        return false;
    }

    public boolean canBeRiddenInWater(Entity rider) {
        return (Boolean)ConfigFlyingThings.general.allowToFlyInWater.get();
    }

    protected void func_184225_p(Entity passenger) {
        boolean valid = !this.field_70170_p.field_72995_K && passenger instanceof PlayerEntity && this.func_184179_bs() == passenger && passenger.func_184187_bx() != this;
        super.func_184225_p(passenger);
        if (valid && this.func_70089_S()) {
            ItemHandlerHelper.giveItemToPlayer((PlayerEntity)((PlayerEntity)passenger), (ItemStack)this.getStack());
            this.func_70106_y();
        }
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K) {
            if (this.func_184179_bs() != null) {
                if (this.getEnergy() > 0 && this.field_70173_aa % ((Integer)ConfigFlyingThings.general.timeToLoseEnergy.get() * 20) == 0) {
                    this.setEnergy(this.getEnergy() - 1);
                }
            } else if (this.getEnergy() < ConfigFlyingThings.General.getMaxEnergy() && this.field_70173_aa % ((Integer)ConfigFlyingThings.general.timeToRecoverEnergy.get() * 20) == 0) {
                this.setEnergy(this.getEnergy() + 1);
            }
        }
        if (this.getTimeSinceHit() > 0) {
            this.setTimeSinceHit(this.getTimeSinceHit() - 1);
        }
        if (this.getDamageTaken() > 0.0f) {
            this.setDamageTaken(this.getDamageTaken() - 1.0f);
        }
        this.field_70169_q = this.field_70165_t;
        this.field_70167_r = this.field_70163_u;
        this.field_70166_s = this.field_70161_v;
        double speedMax = (double)(this.getEnergy() > 0 ? ConfigFlyingThings.General.getSpeedMax() : ConfigFlyingThings.General.getSpeedMaxNoEnergy()) / 100.0;
        if (this.speed > speedMax) {
            double reducedMotion = speedMax / this.speed;
            this.func_213317_d(this.func_213322_ci().func_216372_d(reducedMotion, reducedMotion, reducedMotion));
            this.speed = speedMax;
        }
        double initialSpeed = this.func_213322_ci().func_72433_c();
        if (this.field_70170_p.field_72995_K && !this.func_184207_aI()) {
            if (this.lerpSteps > 0) {
                double newPosX = this.field_70165_t + (this.lerpX - this.field_70165_t) / (double)this.lerpSteps;
                double newPosY = this.field_70163_u + (this.lerpY - this.field_70163_u) / (double)this.lerpSteps;
                double newPosZ = this.field_70161_v + (this.lerpZ - this.field_70161_v) / (double)this.lerpSteps;
                double d10 = MathHelper.func_76138_g((double)(this.lerpYaw - (double)this.field_70177_z));
                this.field_70177_z = (float)((double)this.field_70177_z + d10 / (double)this.lerpSteps);
                this.field_70125_A = (float)((double)this.field_70125_A + (this.lerpPitch - (double)this.field_70125_A) / (double)this.lerpSteps);
                --this.lerpSteps;
                this.func_70080_a(newPosX, newPosY, newPosZ, this.field_70177_z, this.field_70125_A);
            } else {
                double newPosX = this.field_70165_t + this.func_213322_ci().field_72450_a;
                double newPosY = this.field_70163_u + this.func_213322_ci().field_72448_b;
                double newPosZ = this.field_70161_v + this.func_213322_ci().field_72449_c;
                this.func_70107_b(newPosX, newPosY, newPosZ);
                this.func_70101_b((float)((double)this.field_70177_z + (this.lerpYaw - (double)this.field_70177_z)), (float)((double)this.field_70125_A + (this.lerpPitch - (double)this.field_70125_A)));
                this.func_213317_d(this.func_213322_ci().func_216372_d((double)0.99f, 1.0, (double)0.99f));
            }
        } else {
            List list;
            double accelerationIncrement = (double)ConfigFlyingThings.General.getAccelerationIncrement() / 100.0;
            if (this.func_184179_bs() instanceof LivingEntity) {
                if ((double)((LivingEntity)this.func_184179_bs()).field_191988_bg < 0.0) {
                    this.func_213317_d(this.func_213322_ci().func_216372_d(1.0 - accelerationIncrement, 1.0, 1.0 - accelerationIncrement));
                } else if ((double)((LivingEntity)this.func_184179_bs()).field_191988_bg > 0.0) {
                    double dirX = -Math.sin((double)this.func_184179_bs().field_70177_z * Math.PI / 180.0);
                    double dirZ = Math.cos((double)this.func_184179_bs().field_70177_z * Math.PI / 180.0);
                    double dirY = -Math.sin((double)this.func_184179_bs().field_70125_A * Math.PI / 180.0);
                    if (dirY > -0.5 && dirY < 0.2) {
                        dirY = 0.0;
                    } else if (dirY < 0.0) {
                        dirY *= 0.5;
                    }
                    this.func_213317_d(new Vec3d(this.func_213322_ci().field_72450_a + dirX * this.speedFactor * 0.1, dirY * this.speedFactor * 2.0, this.func_213322_ci().field_72449_c + dirZ * this.speedFactor * 0.1));
                }
            } else if (!this.func_184207_aI()) {
                double moX = this.func_213322_ci().field_72450_a * 0.9;
                double moZ = this.func_213322_ci().field_72449_c * 0.9;
                this.func_213317_d(new Vec3d(Math.abs(moX) < 0.01 ? 0.0 : moX, this.func_213322_ci().field_72448_b - (!this.field_70122_E ? 0.2 : 0.0), Math.abs(moZ) < 0.01 ? 0.0 : moZ));
            }
            this.speed = this.func_213322_ci().func_72433_c();
            double accelerationMax = (double)ConfigFlyingThings.General.getAccelerationMax() / 100.0;
            if (this.speed > initialSpeed && this.speedFactor < accelerationMax) {
                this.speedFactor += (accelerationMax - this.speedFactor) / (double)ConfigFlyingThings.General.getAccelerationMax();
                if (this.speedFactor > accelerationMax) {
                    this.speedFactor = accelerationMax;
                }
            } else if (this.speed < initialSpeed) {
                this.speedFactor -= (this.speedFactor - accelerationIncrement) / (double)ConfigFlyingThings.General.getAccelerationMax();
                if (this.speedFactor < accelerationIncrement) {
                    this.speedFactor = accelerationIncrement;
                }
            }
            this.func_213315_a(MoverType.SELF, this.func_213322_ci());
            double reducedMotion = !this.wasOnGround && this.field_70122_E ? 0.5 : (double)0.99f;
            this.wasOnGround = this.field_70122_E;
            this.func_213317_d(this.func_213322_ci().func_216372_d(reducedMotion, reducedMotion, reducedMotion));
            this.field_70125_A = 0.0f;
            double rotYaw = this.field_70177_z;
            double x = this.field_70169_q - this.field_70165_t;
            double z = this.field_70166_s - this.field_70161_v;
            if (x * x + z * z > 0.001) {
                rotYaw = (float)(Math.atan2(z, x) * 180.0 / Math.PI) + 90.0f;
            }
            double adjust = MathHelper.func_76138_g((double)(rotYaw - (double)this.field_70177_z));
            this.field_70177_z += (float)adjust;
            this.func_70101_b(this.field_70177_z, this.field_70125_A);
            if (!this.field_70170_p.field_72995_K && !(list = this.field_70170_p.func_175674_a((Entity)this, this.func_174813_aQ().func_72314_b((double)0.2f, (double)-0.01f, (double)0.2f), p -> !p.func_184191_r((Entity)this))).isEmpty()) {
                for (Entity entity : list) {
                    if (entity.func_184196_w((Entity)this)) continue;
                    if (this.func_184219_q(entity) && !entity.func_184218_aH() && entity.func_213311_cf() < this.func_213311_cf() && entity instanceof LivingEntity && !(entity instanceof PlayerEntity)) {
                        entity.func_184220_m((Entity)this);
                        continue;
                    }
                    if (!entity.func_70104_M()) continue;
                    this.func_70108_f(entity);
                }
            }
        }
    }

    protected void func_145775_I() {
        boolean isHighSpeed;
        AxisAlignedBB bounds = this.func_174813_aQ();
        boolean bl = isHighSpeed = this.speed > 0.4;
        if (isHighSpeed) {
            bounds = bounds.func_72314_b(1.0, 0.3, 1.0);
        }
        BlockPos.PooledMutableBlockPos pos0 = BlockPos.PooledMutableBlockPos.func_185345_c((double)(bounds.field_72340_a + 0.001), (double)(bounds.field_72338_b + 0.001), (double)(bounds.field_72339_c + 0.001));
        BlockPos.PooledMutableBlockPos pos1 = BlockPos.PooledMutableBlockPos.func_185345_c((double)(bounds.field_72336_d - 0.001), (double)(bounds.field_72337_e - 0.001), (double)(bounds.field_72334_f - 0.001));
        BlockPos.PooledMutableBlockPos pos2 = BlockPos.PooledMutableBlockPos.func_185346_s();
        if (this.field_70170_p.func_175707_a((BlockPos)pos0, (BlockPos)pos1)) {
            for (int i = pos0.func_177958_n(); i <= pos1.func_177958_n(); ++i) {
                for (int j = pos0.func_177956_o(); j <= pos1.func_177956_o(); ++j) {
                    for (int k = pos0.func_177952_p(); k <= pos1.func_177952_p(); ++k) {
                        pos2.func_181079_c(i, j, k);
                        BlockState state = this.field_70170_p.func_180495_p((BlockPos)pos2);
                        try {
                            if (!this.field_70170_p.field_72995_K && state.func_185904_a() != Material.field_151579_a && state.func_177230_c() != Blocks.field_150425_aM) {
                                if (((Boolean)ConfigFlyingThings.general.allowToBreakPlant.get()).booleanValue() && isHighSpeed && !state.func_185904_a().func_76224_d() && (state.func_185904_a().func_76222_j() || state.func_185904_a() == Material.field_151585_k || state.func_185904_a() == Material.field_151584_j)) {
                                    this.field_70170_p.func_175655_b((BlockPos)pos2, true);
                                } else {
                                    state.func_177230_c().func_196262_a(state, this.field_70170_p, (BlockPos)pos2, (Entity)this);
                                }
                            }
                            this.func_191955_a(state);
                            continue;
                        }
                        catch (Throwable throwable) {
                            CrashReport crashreport = CrashReport.func_85055_a((Throwable)throwable, (String)"Colliding entity with block");
                            CrashReportCategory crashreportcategory = crashreport.func_85058_a("Block being collided with");
                            CrashReportCategory.func_175750_a((CrashReportCategory)crashreportcategory, (BlockPos)pos2, (BlockState)state);
                            throw new ReportedException(crashreport);
                        }
                    }
                }
            }
        }
    }

    protected boolean func_184219_q(Entity passenger) {
        return this.canFlyInDimension(this.field_70170_p.field_73011_w.func_186058_p()) && super.func_184219_q(passenger) && passenger instanceof PlayerEntity;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70057_ab() {
        this.setForwardDirection(-this.getForwardDirection());
        this.setTimeSinceHit(10);
        this.setDamageTaken(this.getDamageTaken() * 11.0f);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70016_h(double x, double y, double z) {
        this.velocityX = x;
        this.velocityY = y;
        this.velocityZ = z;
        this.func_213293_j(this.velocityX, this.velocityY, this.velocityZ);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180426_a(double x, double y, double z, float yaw, float pitch, int posRotationIncrements, boolean teleport) {
        this.lerpX = x;
        this.lerpY = y;
        this.lerpZ = z;
        this.lerpYaw = yaw;
        this.lerpPitch = pitch;
        this.func_213293_j(this.velocityX, this.velocityY, this.velocityZ);
        if (!this.func_184207_aI()) {
            this.lerpSteps = posRotationIncrements + 5;
        } else {
            double d3 = x - this.field_70165_t;
            double d4 = y - this.field_70163_u;
            double d5 = z - this.field_70161_v;
            double d6 = d3 * d3 + d4 * d4 + d5 * d5;
            if (d6 <= 1.0) {
                return;
            }
            this.lerpSteps = 3;
        }
    }

    protected void func_70081_e(int amount) {
    }

    protected boolean func_70041_e_() {
        return false;
    }

    @Nullable
    public Entity func_184179_bs() {
        List list = this.func_184188_bt();
        return list.isEmpty() ? null : (Entity)list.get(0);
    }

    public boolean func_70067_L() {
        return this.func_70089_S() && !this.func_184207_aI();
    }

    public void func_70108_f(Entity entity) {
        if (Helper.isFlyingthing(entity)) {
            if (entity.func_174813_aQ().field_72338_b < this.func_174813_aQ().field_72337_e) {
                super.func_70108_f(entity);
            }
        } else if (entity.func_174813_aQ().field_72338_b <= this.func_174813_aQ().field_72338_b) {
            super.func_70108_f(entity);
        }
    }

    public boolean func_70104_M() {
        return true;
    }

    public double func_70042_X() {
        return (double)this.func_213302_cg() * 0.5;
    }

    public double func_70033_W() {
        return 0.0;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_180431_b(source)) {
            return false;
        }
        if (!this.field_70170_p.field_72995_K && this.func_70089_S()) {
            boolean creativeDamage;
            if (source instanceof IndirectEntityDamageSource && source.func_76346_g() != null && this.func_184196_w(source.func_76346_g())) {
                return false;
            }
            this.setForwardDirection(-this.getForwardDirection());
            this.setTimeSinceHit(10);
            this.setDamageTaken(this.getDamageTaken() + amount * 10.0f);
            this.func_70018_K();
            boolean bl = creativeDamage = source.func_76346_g() instanceof PlayerEntity && ((PlayerEntity)source.func_76346_g()).field_71075_bZ.field_75098_d;
            if (creativeDamage || this.getDamageTaken() > 40.0f) {
                if (Helper.isValidPlayer(this.func_184179_bs())) {
                    ItemHandlerHelper.giveItemToPlayer((PlayerEntity)((PlayerEntity)this.func_184179_bs()), (ItemStack)this.getStack());
                } else {
                    this.func_70099_a(this.getStack(), 0.0f);
                }
                this.func_70106_y();
            }
        }
        return true;
    }

    protected void func_184200_o(Entity passenger) {
        super.func_184200_o(passenger);
        if (this.func_184186_bw() && this.lerpSteps > 0) {
            this.lerpSteps = 0;
            this.field_70165_t = this.lerpX;
            this.field_70163_u = this.lerpY;
            this.field_70161_v = this.lerpZ;
            this.field_70177_z = (float)this.lerpYaw;
            this.field_70125_A = (float)this.lerpPitch;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_184190_l(Entity entityToUpdate) {
        float f = MathHelper.func_76142_g((float)(entityToUpdate.field_70177_z - this.field_70177_z));
        float f1 = MathHelper.func_76131_a((float)f, (float)-105.0f, (float)105.0f);
        entityToUpdate.field_70126_B += f1 - f;
        entityToUpdate.field_70177_z += f1 - f;
        entityToUpdate.func_181013_g(this.field_70177_z);
    }

    public ITextComponent func_200200_C_() {
        Entity owner;
        if (!this.field_70170_p.field_72995_K && (owner = this.func_184179_bs()) != null) {
            return owner.func_200200_C_();
        }
        return super.func_200200_C_();
    }
}

