/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.flying_things.entity;

import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.DyeItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.world.World;
import net.minecraft.world.dimension.DimensionType;
import net.minecraftforge.fml.network.FMLPlayMessages;
import ovh.corail.flying_things.ConfigFlyingThings;
import ovh.corail.flying_things.entity.EntityAbstractFlyingThing;
import ovh.corail.flying_things.helper.Helper;
import ovh.corail.flying_things.item.ItemAbstractFlyingThing;
import ovh.corail.flying_things.item.ItemEnchantedBroom;
import ovh.corail.flying_things.registry.ModEntities;
import ovh.corail.flying_things.registry.ModItems;

public class EntityEnchantedBroom
extends EntityAbstractFlyingThing {
    private static final DataParameter<Integer> ENERGY = EntityDataManager.func_187226_a(EntityEnchantedBroom.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> TIME_SINCE_HIT = EntityDataManager.func_187226_a(EntityEnchantedBroom.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Float> DAMAGE_TAKEN = EntityDataManager.func_187226_a(EntityEnchantedBroom.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Integer> FORWARD_DIRECTION = EntityDataManager.func_187226_a(EntityEnchantedBroom.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> MODEL_TYPE = EntityDataManager.func_187226_a(EntityEnchantedBroom.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> HEAD_TYPE = EntityDataManager.func_187226_a(EntityEnchantedBroom.class, (IDataSerializer)DataSerializers.field_187192_b);

    public EntityEnchantedBroom(EntityType<EntityEnchantedBroom> entityType, World world) {
        super(entityType, world);
    }

    public EntityEnchantedBroom(World world, double x, double y, double z) {
        super(ModEntities.enchanted_broom, world, x, y, z);
    }

    public EntityEnchantedBroom(FMLPlayMessages.SpawnEntity spawnEntity, World world) {
        this(ModEntities.enchanted_broom, world);
    }

    @Override
    public ItemStack getStack() {
        ItemStack stack = new ItemStack((IItemProvider)ModItems.enchantedBroom);
        ItemAbstractFlyingThing.setModelType(stack, this.getModelType());
        if (this.func_145818_k_()) {
            stack.func_200302_a(this.func_200201_e());
        }
        ItemAbstractFlyingThing.setEnergy(stack, this.getEnergy());
        if (this.hasSoulbound()) {
            ItemAbstractFlyingThing.setSoulbound(stack);
        }
        if (this.getHeadType() > 0) {
            ItemEnchantedBroom.setHeadType(stack, this.getHeadType());
        }
        return stack;
    }

    @Override
    public boolean canFlyInDimension(DimensionType dimensionType) {
        if (this.field_70170_p.field_72995_K) {
            return true;
        }
        return !((List)ConfigFlyingThings.deniedDimensionToFly.deniedDimensionBroom.get()).contains(Helper.getDimensionString(dimensionType));
    }

    @Override
    public void func_70071_h_() {
        if (((Boolean)ConfigFlyingThings.general.allowSpecialRegen.get()).booleanValue() && this.getEnergy() < ConfigFlyingThings.General.getMaxEnergy() && this.field_70173_aa % 10 == 0 && this.field_70170_p.func_175667_e(this.func_180425_c().func_177977_b()) && this.field_70170_p.func_180495_p(this.func_180425_c().func_177977_b()).func_177230_c() == Blocks.field_150419_aX) {
            if (!this.field_70170_p.field_72995_K) {
                this.setEnergy(this.getEnergy() + 4);
                this.field_70170_p.func_184133_a(null, this.func_180425_c(), SoundEvents.field_193784_dd, SoundCategory.PLAYERS, 0.5f, 0.5f);
            } else {
                for (int i = 0; i < Helper.getRandom(10, 45); ++i) {
                    this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197607_R, this.field_70165_t + this.field_70146_Z.nextGaussian() * 0.4, this.func_174813_aQ().field_72337_e + this.field_70146_Z.nextGaussian() * (double)0.13f, this.field_70161_v + this.field_70146_Z.nextGaussian() * 0.4, 0.0, 0.0, 0.0);
                }
            }
        }
        super.func_70071_h_();
    }

    @Override
    public double func_70042_X() {
        return 0.0;
    }

    @Override
    protected boolean onInteractWithPlayerItem(ItemStack stack, PlayerEntity player, Hand hand) {
        if (stack.func_77973_b() instanceof DyeItem) {
            this.setModelType(((DyeItem)stack.func_77973_b()).func_195962_g().func_196059_a());
            if (!player.field_71075_bZ.field_75098_d) {
                stack.func_190918_g(1);
            }
            return true;
        }
        if (stack.func_77973_b() == Item.func_150898_a((Block)Blocks.field_196577_ad)) {
            this.setModelType(12);
            return true;
        }
        if (stack.func_77973_b() == Items.field_151057_cb && stack.func_82837_s()) {
            this.func_200203_b(stack.func_200301_q());
            if (!player.field_71075_bZ.field_75098_d) {
                stack.func_190918_g(1);
            }
            return true;
        }
        if (Helper.isDateAroundHalloween()) {
            if (stack.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150423_aK)) {
                this.setHeadType(1);
                if (!player.field_71075_bZ.field_75098_d) {
                    stack.func_190918_g(1);
                }
                return true;
            }
            if (stack.func_77973_b() == Items.field_196182_dv) {
                this.setHeadType(2);
                if (!player.field_71075_bZ.field_75098_d) {
                    stack.func_190918_g(1);
                }
                return true;
            }
        }
        return false;
    }

    @Override
    protected DataParameter<Integer> getDataEnergy() {
        return ENERGY;
    }

    @Override
    public DataParameter<Float> getDataDamageTaken() {
        return DAMAGE_TAKEN;
    }

    @Override
    protected DataParameter<Integer> getDataTimeSinceHit() {
        return TIME_SINCE_HIT;
    }

    @Override
    protected DataParameter<Integer> getDataForwardDirection() {
        return FORWARD_DIRECTION;
    }

    @Override
    protected DataParameter<Integer> getDataModelType() {
        return MODEL_TYPE;
    }

    public int getHeadType() {
        return (Integer)this.field_70180_af.func_187225_a(HEAD_TYPE);
    }

    public void setHeadType(int headType) {
        this.field_70180_af.func_187227_b(HEAD_TYPE, (Object)headType);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(HEAD_TYPE, (Object)0);
    }

    @Override
    public void func_213281_b(CompoundNBT tag) {
        super.func_213281_b(tag);
        tag.func_74768_a("head_type", this.getHeadType());
    }

    @Override
    public void func_70037_a(CompoundNBT tag) {
        super.func_70037_a(tag);
        if (tag.func_150297_b("head_type", 3)) {
            this.setHeadType(tag.func_74762_e("head_type"));
        }
    }
}

