/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.flying_things.event;

import com.mojang.blaze3d.platform.GlStateManager;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.entity.Entity;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.client.event.RenderBlockOverlayEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import ovh.corail.flying_things.ConfigFlyingThings;
import ovh.corail.flying_things.gui.GuiOverlayEnergy;
import ovh.corail.flying_things.gui.GuiOverlaySpeed;
import ovh.corail.flying_things.helper.Helper;

@OnlyIn(value=Dist.CLIENT)
@Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="flying_things", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ClientEventHandler {
    private static boolean IS_DEV = false;
    private static boolean HAS_TRUE_SIGHT = false;
    private static boolean REQUIRE_REMOVAL_NIGHTVISION = false;

    @SubscribeEvent(priority=EventPriority.HIGHEST, receiveCanceled=true)
    public static void onFogDensity(EntityViewRenderEvent.FogDensity event) {
        if (HAS_TRUE_SIGHT && event.getInfo().getBlockAtCamera().func_185904_a() == Material.field_151586_h) {
            event.setCanceled(true);
            event.setDensity(event.getDensity() / 4.0f);
            GlStateManager.fogMode((GlStateManager.FogMode)GlStateManager.FogMode.EXP);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST, receiveCanceled=true)
    public static void onRenderFog(EntityViewRenderEvent.FogColors event) {
        if (HAS_TRUE_SIGHT && event.getInfo().getBlockAtCamera().func_185904_a() == Material.field_151586_h) {
            event.setRed(0.09019608f);
            event.setGreen(0.41568628f);
            event.setBlue(0.9254902f);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onRenderBlockLayer(RenderBlockOverlayEvent event) {
        if (HAS_TRUE_SIGHT && event.getOverlayType() == RenderBlockOverlayEvent.OverlayType.WATER) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onRenderTick(TickEvent.RenderTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
            boolean bl = HAS_TRUE_SIGHT = (Boolean)ConfigFlyingThings.general.allowToFlyInWater.get() != false && Helper.isRidingFlyingThing((Entity)player) && Minecraft.func_71410_x().field_71460_t.func_215316_n().getBlockAtCamera().func_185904_a() == Material.field_151586_h;
            if (HAS_TRUE_SIGHT && !player.func_70644_a(Effects.field_76439_r)) {
                player.func_195064_c(new EffectInstance(Effects.field_76439_r, 1200, 0, true, false));
                REQUIRE_REMOVAL_NIGHTVISION = true;
            }
        } else if (REQUIRE_REMOVAL_NIGHTVISION) {
            Minecraft.func_71410_x().field_71439_g.func_184596_c(Effects.field_76439_r);
            REQUIRE_REMOVAL_NIGHTVISION = false;
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onGuiRender(GuiScreenEvent.DrawScreenEvent event) {
        if (REQUIRE_REMOVAL_NIGHTVISION) {
            Minecraft.func_71410_x().field_71439_g.func_184596_c(Effects.field_76439_r);
            REQUIRE_REMOVAL_NIGHTVISION = false;
        }
    }

    @SubscribeEvent
    public static void onRenderGui(RenderGameOverlayEvent.Post event) {
        if (event.getType() != RenderGameOverlayEvent.ElementType.EXPERIENCE) {
            return;
        }
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (Helper.isRidingFlyingThing((Entity)player)) {
            new GuiOverlayEnergy(Minecraft.func_71410_x());
            if (IS_DEV && Minecraft.func_71410_x().field_71474_y.field_74330_P) {
                new GuiOverlaySpeed(Minecraft.func_71410_x());
            }
        }
    }
}

