/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.flying_things.event;

import java.lang.reflect.Field;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkStatus;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraft.world.storage.loot.LootTables;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.LogicalSidedProvider;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.items.ItemHandlerHelper;
import ovh.corail.flying_things.ConfigFlyingThings;
import ovh.corail.flying_things.ModFlyingThings;
import ovh.corail.flying_things.entity.EntityAbstractFlyingThing;
import ovh.corail.flying_things.helper.Helper;
import ovh.corail.flying_things.registry.ModItems;

@Mod.EventBusSubscriber(modid="flying_things", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class EventHandler {
    private static ResourceLocation LOOTTABLE_SPECIAL = new ResourceLocation("flying_things", "special");
    private static final Field fieldIsFrozen = ObfuscationReflectionHelper.findField(LootTable.class, (String)"isFrozen");

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onLootTableLoad(LootTableLoadEvent event) {
        if (event.getName().equals((Object)LootTables.field_186387_al)) {
            MinecraftServer server = (MinecraftServer)LogicalSidedProvider.INSTANCE.get(LogicalSide.SERVER);
            server.func_213165_a(() -> {
                LootTable specialTable = event.getLootTableManager().func_186521_a(LOOTTABLE_SPECIAL);
                if (specialTable == LootTable.field_186464_a) {
                    ModFlyingThings.LOGGER.warn("The loottable for flying things is absent");
                } else {
                    LootPool chestTreasure = specialTable.getPool("flying_things:chest_treasure");
                    for (String targetTableString : (List)ConfigFlyingThings.general.treasureLootTable.get()) {
                        LootTable targetTable = event.getLootTableManager().func_186521_a(new ResourceLocation(targetTableString));
                        if (targetTable == LootTable.field_186464_a) continue;
                        try {
                            fieldIsFrozen.set(targetTable, false);
                            targetTable.addPool(chestTreasure);
                            fieldIsFrozen.set(targetTable, true);
                        }
                        catch (IllegalAccessException e) {
                            e.printStackTrace();
                        }
                    }
                }
            });
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onBossDrops(LivingDropsEvent event) {
        LivingEntity entity = event.getEntityLiving();
        if (Helper.isBoss((Entity)entity)) {
            if (Helper.getRandom(1, 100) <= (Integer)ConfigFlyingThings.general.chanceDropPhialOfAnimationOnBoss.get()) {
                event.getDrops().add(new ItemEntity(entity.field_70170_p, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, new ItemStack((IItemProvider)ModItems.phialOfAnimation)));
            }
        } else if (entity instanceof MonsterEntity && Helper.isDateAroundHalloween() && event.getSource() != null && event.getSource().func_76346_g() instanceof PlayerEntity && Helper.getRandom(1, 100) <= (Integer)ConfigFlyingThings.general.chanceDropPumpkinStick.get()) {
            event.getDrops().add(new ItemEntity(entity.field_70170_p, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, new ItemStack((IItemProvider)ModItems.pumpkinStick)));
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onLivingFall(LivingFallEvent event) {
        if (Helper.isRidingFlyingThing((Entity)event.getEntityLiving())) {
            event.setDistance(0.0f);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onLivingInWall(LivingDamageEvent event) {
        if (event.getSource() == DamageSource.field_76368_d && Helper.isRidingFlyingThing((Entity)event.getEntityLiving())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onProjectileImpact(ProjectileImpactEvent event) {
        if (event.getEntity() == null) {
            return;
        }
        Entity rider = event.getEntity();
        if (Helper.isRidingFlyingThing(rider) && (Integer)ConfigFlyingThings.general.chanceToFallWithProjectile.get() != 0 && Helper.getRandom(1, 100) < (Integer)ConfigFlyingThings.general.chanceToFallWithProjectile.get()) {
            rider.func_184210_p();
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onLivingDeath(LivingDeathEvent event) {
        EntityAbstractFlyingThing flying_thing;
        if (Helper.isControllingFlyingThing((Entity)event.getEntityLiving()) && (flying_thing = (EntityAbstractFlyingThing)event.getEntityLiving().func_184187_bx()) != null) {
            if (Helper.isValidPlayer((Entity)event.getEntityLiving()) && flying_thing.hasSoulbound()) {
                ItemHandlerHelper.giveItemToPlayer((PlayerEntity)((PlayerEntity)event.getEntityLiving()), (ItemStack)flying_thing.getStack());
            } else {
                event.getEntityLiving().func_70099_a(flying_thing.getStack(), 0.0f);
            }
            flying_thing.func_70106_y();
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onPlayerLogout(PlayerEvent.PlayerLoggedOutEvent event) {
        Entity mount;
        if (Helper.isValidPlayerMP((Entity)event.getPlayer()) && Helper.isControllingFlyingThing((Entity)event.getPlayer()) && (mount = event.getPlayer().func_184187_bx()) != null) {
            event.getPlayer().func_184210_p();
            ((Chunk)event.getPlayer().field_70170_p.func_217348_a(mount.field_70176_ah, mount.field_70164_aj, ChunkStatus.field_222617_m)).func_76630_e();
        }
    }
}

