/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.flying_things.gui;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.entity.Entity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import ovh.corail.flying_things.ConfigFlyingThings;
import ovh.corail.flying_things.entity.EntityAbstractFlyingThing;
import ovh.corail.flying_things.helper.Helper;

@OnlyIn(value=Dist.CLIENT)
public class GuiOverlaySpeed
extends Screen {
    private final Minecraft mc;
    private final FontRenderer fontRenderer;
    private final int width;
    private final int height;
    private final int guiLeft;
    private final int guiTop;
    private final int guiWidth = 128;
    private final int guiHeight = 128;

    public GuiOverlaySpeed(Minecraft mc) {
        super((ITextComponent)new StringTextComponent("Flying Things Speed"));
        this.mc = mc;
        this.fontRenderer = this.mc.field_71466_p;
        this.width = this.mc.field_195558_d.func_198107_o();
        this.height = this.mc.field_195558_d.func_198087_p();
        ((Object)((Object)this)).getClass();
        this.guiLeft = this.width - 128 + 10;
        ((Object)((Object)this)).getClass();
        this.guiTop = this.height - 128 + 60;
        this.drawScreen();
    }

    private void drawScreen() {
        if (Helper.isRidingFlyingThing((Entity)this.mc.field_71439_g)) {
            EntityAbstractFlyingThing mount = (EntityAbstractFlyingThing)this.mc.field_71439_g.func_184187_bx();
            assert (mount != null);
            ((Object)((Object)this)).getClass();
            ((Object)((Object)this)).getClass();
            GuiOverlaySpeed.fill((int)this.guiLeft, (int)this.guiTop, (int)(this.guiLeft + 128), (int)(this.guiTop + 128), (int)0);
            this.drawString(this.fontRenderer, "Speed : " + String.format("%,.2f", mount.speed * 100.0) + " / " + ConfigFlyingThings.General.getSpeedMax(), this.guiLeft + 10, this.guiTop + 10, 0xFFFFFF);
            this.drawString(this.fontRenderer, "Energy : " + mount.getEnergy() + " / " + ConfigFlyingThings.General.getMaxEnergy(), this.guiLeft + 10, this.guiTop + 20, 0xFFFFFF);
        }
    }
}

