/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.flying_things.item;

import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.EnchantedBookItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.dimension.DimensionType;
import net.minecraftforge.registries.ForgeRegistries;
import ovh.corail.flying_things.ConfigFlyingThings;
import ovh.corail.flying_things.entity.EntityAbstractFlyingThing;
import ovh.corail.flying_things.helper.NBTStackHelper;
import ovh.corail.flying_things.item.ItemGeneric;

public abstract class ItemAbstractFlyingThing
extends ItemGeneric {
    private static final ResourceLocation SOULBOUND_LOCATION = new ResourceLocation("tombstone", "soulbound");

    abstract EntityType<?> getEntityType();

    abstract boolean canFlyInDimension(DimensionType var1);

    abstract void onEntitySpawn(ItemStack var1, EntityAbstractFlyingThing var2);

    ItemAbstractFlyingThing(String name, Item.Properties builder) {
        super(name, builder);
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (player.func_184218_aH() || player.func_184811_cZ().func_185141_a((Item)this)) {
            return ActionResult.newResult((ActionResultType)ActionResultType.FAIL, (Object)stack);
        }
        if (stack.func_77973_b() != this) {
            return ActionResult.newResult((ActionResultType)ActionResultType.PASS, (Object)stack);
        }
        if (!world.field_72995_K) {
            EntityAbstractFlyingThing entity;
            MinecraftServer server = player.field_70170_p.func_73046_m();
            if (server != null && !server.func_71231_X()) {
                player.func_145747_a((ITextComponent)new TranslationTextComponent("flying_things.message.flight_not_allowed", new Object[0]));
                return ActionResult.newResult((ActionResultType)ActionResultType.FAIL, (Object)stack);
            }
            if (!this.canFlyInDimension(world.field_73011_w.func_186058_p())) {
                player.func_145747_a((ITextComponent)new TranslationTextComponent("flying_things.message.denied_dimension_to_fly", new Object[]{stack.func_200301_q()}));
                return ActionResult.newResult((ActionResultType)ActionResultType.FAIL, (Object)stack);
            }
            player.func_184811_cZ().func_185145_a((Item)this, 100);
            try {
                entity = (EntityAbstractFlyingThing)this.getEntityType().func_200721_a(world);
            }
            catch (Exception e) {
                return ActionResult.newResult((ActionResultType)ActionResultType.FAIL, (Object)stack);
            }
            if (entity != null) {
                entity.setModelType(ItemAbstractFlyingThing.getModelType(player.func_184586_b(hand)));
                entity.setEnergy(ItemAbstractFlyingThing.getEnergy(stack));
                entity.setSoulbound(ItemAbstractFlyingThing.hasSoulbound(stack));
                if (stack.func_82837_s()) {
                    entity.func_200203_b(stack.func_200301_q());
                }
                entity.func_70080_a(player.field_70165_t, player.field_70163_u, player.field_70161_v, player.field_70177_z, 0.0f);
                entity.func_70034_d(player.field_70177_z);
                this.onEntitySpawn(stack, entity);
                world.func_217376_c((Entity)entity);
                if (!player.func_70093_af()) {
                    player.func_184220_m((Entity)entity);
                }
                player.func_184611_a(hand, ItemStack.field_190927_a);
            }
        }
        return ActionResult.newResult((ActionResultType)ActionResultType.SUCCESS, (Object)stack);
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return ItemAbstractFlyingThing.getEnergy(stack) < ConfigFlyingThings.General.getMaxEnergy();
    }

    public int getRGBDurabilityForDisplay(ItemStack stack) {
        return MathHelper.func_181758_c((float)(Math.max(0.0f, (float)(1.0 - this.getDurabilityForDisplay(stack))) / 1.5f), (float)1.0f, (float)1.0f);
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return 1.0 - (double)ItemAbstractFlyingThing.getEnergy(stack) / (double)ConfigFlyingThings.General.getMaxEnergy();
    }

    public static void setEnergy(ItemStack stack, int energy) {
        if (stack.func_77973_b() instanceof ItemAbstractFlyingThing) {
            NBTStackHelper.setInteger(stack, "energy", MathHelper.func_76125_a((int)energy, (int)0, (int)ConfigFlyingThings.General.getMaxEnergy()));
        }
    }

    private static int getEnergy(ItemStack stack) {
        if (stack.func_77973_b() instanceof ItemAbstractFlyingThing) {
            if (NBTStackHelper.hasKeyName(stack, "energy")) {
                return MathHelper.func_76125_a((int)NBTStackHelper.getInteger(stack, "energy"), (int)0, (int)ConfigFlyingThings.General.getMaxEnergy());
            }
            ItemAbstractFlyingThing.setEnergy(stack, ConfigFlyingThings.General.getMaxEnergy());
            return ConfigFlyingThings.General.getMaxEnergy();
        }
        return 0;
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int slot, boolean isSelected) {
        if (!world.field_72995_K && ItemAbstractFlyingThing.getEnergy(stack) < ConfigFlyingThings.General.getMaxEnergy() && entity.field_70173_aa % ((Integer)ConfigFlyingThings.general.timeToRecoverEnergy.get() * 20) == 0) {
            ItemAbstractFlyingThing.setEnergy(stack, ItemAbstractFlyingThing.getEnergy(stack) + this.getActualRegen(stack, world, entity, slot, isSelected));
        }
    }

    public int getActualRegen(ItemStack stack, World world, Entity entity, int slot, boolean isSelected) {
        return 1;
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return oldStack.func_77973_b() != newStack.func_77973_b();
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        if (enchantment == null) {
            return false;
        }
        assert (enchantment.getRegistryName() != null);
        return ConfigFlyingThings.General.isSoulboundAllowed() && stack.func_77986_q().size() == 0 && enchantment.getRegistryName().equals((Object)SOULBOUND_LOCATION);
    }

    public int func_77619_b() {
        return 1;
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return ConfigFlyingThings.General.isSoulboundAllowed() && stack.func_77986_q().size() == 0 && EnchantedBookItem.func_92110_g((ItemStack)book).size() == 1 && ItemAbstractFlyingThing.hasSoulbound(book);
    }

    public static void setSoulbound(ItemStack stack) {
        if (!ConfigFlyingThings.General.isSoulboundAllowed()) {
            return;
        }
        Enchantment soulbound = (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(SOULBOUND_LOCATION);
        if (soulbound == null) {
            return;
        }
        stack.func_77966_a(soulbound, 1);
    }

    private static boolean hasSoulbound(ItemStack stack) {
        if (!ConfigFlyingThings.General.isSoulboundAllowed()) {
            return false;
        }
        Enchantment soulbound = (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(SOULBOUND_LOCATION);
        if (soulbound == null) {
            return false;
        }
        for (Enchantment enchant : EnchantmentHelper.func_82781_a((ItemStack)stack).keySet()) {
            if (!SOULBOUND_LOCATION.equals((Object)enchant.getRegistryName())) continue;
            return true;
        }
        return false;
    }

    public static ItemStack setModelType(ItemStack stack, int modelType) {
        return NBTStackHelper.setInteger(stack, "model_type", modelType);
    }

    public static int getModelType(ItemStack stack) {
        return NBTStackHelper.getInteger(stack, "model_type", 0);
    }
}

