/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.flying_things.item;

import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import ovh.corail.flying_things.helper.NBTStackHelper;
import ovh.corail.flying_things.registry.ModTabs;

public class ItemGeneric
extends Item {
    protected final String name;
    private boolean hasEffect = false;

    public ItemGeneric(String name) {
        this(name, ItemGeneric.getBuilder(true));
    }

    public ItemGeneric(String name, boolean hasTab) {
        this(name, ItemGeneric.getBuilder(hasTab));
    }

    public ItemGeneric(String name, Item.Properties builder) {
        super(builder);
        this.name = name;
    }

    public String getSimpleName() {
        return this.name;
    }

    public ItemGeneric withEffect() {
        this.hasEffect = true;
        return this;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_77636_d(ItemStack stack) {
        return this.hasEffect || NBTStackHelper.getBoolean(stack, "enchant");
    }

    public String func_77667_c(ItemStack stack) {
        return "flying_things.item." + this.name;
    }

    static Item.Properties getBuilder(boolean hasTab) {
        return new Item.Properties().func_200916_a((ItemGroup)(hasTab ? ModTabs.tabFlyingThings : null)).func_200917_a(64);
    }
}

