/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.flying_things.render;

import com.mojang.blaze3d.platform.GlStateManager;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.culling.ICamera;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import ovh.corail.flying_things.ConfigFlyingThings;
import ovh.corail.flying_things.entity.EntityAbstractFlyingThing;
import ovh.corail.flying_things.entity.EntityEnchantedBroom;
import ovh.corail.flying_things.helper.TextureLocation;
import ovh.corail.flying_things.model.ModelEnchantedBroom;

@OnlyIn(value=Dist.CLIENT)
public class RenderEnchantedBroom<T extends EntityEnchantedBroom>
extends EntityRenderer<T> {
    private final ModelEnchantedBroom<T> model = new ModelEnchantedBroom();
    private final float scale = 0.0625f;

    public RenderEnchantedBroom(EntityRendererManager renderManager) {
        super(renderManager);
        this.field_76987_f = 0.2f;
        this.field_76989_e = 0.2f;
    }

    public ResourceLocation getEntityTexture(T entity) {
        return TextureLocation.TEXTURE_CONCRETE[((EntityAbstractFlyingThing)((Object)entity)).getModelType() < TextureLocation.TEXTURE_CONCRETE.length ? ((EntityAbstractFlyingThing)((Object)entity)).getModelType() : 12];
    }

    public void doRender(T entity, double x, double y, double z, float entityYaw, float partialTicks) {
        this.renderBroom(entity, x, y, z, entityYaw, partialTicks, false);
    }

    public boolean shouldRender(T livingEntity, ICamera camera, double camX, double camY, double camZ) {
        return true;
    }

    void renderBroom(T entity, double x, double y, double z, float entityYaw, float partialTicks, boolean isItemStack) {
        float rotationYawHead;
        float rotationPitch;
        float ageInTicks;
        if (isItemStack) {
            ageInTicks = (float)Minecraft.func_71410_x().field_71439_g.field_70173_aa + partialTicks;
            rotationPitch = 0.0f;
            float rotationYaw = 0.0f;
            rotationYawHead = 0.0f;
        } else {
            ageInTicks = (float)((EntityEnchantedBroom)((Object)entity)).field_70173_aa + partialTicks;
            rotationYawHead = entity.func_70079_am();
            float rotationYaw = ((EntityEnchantedBroom)((Object)entity)).field_70177_z;
            rotationPitch = 0.0f;
        }
        float limbSwing = ageInTicks / 80.0f;
        GlStateManager.pushMatrix();
        GlStateManager.enableCull();
        if (!isItemStack) {
            GlStateManager.translated((double)x, (double)(y + 0.2), (double)z);
        }
        GlStateManager.rotatef((float)(180.0f - entityYaw), (float)0.0f, (float)1.0f, (float)0.0f);
        if (!isItemStack) {
            float f = (float)((EntityAbstractFlyingThing)((Object)entity)).getTimeSinceHit() - partialTicks;
            float f1 = ((EntityAbstractFlyingThing)((Object)entity)).getDamageTaken() - partialTicks;
            if (f1 < 0.0f) {
                f1 = 0.0f;
            }
            if (f > 0.0f) {
                GlStateManager.rotatef((float)(MathHelper.func_76126_a((float)f) * f * f1 / 10.0f * (float)((EntityAbstractFlyingThing)((Object)entity)).getForwardDirection()), (float)1.0f, (float)0.0f, (float)0.0f);
            }
        }
        GlStateManager.pushMatrix();
        this.func_110776_a(TextureLocation.TEXTURE_HAY);
        this.model.render(entity, limbSwing, 0.0f, ageInTicks, rotationYawHead, rotationPitch, 0.0625f);
        GlStateManager.popMatrix();
        GlStateManager.pushMatrix();
        this.func_180548_c((Entity)entity);
        this.model.stick.func_78785_a(0.0625f);
        GlStateManager.popMatrix();
        if (((EntityEnchantedBroom)((Object)entity)).getHeadType() > 0) {
            GlStateManager.pushMatrix();
            this.func_110776_a(TextureLocation.TEXTURE_SKULL[((EntityEnchantedBroom)((Object)entity)).getHeadType() - 1]);
            GlStateManager.rotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            this.model.head.func_78785_a(0.0625f);
            GlStateManager.popMatrix();
        }
        this.doRenderLayer(entity, limbSwing, 0.0f, ageInTicks, rotationYawHead, rotationPitch);
        GlStateManager.disableCull();
        GlStateManager.popMatrix();
        if (!isItemStack) {
            super.func_76986_a(entity, x, y, z, entityYaw, partialTicks);
        }
    }

    private void doRenderLayer(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        if (!((Boolean)ConfigFlyingThings.client.renderEffect.get()).booleanValue()) {
            return;
        }
        GlStateManager.pushMatrix();
        boolean flag = !entity.func_82150_aj();
        GlStateManager.depthMask((!flag ? 1 : 0) != 0);
        this.func_110776_a(TextureLocation.TEXTURE_EFFECT);
        GlStateManager.matrixMode((int)5890);
        GlStateManager.loadIdentity();
        GlStateManager.translatef((float)(ageInTicks * 0.01f), (float)(ageInTicks * 0.01f), (float)0.0f);
        GlStateManager.matrixMode((int)5888);
        GlStateManager.enableBlend();
        GlStateManager.color4f((float)0.5f, (float)0.5f, (float)0.5f, (float)1.0f);
        GlStateManager.disableLighting();
        GlStateManager.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
        this.model.func_217111_a(this.model);
        Minecraft.func_71410_x().field_71460_t.func_191514_d(true);
        this.model.render(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, this.scale);
        this.model.stick.func_78785_a(this.scale);
        Minecraft.func_71410_x().field_71460_t.func_191514_d(false);
        GlStateManager.matrixMode((int)5890);
        GlStateManager.loadIdentity();
        GlStateManager.matrixMode((int)5888);
        GlStateManager.enableLighting();
        GlStateManager.depthMask((boolean)flag);
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.popMatrix();
    }
}

