/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.hats.common.packet;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import me.ichun.mods.hats.client.gui.GuiTradeWindow;
import me.ichun.mods.hats.common.Hats;
import me.ichun.mods.hats.common.trade.TradeInfo;
import me.ichun.mods.ichunutil.common.core.network.AbstractPacket;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PacketTradeOffers
extends AbstractPacket {
    public TreeMap<String, Integer> tradeHats;
    public ArrayList<ItemStack> tradeItems;

    public PacketTradeOffers() {
    }

    public PacketTradeOffers(TreeMap<String, Integer> hats, ArrayList<ItemStack> items) {
        this.tradeHats = hats;
        this.tradeItems = items;
    }

    public void writeTo(ByteBuf buffer) {
        buffer.writeInt(this.tradeHats.size());
        for (Map.Entry<String, Integer> e : this.tradeHats.entrySet()) {
            ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)e.getKey());
            buffer.writeInt(e.getValue().intValue());
        }
        buffer.writeInt(this.tradeItems.size());
        for (ItemStack is : this.tradeItems) {
            ByteBufUtils.writeTag((ByteBuf)buffer, (NBTTagCompound)is.func_77955_b(new NBTTagCompound()));
        }
    }

    public void readFrom(ByteBuf buffer) {
        this.tradeHats = new TreeMap();
        this.tradeItems = new ArrayList();
        int hatCount = buffer.readInt();
        for (int i = 0; i < hatCount; ++i) {
            this.tradeHats.put(ByteBufUtils.readUTF8String((ByteBuf)buffer), buffer.readInt());
        }
        int itemCount = buffer.readInt();
        for (int i = 0; i < itemCount; ++i) {
            ItemStack is = new ItemStack(ByteBufUtils.readTag((ByteBuf)buffer));
            if (is.func_190926_b()) continue;
            this.tradeItems.add(is);
        }
    }

    public void execute(Side side, EntityPlayer player) {
        if (side.isServer()) {
            for (TradeInfo ti : Hats.eventHandlerServer.activeTrades) {
                if (!ti.isPlayerInTrade(player)) continue;
                ti.receiveTradeInfo(this.tradeHats, this.tradeItems, (EntityPlayerMP)player);
                break;
            }
        } else {
            this.handleClient(side, player);
        }
    }

    public Side receivingSide() {
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public void handleClient(Side side, EntityPlayer player) {
        if (Minecraft.func_71410_x().field_71462_r instanceof GuiTradeWindow) {
            float currentBoxes;
            GuiTradeWindow trade = (GuiTradeWindow)Minecraft.func_71410_x().field_71462_r;
            HashMap<String, Integer> oldHats = new HashMap<String, Integer>(trade.theirHatsForTrade);
            ArrayList<ItemStack> oldItems = new ArrayList<ItemStack>(trade.theirItemsForTrade);
            trade.theirHatsForTrade = this.tradeHats;
            trade.theirItemsForTrade = this.tradeItems;
            int tradeSize = oldItems.size();
            int hatsSize = oldHats.size();
            boolean bl = trade.theirCanScroll = trade.theirHatsForTrade.size() > 3 || trade.theirItemsForTrade.size() > 6;
            if (!trade.theirCanScroll) {
                trade.theirScrollProg = 0.0f;
            } else if (tradeSize != trade.theirItemsForTrade.size() && (trade.theirItemsForTrade.size() % 6 == 1 && tradeSize % 6 == 0 || trade.theirItemsForTrade.size() % 6 == 0 && tradeSize % 6 == 1)) {
                float currentBoxes2 = (float)Math.ceil((float)Math.max(trade.theirHatsForTrade.size(), 3) / 3.0f) * 2.0f + (float)Math.ceil((float)Math.max(tradeSize, 6) / 6.0f) - 3.0f;
                if (currentBoxes2 > 0.0f) {
                    trade.theirScrollProg = MathHelper.func_76131_a((float)(trade.theirScrollProg * (trade.theirItemsForTrade.size() > tradeSize ? currentBoxes2 / (currentBoxes2 + 1.0f) : currentBoxes2 / (currentBoxes2 - 1.0f))), (float)0.0f, (float)1.0f);
                }
            } else if (hatsSize != trade.theirHatsForTrade.size() && (trade.theirHatsForTrade.size() % 3 == 1 && hatsSize % 3 == 0 || trade.theirHatsForTrade.size() % 3 == 0 && hatsSize % 3 == 1) && (currentBoxes = (float)Math.ceil((float)Math.max(hatsSize, 3) / 3.0f) * 2.0f + (float)Math.ceil((float)Math.max(trade.theirItemsForTrade.size(), 6) / 6.0f) - 3.0f) > 0.0f) {
                trade.theirScrollProg = MathHelper.func_76131_a((float)(trade.theirScrollProg * (trade.theirHatsForTrade.size() > hatsSize ? currentBoxes / (currentBoxes + 2.0f) : currentBoxes / (currentBoxes - 2.0f))), (float)0.0f, (float)1.0f);
            }
        }
    }
}

