/*
 * Decompiled with CFR 0.152.
 */
package com.alexanderstrada.practicaltools;

import java.util.Random;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ForgeMod;

public class ToolFunctions {
    public static final Random random = new Random();

    public static void attemptBreakNeighbors(World world, BlockPos pos, PlayerEntity player, Set<Block> effectiveOn, Set<Material> effectiveMaterials, boolean checkHarvestLevel) {
        RayTraceResult trace = ToolFunctions.calcRayTrace(world, player, RayTraceContext.FluidMode.ANY);
        if (trace.func_216346_c() == RayTraceResult.Type.BLOCK) {
            BlockRayTraceResult blockTrace = (BlockRayTraceResult)trace;
            Direction face = blockTrace.func_216354_b();
            int fortuneLevel = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)player.func_184614_ca());
            int silkLevel = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185306_r, (ItemStack)player.func_184614_ca());
            for (int a = -1; a <= 1; ++a) {
                for (int b = -1; b <= 1; ++b) {
                    if (a == 0 && b == 0) continue;
                    BlockPos target = null;
                    if (face == Direction.UP || face == Direction.DOWN) {
                        target = pos.func_177982_a(a, 0, b);
                    }
                    if (face == Direction.NORTH || face == Direction.SOUTH) {
                        target = pos.func_177982_a(a, b, 0);
                    }
                    if (face == Direction.EAST || face == Direction.WEST) {
                        target = pos.func_177982_a(0, a, b);
                    }
                    ToolFunctions.attemptBreak(world, target, player, effectiveOn, effectiveMaterials, fortuneLevel, silkLevel, checkHarvestLevel);
                }
            }
        }
    }

    public static void attemptBreak(World world, BlockPos pos, PlayerEntity player, Set<Block> effectiveOn, Set<Material> effectiveMaterials, int fortuneLevel, int silkLevel, boolean checkHarvestLevel) {
        BlockState state = world.func_180495_p(pos);
        boolean validHarvest = !checkHarvestLevel || player.func_184614_ca().func_150998_b(state);
        boolean isEffective = effectiveOn.contains(state.func_177230_c()) || effectiveMaterials.contains(state.func_185904_a());
        boolean witherImmune = BlockTags.field_219755_X.func_230236_b_().contains(state.func_177230_c());
        if (validHarvest && isEffective && !witherImmune) {
            world.func_175655_b(pos, false);
            Block.func_220054_a((BlockState)state, (World)world, (BlockPos)pos, null, (Entity)player, (ItemStack)player.func_184614_ca());
            int exp = state.getExpDrop((IWorldReader)world, pos, fortuneLevel, silkLevel);
            if (exp > 0) {
                state.func_177230_c().func_180637_b((ServerWorld)world, pos, exp);
            }
        }
    }

    public static RayTraceResult calcRayTrace(World worldIn, PlayerEntity player, RayTraceContext.FluidMode fluidMode) {
        float f = player.field_70125_A;
        float f1 = player.field_70177_z;
        Vector3d vector3d = player.func_174824_e(1.0f);
        float f2 = MathHelper.func_76134_b((float)(-f1 * ((float)Math.PI / 180) - (float)Math.PI));
        float f3 = MathHelper.func_76126_a((float)(-f1 * ((float)Math.PI / 180) - (float)Math.PI));
        float f4 = -MathHelper.func_76134_b((float)(-f * ((float)Math.PI / 180)));
        float f5 = MathHelper.func_76126_a((float)(-f * ((float)Math.PI / 180)));
        float f6 = f3 * f4;
        float f7 = f2 * f4;
        double d0 = player.func_110148_a((Attribute)ForgeMod.REACH_DISTANCE.get()).func_111126_e();
        Vector3d vector3d1 = vector3d.func_72441_c((double)f6 * d0, (double)f5 * d0, (double)f7 * d0);
        return worldIn.func_217299_a(new RayTraceContext(vector3d, vector3d1, RayTraceContext.BlockMode.OUTLINE, fluidMode, (Entity)player));
    }
}

