/*
 * Decompiled with CFR 0.152.
 */
package com.alexanderstrada.practicaltools.items;

import com.alexanderstrada.practicaltools.ModConfig;
import com.alexanderstrada.practicaltools.ToolFunctions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.AxeItem;
import net.minecraft.item.IItemTier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class GreataxeItem
extends AxeItem {
    public static final Set<Block> EFFECTIVE_ON = Sets.newHashSet((Object[])new Block[]{Blocks.field_196662_n, Blocks.field_196664_o, Blocks.field_196666_p, Blocks.field_196668_q, Blocks.field_196670_r, Blocks.field_196672_s, Blocks.field_150342_X, Blocks.field_196626_Q, Blocks.field_196629_R, Blocks.field_196631_S, Blocks.field_196634_T, Blocks.field_196637_U, Blocks.field_196639_V, Blocks.field_196617_K, Blocks.field_196618_L, Blocks.field_196619_M, Blocks.field_196620_N, Blocks.field_196621_O, Blocks.field_196623_P, Blocks.field_150486_ae, Blocks.field_150423_aK, Blocks.field_196625_cS, Blocks.field_196628_cT, Blocks.field_150440_ba, Blocks.field_150468_ap, Blocks.field_222420_lI, Blocks.field_196689_eF, Blocks.field_196691_eG, Blocks.field_196693_eH, Blocks.field_196695_eI, Blocks.field_196699_eK, Blocks.field_196697_eJ, Blocks.field_196663_cq, Blocks.field_196665_cr, Blocks.field_196667_cs, Blocks.field_196669_ct, Blocks.field_196673_cv, Blocks.field_196671_cu});
    public static final Set<Material> EFFECTIVE_MATERIALS = ImmutableSet.of((Object)Material.field_151575_d, (Object)Material.field_237214_y_, (Object)Material.field_151585_k, (Object)Material.field_151582_l, (Object)Material.field_215713_z, (Object)Material.field_151572_C, (Object[])new Material[]{Material.field_151570_A});
    public static final int LOG_BREAK_DELAY = 1;
    public final Ingredient customRepair;

    protected GreataxeItem(IItemTier tier, float attackDamageIn, float attackSpeedIn, Item.Properties builder, Ingredient customRepair) {
        super(tier, attackDamageIn, attackSpeedIn, builder);
        this.customRepair = customRepair;
    }

    public boolean func_179218_a(ItemStack stack, World world, BlockState state, BlockPos pos, LivingEntity entityLiving) {
        PlayerEntity player;
        stack.func_96631_a((Integer)ModConfig.COMMON.greataxeDuraLossMulti.get() - 1, ToolFunctions.random, null);
        if (entityLiving instanceof PlayerEntity && !this.attemptFellTree(world, pos, player = (PlayerEntity)entityLiving)) {
            ToolFunctions.attemptBreakNeighbors(world, pos, player, EFFECTIVE_ON, EFFECTIVE_MATERIALS, false);
        }
        return super.func_179218_a(stack, world, state, pos, entityLiving);
    }

    public boolean func_82789_a(ItemStack toRepair, ItemStack repair) {
        return this.customRepair.test(repair);
    }

    private boolean attemptFellTree(final World world, BlockPos pos, final PlayerEntity player) {
        final ArrayList<BlockPos> logs = new ArrayList<BlockPos>();
        ArrayList<BlockPos> candidates = new ArrayList<BlockPos>();
        candidates.add(pos);
        int leaves = 0;
        for (int i = 0; i < candidates.size(); ++i) {
            if (logs.size() > 200) {
                return false;
            }
            BlockPos candidate = (BlockPos)candidates.get(i);
            Block block = world.func_180495_p(candidate).func_177230_c();
            if (BlockTags.field_206952_E.func_230236_b_().contains(block)) {
                ++leaves;
                continue;
            }
            if (logs.size() != 0 && !BlockTags.field_200031_h.func_230236_b_().contains(block)) continue;
            logs.add(candidate);
            for (int x = -1; x <= 1; ++x) {
                for (int y = 0; y <= 1; ++y) {
                    for (int z = -1; z <= 1; ++z) {
                        BlockPos neighbor = candidate.func_177982_a(x, y, z);
                        if (candidates.contains(neighbor)) continue;
                        candidates.add(neighbor);
                    }
                }
            }
        }
        if (logs.size() == 0) {
            return false;
        }
        if ((double)leaves >= (double)logs.size() / 6.0) {
            MinecraftForge.EVENT_BUS.register(new Object(){
                int fortuneLevel;
                int silkLevel;
                int delay;
                int i;
                {
                    this.fortuneLevel = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)player.func_184614_ca());
                    this.silkLevel = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185306_r, (ItemStack)player.func_184614_ca());
                    this.delay = 1;
                    this.i = 0;
                }

                @SubscribeEvent
                public void onTick(TickEvent.WorldTickEvent event) {
                    if (this.delay-- > 0) {
                        return;
                    }
                    this.delay = 1;
                    if (this.i < logs.size()) {
                        BlockPos log = (BlockPos)logs.get(this.i);
                        ToolFunctions.attemptBreak(world, log, player, EFFECTIVE_ON, EFFECTIVE_MATERIALS, this.fortuneLevel, this.silkLevel, false);
                        ++this.i;
                    } else {
                        MinecraftForge.EVENT_BUS.unregister((Object)this);
                    }
                }
            });
            return true;
        }
        return false;
    }
}

