/*
 * Decompiled with CFR 0.152.
 */
package net.daveyx0.primitivemobs.client.models;

import java.util.HashSet;
import java.util.Set;
import net.daveyx0.primitivemobs.client.models.MeshDefinitionFix;
import net.daveyx0.primitivemobs.core.PrimitiveMobsItems;
import net.daveyx0.primitivemobs.util.IVariant;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ModelManagerPrimitiveMobs {
    public static final ModelManagerPrimitiveMobs INSTANCE = new ModelManagerPrimitiveMobs();
    private final Set<Item> itemsRegistered = new HashSet<Item>();

    private ModelManagerPrimitiveMobs() {
    }

    public void registerAllModels() {
        this.registerBlockModels();
        this.registerItemModels();
    }

    private void registerBlockModels() {
    }

    private void registerItemModels() {
        PrimitiveMobsItems.ITEMS.stream().filter(item -> !this.itemsRegistered.contains(item)).forEach(this::registerItemModel);
    }

    public void registerItemColors() {
        this.registerItemColor(new IItemColor(){

            public int func_186726_a(ItemStack stack, int tintIndex) {
                return tintIndex > 0 ? -1 : ((ItemArmor)stack.func_77973_b()).func_82814_b(stack);
            }
        }, new Item[]{PrimitiveMobsItems.CAMOUFLAGE_HELMET, PrimitiveMobsItems.CAMOUFLAGE_CHEST, PrimitiveMobsItems.CAMOUFLAGE_LEGS, PrimitiveMobsItems.CAMOUFLAGE_BOOTS});
    }

    private void registerItemColor(IItemColor itemcolor, Item ... itemsIn) {
        FMLClientHandler.instance().getClient().getItemColors().func_186730_a(itemcolor, itemsIn);
    }

    private void registerBlockItemModel(Block block) {
        Item item = Item.func_150898_a((Block)block);
        if (item != null) {
            this.registerItemModel(item);
        }
    }

    private void registerBlockItemModel(Block block, String modelLocation) {
        Item item = Item.func_150898_a((Block)block);
        if (item != null) {
            this.registerItemModel(item, modelLocation);
        }
    }

    private <T extends IVariant> void registerVariantBlockItemModels(Block block, String variantName, T[] variants) {
        Item item = Item.func_150898_a((Block)block);
        if (item != null) {
            this.registerVariantItemModels(item, variantName, (IVariant[])variants);
        }
    }

    private void registerBlockItemModel(Block block, ModelResourceLocation fullModelLocation) {
        Item item = Item.func_150898_a((Block)block);
        if (item != null) {
            this.registerItemModel(item);
        }
    }

    private void registerBlockItemModelForMeta(Block block, int metadata, String variant) {
        Item item = Item.func_150898_a((Block)block);
        if (item != null) {
            this.registerItemModelForMeta(item, metadata, variant);
        }
    }

    private void registerItemModel(Item item) {
        this.registerItemModel(item, item.getRegistryName().toString());
    }

    private void registerItemModel(Item item, String modelLocation) {
        ModelResourceLocation fullModelLocation = new ModelResourceLocation(modelLocation, "inventory");
        this.registerItemModel(item, fullModelLocation);
    }

    private void registerItemModel(Item item, ModelResourceLocation fullModelLocation) {
        ModelBakery.registerItemVariants((Item)item, (ResourceLocation[])new ResourceLocation[]{fullModelLocation});
        this.registerItemModel(item, MeshDefinitionFix.create(stack -> fullModelLocation));
    }

    private void registerItemModel(Item item, ItemMeshDefinition meshDefinition) {
        this.itemsRegistered.add(item);
        ModelLoader.setCustomMeshDefinition((Item)item, (ItemMeshDefinition)meshDefinition);
    }

    private <T extends IVariant> void registerVariantItemModels(Item item, String variantName, T[] variants) {
        for (T variant : variants) {
            this.registerItemModelForMeta(item, variant.getMeta(), variantName + "=" + variant.func_176610_l());
        }
    }

    private void registerItemModelForMeta(Item item, int metadata, String variant) {
        this.registerItemModelForMeta(item, metadata, new ModelResourceLocation(item.getRegistryName(), variant));
    }

    private void registerItemModelForMeta(Item item, int metadata, ModelResourceLocation modelResourceLocation) {
        this.itemsRegistered.add(item);
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)metadata, (ModelResourceLocation)modelResourceLocation);
    }
}

