/*
 * Decompiled with CFR 0.152.
 */
package net.daveyx0.primitivemobs.core;

import java.util.ArrayList;
import java.util.List;
import net.daveyx0.primitivemobs.entity.monster.EntityBrainSlime;
import net.daveyx0.primitivemobs.entity.monster.EntityEnchantedBook;
import net.daveyx0.primitivemobs.entity.monster.EntityFestiveCreeper;
import net.daveyx0.primitivemobs.entity.monster.EntityHauntedTool;
import net.daveyx0.primitivemobs.entity.monster.EntityRocketCreeper;
import net.daveyx0.primitivemobs.entity.monster.EntitySupportCreeper;
import net.daveyx0.primitivemobs.entity.monster.EntityTreasureSlime;
import net.daveyx0.primitivemobs.entity.passive.EntityChameleon;
import net.daveyx0.primitivemobs.entity.passive.EntityFilchLizard;
import net.daveyx0.primitivemobs.entity.passive.EntityGroveSprite;
import net.daveyx0.primitivemobs.spawn.PrimitiveMobsSpawnEntry;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;

public class PrimitiveMobsSpawnList {
    private static final List<PrimitiveMobsSpawnEntry> SPAWNS = new ArrayList<PrimitiveMobsSpawnEntry>();
    public static final PrimitiveMobsSpawnEntry CHAMELEON_SPAWNS = PrimitiveMobsSpawnList.registerSpawn(new PrimitiveMobsSpawnEntry(EntityChameleon.class, 0.25f){

        @Override
        public boolean isBiomeSuitable(Biome biome) {
            return BiomeDictionary.isBiomeOfType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.PLAINS) && super.isBiomeSuitable(biome);
        }
    });
    public static final PrimitiveMobsSpawnEntry FILCHLIZARD_SPAWNS = PrimitiveMobsSpawnList.registerSpawn(new PrimitiveMobsSpawnEntry(EntityFilchLizard.class, 0.25f){

        @Override
        public boolean isBiomeSuitable(Biome biome) {
            return BiomeDictionary.isBiomeOfType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.SANDY) && super.isBiomeSuitable(biome);
        }
    });
    public static final PrimitiveMobsSpawnEntry GROVESPRITE_SPAWNS = PrimitiveMobsSpawnList.registerSpawn(new PrimitiveMobsSpawnEntry(EntityGroveSprite.class, 0.25f){

        @Override
        public boolean isBiomeSuitable(Biome biome) {
            return BiomeDictionary.isBiomeOfType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.FOREST) && super.isBiomeSuitable(biome);
        }
    });
    public static final PrimitiveMobsSpawnEntry BRAINSLIME_SPAWNS = PrimitiveMobsSpawnList.registerSpawn(new PrimitiveMobsSpawnEntry(EntityBrainSlime.class, 0.5f){

        @Override
        public boolean isBiomeSuitable(Biome biome) {
            return (BiomeDictionary.isBiomeOfType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.BEACH) || BiomeDictionary.isBiomeOfType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.RIVER)) && super.isBiomeSuitable(biome);
        }
    });
    public static final PrimitiveMobsSpawnEntry HAUNTEDTOOL_SPAWNS = PrimitiveMobsSpawnList.registerSpawn(new PrimitiveMobsSpawnEntry(EntityHauntedTool.class, 0.15f));
    public static final PrimitiveMobsSpawnEntry TREASURESLIME_SPAWNS;
    public static final PrimitiveMobsSpawnEntry ROCKETCREEPER_SPAWNS;
    public static final PrimitiveMobsSpawnEntry SUPPORTCREEPER_SPAWNS;
    public static final PrimitiveMobsSpawnEntry FESTIVECREEPER_SPAWNS;
    public static final PrimitiveMobsSpawnEntry BEWITCHEDTOME_SPAWNS;

    public static List<PrimitiveMobsSpawnEntry> getSpawnEntries() {
        return SPAWNS;
    }

    public static void postInit() {
        PrimitiveMobsSpawnList.registerSpawns();
    }

    public static void registerSpawns() {
    }

    private static <T extends PrimitiveMobsSpawnEntry> T registerSpawn(T entry) {
        SPAWNS.add(entry);
        return entry;
    }

    static {
        ROCKETCREEPER_SPAWNS = PrimitiveMobsSpawnList.registerSpawn(new PrimitiveMobsSpawnEntry(EntityRocketCreeper.class, 0.25f));
        FESTIVECREEPER_SPAWNS = PrimitiveMobsSpawnList.registerSpawn(new PrimitiveMobsSpawnEntry(EntityFestiveCreeper.class, 0.15f));
        SUPPORTCREEPER_SPAWNS = PrimitiveMobsSpawnList.registerSpawn(new PrimitiveMobsSpawnEntry(EntitySupportCreeper.class, 0.15f));
        TREASURESLIME_SPAWNS = PrimitiveMobsSpawnList.registerSpawn(new PrimitiveMobsSpawnEntry(EntityTreasureSlime.class, 0.2f));
        BEWITCHEDTOME_SPAWNS = PrimitiveMobsSpawnList.registerSpawn(new PrimitiveMobsSpawnEntry(EntityEnchantedBook.class, 0.3f));
    }
}

