/*
 * Decompiled with CFR 0.152.
 */
package net.daveyx0.primitivemobs.entity.ai;

import com.google.common.collect.Sets;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.PathNavigateGround;

public class EntityAITemptItemStack
extends EntityAIBase {
    private final EntityCreature temptedEntity;
    private final double speed;
    private double targetX;
    private double targetY;
    private double targetZ;
    private double pitch;
    private double yaw;
    private EntityPlayer temptingPlayer;
    private int delayTemptCounter;
    private boolean isRunning;
    private final Set<ItemStack> temptItem;
    private final boolean scaredByPlayerMovement;

    public EntityAITemptItemStack(EntityCreature temptedEntityIn, double speedIn, ItemStack temptItemIn, boolean scaredByPlayerMovementIn) {
        this(temptedEntityIn, speedIn, scaredByPlayerMovementIn, Sets.newHashSet((Object[])new ItemStack[]{temptItemIn}));
    }

    public EntityAITemptItemStack(EntityCreature temptedEntityIn, double speedIn, boolean scaredByPlayerMovementIn, Set<ItemStack> temptItemIn) {
        this.temptedEntity = temptedEntityIn;
        this.speed = speedIn;
        this.temptItem = temptItemIn;
        this.scaredByPlayerMovement = scaredByPlayerMovementIn;
        if (!(temptedEntityIn.func_70661_as() instanceof PathNavigateGround)) {
            throw new IllegalArgumentException("Unsupported mob type for TemptGoal");
        }
    }

    public boolean func_75250_a() {
        if (this.delayTemptCounter > 0) {
            --this.delayTemptCounter;
            return false;
        }
        this.temptingPlayer = this.temptedEntity.field_70170_p.func_72890_a((Entity)this.temptedEntity, 10.0);
        return this.temptingPlayer == null ? false : this.isTempting(this.temptingPlayer.func_184614_ca()) || this.isTempting(this.temptingPlayer.func_184592_cb());
    }

    protected boolean isTempting(@Nullable ItemStack stack) {
        if (stack != null) {
            for (ItemStack item : this.temptItem) {
                if (item == null || item.func_77973_b() != stack.func_77973_b() || item.func_77960_j() != stack.func_77960_j()) continue;
                return true;
            }
            ItemStack heldItem = this.temptedEntity.func_184614_ca();
            if (heldItem != null && heldItem.func_77973_b() == stack.func_77973_b() && heldItem.func_77960_j() == stack.func_77960_j()) {
                return true;
            }
        }
        return false;
    }

    public boolean func_75253_b() {
        if (this.scaredByPlayerMovement) {
            if (this.temptedEntity.func_70068_e((Entity)this.temptingPlayer) < 36.0) {
                if (this.temptingPlayer.func_70092_e(this.targetX, this.targetY, this.targetZ) > 0.010000000000000002) {
                    return false;
                }
                if (Math.abs((double)this.temptingPlayer.field_70125_A - this.pitch) > 5.0 || Math.abs((double)this.temptingPlayer.field_70177_z - this.yaw) > 5.0) {
                    return false;
                }
            } else {
                this.targetX = this.temptingPlayer.field_70165_t;
                this.targetY = this.temptingPlayer.field_70163_u;
                this.targetZ = this.temptingPlayer.field_70161_v;
            }
            this.pitch = this.temptingPlayer.field_70125_A;
            this.yaw = this.temptingPlayer.field_70177_z;
        }
        return this.func_75250_a();
    }

    public void func_75249_e() {
        this.targetX = this.temptingPlayer.field_70165_t;
        this.targetY = this.temptingPlayer.field_70163_u;
        this.targetZ = this.temptingPlayer.field_70161_v;
        this.isRunning = true;
    }

    public void func_75251_c() {
        this.temptingPlayer = null;
        this.temptedEntity.func_70661_as().func_75499_g();
        this.delayTemptCounter = 50;
        this.isRunning = false;
    }

    public void func_75246_d() {
        this.temptedEntity.func_70671_ap().func_75651_a((Entity)this.temptingPlayer, (float)(this.temptedEntity.func_184649_cE() + 20), (float)this.temptedEntity.func_70646_bf());
        if (this.temptedEntity.func_70068_e((Entity)this.temptingPlayer) < 6.25) {
            this.temptedEntity.func_70661_as().func_75499_g();
        } else {
            this.temptedEntity.func_70661_as().func_75497_a((Entity)this.temptingPlayer, this.speed);
        }
    }

    public boolean isRunning() {
        return this.isRunning;
    }
}

