/*
 * Decompiled with CFR 0.152.
 */
package net.daveyx0.primitivemobs.entity.monster;

import net.daveyx0.primitivemobs.entity.monster.EntityPrimitiveCreeper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIAvoidEntity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAICreeperSwell;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.passive.EntityOcelot;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.world.World;

public class EntityRocketCreeper
extends EntityPrimitiveCreeper {
    private float explosionRadius = 3.0f;
    private static final DataParameter<Boolean> IS_ROCKET = EntityDataManager.func_187226_a(EntityRocketCreeper.class, (DataSerializer)DataSerializers.field_187198_h);

    public EntityRocketCreeper(World worldIn) {
        super(worldIn);
        this.setRocket(false);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAICreeperSwell((EntityCreeper)this));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIAvoidEntity((EntityCreature)this, EntityOcelot.class, 6.0f, 1.0, 1.2));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.0, false));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWander((EntityCreature)this, 0.8));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, true));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.35);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(IS_ROCKET, (Object)false);
    }

    public void func_180430_e(float distance, float damageMultiplier) {
        if (this.isRocket()) {
            this.explode();
        } else {
            super.func_180430_e(distance, damageMultiplier);
        }
    }

    private void explode() {
        if (!this.field_70170_p.field_72995_K) {
            boolean flag = this.field_70170_p.func_82736_K().func_82766_b("mobGriefing");
            float f = this.func_70830_n() ? 2.0f : 1.0f;
            this.field_70729_aU = true;
            this.field_70170_p.func_72876_a((Entity)this, this.field_70165_t, this.field_70163_u, this.field_70161_v, this.explosionRadius * f, flag);
            this.func_70106_y();
        }
    }

    @Override
    public void func_70071_h_() {
        int var1;
        if (this.func_70089_S() && (var1 = this.func_70832_p()) > 0 && this.field_70122_E && this.func_70638_az() != null) {
            if (this.field_70170_p.field_72995_K) {
                this.field_70170_p.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()), this.field_70163_u - (double)(this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) - 1.0, this.field_70161_v + (double)(this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()), 0.0, 0.0, 0.0, new int[0]);
                this.func_184185_a(SoundEvents.field_187572_ar, 1.0f, 0.5f);
            }
            this.field_70181_x = 1.2f;
            this.field_70159_w = (this.func_70638_az().field_70165_t - this.field_70165_t) / 10.0;
            this.field_70179_y = (this.func_70638_az().field_70161_v - this.field_70161_v) / 10.0;
            this.setRocket(true);
        }
        super.func_70071_h_();
    }

    public void setRocket(boolean rocket) {
        this.func_184212_Q().func_187227_b(IS_ROCKET, (Object)rocket);
    }

    public boolean isRocket() {
        return (Boolean)this.func_184212_Q().func_187225_a(IS_ROCKET);
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74757_a("Rocket", this.isRocket());
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.setRocket(compound.func_74767_n("Rocket"));
    }
}

