/*
 * Decompiled with CFR 0.152.
 */
package net.daveyx0.primitivemobs.entity.monster;

import javax.annotation.Nullable;
import net.daveyx0.primitivemobs.config.PrimitiveMobsConfigMobs;
import net.daveyx0.primitivemobs.core.PrimitiveMobsParticles;
import net.daveyx0.primitivemobs.entity.ai.EntityAISlimeSit;
import net.daveyx0.primitivemobs.entity.monster.EntityTameableSlime;
import net.daveyx0.primitivemobs.loot.TreasureSlimeLoot;
import net.daveyx0.primitivemobs.util.ColorUtil;
import net.minecraft.block.Block;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;

public class EntityTreasureSlime
extends EntityTameableSlime {
    private float R = 0.0f;
    private float G = 0.0f;
    private float B = 0.0f;
    private float NewR;
    private float NewG;
    private float NewB;
    private int colorSpeed = 10;
    private int tameableChance = 10;
    private ItemStack currentItem;
    private boolean wasOnGround;

    public EntityTreasureSlime(World worldIn) {
        super(worldIn);
        if (this.getSkinRGB()[0] == 0.0f && this.getSkinRGB()[1] == 0.0f && this.getSkinRGB()[2] == 0.0f) {
            this.setSkinRGB(new int[]{255, 255, 255});
        }
        this.field_82174_bp[0] = 0.0f;
        this.field_82174_bp[1] = 0.0f;
    }

    public EntityTreasureSlime(World worldIn, ItemStack item, float[] rgb) {
        super(worldIn);
        this.setSkinRGB(rgb);
        this.func_184201_a(EntityEquipmentSlot.MAINHAND, item);
        this.field_82174_bp[0] = 0.0f;
        this.field_82174_bp[1] = 0.0f;
    }

    protected void func_184651_r() {
        boolean prio = false;
        this.aiSit = new EntityAISlimeSit(this);
        super.func_184651_r();
    }

    protected boolean spawnCustomParticles() {
        return true;
    }

    @Nullable
    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData livingdata) {
        if (this.field_70146_Z.nextInt(this.tameableChance) != 0) {
            while (this.func_184614_ca() == null && !this.field_70170_p.field_72995_K) {
                this.func_184201_a(EntityEquipmentSlot.MAINHAND, TreasureSlimeLoot.getRandomLootItem(this.field_70146_Z));
            }
        }
        return super.func_180482_a(difficulty, livingdata);
    }

    public boolean func_70692_ba() {
        return !this.isTamed();
    }

    public void func_70071_h_() {
        int i;
        if (this.func_70090_H() && !this.field_70123_F) {
            this.field_70181_x = 0.02;
        }
        if (this.field_70170_p.field_72995_K) {
            this.changeColor((Entity)this);
        }
        if (this.R != this.NewR || this.G != this.NewG || this.B != this.NewB) {
            for (i = 0; i < this.colorSpeed; ++i) {
                if (this.R > this.NewR) {
                    this.R -= 1.0f;
                } else if (this.R < this.NewR) {
                    this.R += 1.0f;
                }
                if (this.G > this.NewG) {
                    this.G -= 1.0f;
                } else if (this.G < this.NewG) {
                    this.G += 1.0f;
                }
                if (this.B > this.NewB) {
                    this.B -= 1.0f;
                    continue;
                }
                if (!(this.B < this.NewB)) continue;
                this.B += 1.0f;
            }
        }
        if (this.isTamed() && this.field_70146_Z.nextInt(200) == 0) {
            this.field_70170_p.func_175688_a(EnumParticleTypes.HEART, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()), this.field_70163_u + (double)this.field_70146_Z.nextFloat() + 1.0, this.field_70161_v + (double)(this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()), 1.0, 1.0, 1.0, new int[0]);
        }
        if (this.field_70122_E && !this.wasOnGround && this.field_70170_p.field_72995_K) {
            i = this.func_70809_q();
            for (int j = 0; j < i * 8; ++j) {
                float f = this.field_70146_Z.nextFloat() * ((float)Math.PI * 2);
                float f1 = this.field_70146_Z.nextFloat() * 0.5f + 0.5f;
                float f2 = MathHelper.func_76126_a((float)f) * (float)i * 0.5f * f1;
                float f3 = MathHelper.func_76134_b((float)f) * (float)i * 0.5f * f1;
                World world = this.field_70170_p;
                double d0 = this.field_70165_t + (double)f2;
                double d1 = this.field_70161_v + (double)f3;
                PrimitiveMobsParticles.spawnParticle("slime", d0, this.func_174813_aQ().field_72338_b, d1, 0.0, 0.0, 0.0, this.getSkinRGB());
            }
            this.func_184185_a(this.func_184709_cY(), this.func_70599_aP(), ((this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f) / 0.8f);
            this.field_70813_a = -0.5f;
        } else if (!this.field_70122_E && this.wasOnGround) {
            this.field_70813_a = 1.0f;
        }
        this.wasOnGround = this.field_70122_E;
        super.func_70071_h_();
    }

    protected EntityTreasureSlime createInstance() {
        return new EntityTreasureSlime(this.field_70170_p, this.func_184614_ca(), this.getSkinRGB());
    }

    @Override
    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74757_a("wasOnGround", this.wasOnGround);
    }

    @Override
    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.wasOnGround = compound.func_74767_n("wasOnGround");
    }

    public void func_70106_y() {
        int i = this.func_70809_q();
        if (!this.field_70170_p.field_72995_K && i > 1 && this.func_110143_aJ() <= 0.0f) {
            int j = 2 + this.field_70146_Z.nextInt(3);
            for (int k = 0; k < j; ++k) {
                float f = ((float)(k % 2) - 0.5f) * (float)i / 4.0f;
                float f1 = ((float)(k / 2) - 0.5f) * (float)i / 4.0f;
                EntityTreasureSlime entityslime = this.createInstance();
                if (this.func_145818_k_()) {
                    entityslime.func_96094_a(this.func_95999_t());
                }
                if (this.func_104002_bU()) {
                    entityslime.func_110163_bv();
                }
                entityslime.func_70799_a(i / 2);
                entityslime.func_70012_b(this.field_70165_t + (double)f, this.field_70163_u + 0.5, this.field_70161_v + (double)f1, this.field_70146_Z.nextFloat() * 360.0f, 0.0f);
                this.field_70170_p.func_72838_d((Entity)entityslime);
            }
        }
        this.field_70128_L = true;
    }

    protected Item func_146068_u() {
        return this.func_70809_q() == 1 && this.func_184614_ca() != null ? this.func_184614_ca().func_77973_b() : null;
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return null;
    }

    protected boolean func_146066_aG() {
        return true;
    }

    protected void func_70628_a(boolean wasRecentlyHit, int lootingModifier) {
        ItemStack stack = this.func_184614_ca();
        if (stack != null && this.func_70809_q() == 1 && !this.field_70170_p.field_72995_K) {
            int i = 1;
            if (lootingModifier > 0) {
                i += this.field_70146_Z.nextInt(lootingModifier + 1);
            }
            for (int j = 0; j < i; ++j) {
                ItemStack newStack = new ItemStack(stack.func_77973_b(), 1, stack.func_77960_j());
                this.dropItemStack(newStack, 1.0f);
            }
        }
    }

    public double func_70042_X() {
        return (double)this.field_70131_O * 1.2;
    }

    public EntityItem dropItemStack(ItemStack itemIn, float offsetY) {
        return this.func_70099_a(itemIn, offsetY);
    }

    public boolean func_184645_a(EntityPlayer player, EnumHand hand, @Nullable ItemStack stack) {
        if (this.isTamed()) {
            if (stack != null) {
                if (this.isHealingItem(stack)) {
                    if (!player.field_71075_bZ.field_75098_d) {
                        --stack.field_77994_a;
                    }
                    this.playHealEffect();
                    this.func_70691_i(20.0f);
                    return true;
                }
                if (this.isOwner((EntityLivingBase)player)) {
                    if (!player.field_71075_bZ.field_75098_d) {
                        --stack.field_77994_a;
                    }
                    if (this.func_184614_ca() != null && !this.field_70170_p.field_72995_K) {
                        this.dropItemStack(this.func_184614_ca(), 0.0f);
                    }
                    ItemStack newStack = new ItemStack(stack.func_77973_b(), 1, stack.func_77960_j());
                    if (this.field_70170_p.field_72995_K && PrimitiveMobsConfigMobs.getDebug()) {
                        String[] divided = stack.func_77973_b().getRegistryName().toString().split(":");
                        Minecraft.func_71410_x().field_71439_g.func_71165_d("modName: " + divided[0] + " itemName: " + divided[1] + " metaData: " + stack.func_77960_j());
                    }
                    this.func_184201_a(EntityEquipmentSlot.MAINHAND, newStack);
                }
            } else if (stack == null && this.isOwner((EntityLivingBase)player)) {
                if (!this.field_70170_p.field_72995_K) {
                    this.aiSit.setSitting(!this.isSitting());
                    this.field_70703_bu = false;
                    this.field_70699_by.func_75499_g();
                } else {
                    this.playSitEffect();
                }
            }
        } else if (stack != null && this.isTamingItem(stack) && this.func_184614_ca() == null) {
            if (!player.field_71075_bZ.field_75098_d) {
                --stack.field_77994_a;
            }
            if (!this.field_70170_p.field_72995_K) {
                this.setTamed(true);
                this.field_70699_by.func_75499_g();
                this.func_70606_j(20.0f);
                this.setOwnerId(player.func_110124_au());
                this.playTameEffect(true);
                this.field_70170_p.func_72960_a((Entity)this, (byte)7);
            }
            return true;
        }
        return super.func_184645_a(player, hand, stack);
    }

    @Override
    public void setTamed(boolean tamed) {
        super.setTamed(tamed);
        if (tamed) {
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(20.0);
        } else {
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(10.0);
        }
    }

    public boolean func_70097_a(DamageSource par1DamageSource, float par2) {
        if (par1DamageSource.field_76373_n == "inWall" && this.isTamed()) {
            return false;
        }
        if (par1DamageSource.field_76373_n == "fall" && this.isTamed()) {
            return false;
        }
        if (par1DamageSource.field_76373_n == "drown" && this.isTamed()) {
            return false;
        }
        return super.func_70097_a(par1DamageSource, par2);
    }

    public float[] getSkinRGB() {
        return new float[]{this.R, this.G, this.B};
    }

    public void setSkinRGB(int[] RGB) {
        this.R = RGB[0];
        this.G = RGB[1];
        this.B = RGB[2];
    }

    public void setSkinRGB(float[] RGB) {
        this.R = RGB[0];
        this.G = RGB[1];
        this.B = RGB[2];
    }

    public float[] getNewSkinRGB() {
        return new float[]{this.NewR, this.NewG, this.NewB};
    }

    public void setNewSkinRGB(int[] RGB) {
        this.NewR = RGB[0];
        this.NewG = RGB[1];
        this.NewB = RGB[2];
    }

    public void changeColor(Entity entity) {
        int[] newColor = new int[3];
        ItemStack heldItem = this.func_184614_ca();
        if (heldItem != null && heldItem != this.currentItem) {
            this.currentItem = heldItem;
            if (!(heldItem.func_77973_b() instanceof ItemBlock)) {
                newColor = ColorUtil.getItemStackColor(heldItem, this.field_70170_p);
                if ((newColor = ColorUtil.setBrightness(newColor, 25.0f)) != null) {
                    this.setNewSkinRGB(newColor);
                    return;
                }
            } else {
                ItemBlock itemblock = (ItemBlock)heldItem.func_77973_b();
                Block block = itemblock.func_179223_d();
                BlockStateContainer container = block.func_176194_O();
                IBlockState blockstate = (IBlockState)container.func_177619_a().get(heldItem.func_77960_j());
                newColor = ColorUtil.getBlockStateColor(blockstate, null, null);
                if ((newColor = ColorUtil.setBrightness(newColor, 25.0f)) != null) {
                    this.setNewSkinRGB(newColor);
                    return;
                }
            }
        }
        if (heldItem == null) {
            this.setNewSkinRGB(new int[]{255, 255, 255});
        }
    }

    protected boolean isValidLightLevel() {
        BlockPos blockpos = new BlockPos(this.field_70165_t, this.func_174813_aQ().field_72338_b, this.field_70161_v);
        if (this.field_70170_p.func_175642_b(EnumSkyBlock.SKY, blockpos) > this.field_70146_Z.nextInt(32)) {
            return false;
        }
        int i = this.field_70170_p.func_175671_l(blockpos);
        if (this.field_70170_p.func_72911_I()) {
            int j = this.field_70170_p.func_175657_ab();
            this.field_70170_p.func_175692_b(10);
            i = this.field_70170_p.func_175671_l(blockpos);
            this.field_70170_p.func_175692_b(j);
        }
        return i <= this.field_70146_Z.nextInt(8);
    }

    public boolean func_70601_bi() {
        return this.field_70170_p.func_175659_aa() != EnumDifficulty.PEACEFUL && this.isValidLightLevel();
    }
}

