/*
 * Decompiled with CFR 0.152.
 */
package net.daveyx0.primitivemobs.entity.passive;

import javax.annotation.Nullable;
import net.daveyx0.primitivemobs.core.PrimitiveMobsLootTables;
import net.daveyx0.primitivemobs.util.ColorUtil;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIFollowOwner;
import net.minecraft.entity.ai.EntityAIFollowParent;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMate;
import net.minecraft.entity.ai.EntityAIPanic;
import net.minecraft.entity.ai.EntityAISit;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAITempt;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class EntityChameleon
extends EntityTameable {
    private float R;
    private float G;
    private float B;
    private float NewR;
    private float NewG;
    private float NewB;
    private int colorSpeed = 4;
    private IBlockState currentState;
    private int currentMultiplier;

    public EntityChameleon(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.7f, 0.5f);
        this.setSkinRGB(new int[]{0, 125, 25});
        this.field_70138_W = 1.0f;
        this.func_70903_f(false);
    }

    protected void func_184651_r() {
        int prio = 0;
        this.field_70911_d = new EntityAISit((EntityTameable)this);
        this.field_70714_bg.func_75776_a(++prio, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(++prio, (EntityAIBase)this.field_70911_d);
        this.field_70714_bg.func_75776_a(++prio, (EntityAIBase)new EntityAIPanic((EntityCreature)this, 1.25));
        this.field_70714_bg.func_75776_a(++prio, (EntityAIBase)new EntityAIFollowParent((EntityAnimal)this, 1.1));
        this.field_70714_bg.func_75776_a(++prio, (EntityAIBase)new EntityAIMate((EntityAnimal)this, 1.0));
        this.field_70714_bg.func_75776_a(++prio, (EntityAIBase)new EntityAITempt((EntityCreature)this, 1.1, Items.field_151071_bq, false));
        this.field_70714_bg.func_75776_a(++prio, (EntityAIBase)new EntityAIFollowOwner((EntityTameable)this, 1.0, 10.0f, 2.0f));
        this.field_70714_bg.func_75776_a(++prio, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(++prio, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 6.0f));
        this.field_70714_bg.func_75776_a(++prio, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        if (this.func_70909_n()) {
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(20.0);
        } else {
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(8.0);
        }
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)0.2f);
    }

    protected void func_70088_a() {
        super.func_70088_a();
    }

    public boolean func_70692_ba() {
        return !this.func_70909_n();
    }

    protected float func_70599_aP() {
        return 0.4f;
    }

    public EntityAgeable func_90011_a(EntityAgeable ageable) {
        return new EntityChameleon(this.field_70170_p);
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return PrimitiveMobsLootTables.ENTITIES_CHAMELEON;
    }

    public void func_70071_h_() {
        if (this.func_70090_H() && !this.field_70123_F) {
            this.field_70181_x = 0.02;
        }
        if (this.field_70170_p.field_72995_K) {
            this.changeColor((Entity)this);
        }
        if (this.R != this.NewR || this.G != this.NewG || this.B != this.NewB) {
            for (int i = 0; i < this.colorSpeed; ++i) {
                if (this.R > this.NewR) {
                    this.R -= 1.0f;
                } else if (this.R < this.NewR) {
                    this.R += 1.0f;
                }
                if (this.G > this.NewG) {
                    this.G -= 1.0f;
                } else if (this.G < this.NewG) {
                    this.G += 1.0f;
                }
                if (this.B > this.NewB) {
                    this.B -= 1.0f;
                    continue;
                }
                if (!(this.B < this.NewB)) continue;
                this.B += 1.0f;
            }
        }
        if (this.func_70909_n() && this.field_70146_Z.nextInt(200) == 0) {
            this.field_70170_p.func_175688_a(EnumParticleTypes.HEART, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()), this.field_70163_u + (double)this.field_70146_Z.nextFloat() + 1.0, this.field_70161_v + (double)(this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()), 1.0, 1.0, 1.0, new int[0]);
        }
        super.func_70071_h_();
    }

    public boolean isHealingItem(@Nullable ItemStack stack) {
        return stack == null ? false : stack.func_77973_b() == Items.field_151070_bp;
    }

    public boolean isTamingItem(@Nullable ItemStack stack) {
        return stack == null ? false : stack.func_77973_b() == Items.field_151127_ba;
    }

    public boolean func_70877_b(@Nullable ItemStack stack) {
        return stack == null ? false : stack.func_77973_b() == Items.field_151071_bq;
    }

    public boolean func_184645_a(EntityPlayer player, EnumHand hand, @Nullable ItemStack stack) {
        if (this.func_70909_n()) {
            if (stack != null && this.isHealingItem(stack)) {
                if (!player.field_71075_bZ.field_75098_d) {
                    --stack.field_77994_a;
                }
                this.playHealEffect();
                this.func_70691_i(20.0f);
                return true;
            }
            if (this.func_152114_e((EntityLivingBase)player) && !this.func_70877_b(stack)) {
                if (!this.field_70170_p.field_72995_K) {
                    this.field_70911_d.func_75270_a(!this.func_70906_o());
                    this.field_70703_bu = false;
                    this.field_70699_by.func_75499_g();
                } else {
                    this.playSitEffect();
                }
            }
        } else if (stack != null && this.isTamingItem(stack)) {
            if (!player.field_71075_bZ.field_75098_d) {
                --stack.field_77994_a;
            }
            if (!this.field_70170_p.field_72995_K) {
                this.func_70903_f(true);
                this.field_70699_by.func_75499_g();
                this.func_70606_j(20.0f);
                this.func_184754_b(player.func_110124_au());
                this.func_70908_e(true);
                this.field_70170_p.func_72960_a((Entity)this, (byte)7);
            }
            return true;
        }
        return super.func_184645_a(player, hand, stack);
    }

    protected void playHealEffect() {
        EnumParticleTypes enumparticletypes = EnumParticleTypes.HEART;
        for (int i = 0; i < 7; ++i) {
            double d0 = this.field_70146_Z.nextGaussian() * 0.02;
            double d1 = this.field_70146_Z.nextGaussian() * 0.02;
            double d2 = this.field_70146_Z.nextGaussian() * 0.02;
            this.field_70170_p.func_175688_a(enumparticletypes, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70163_u + 0.5 + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, d0, d1, d2, new int[0]);
        }
    }

    protected void playSitEffect() {
        EnumParticleTypes enumparticletypes = EnumParticleTypes.NOTE;
        for (int i = 0; i < 7; ++i) {
            double d0 = this.field_70146_Z.nextGaussian() * 0.02;
            double d1 = this.field_70146_Z.nextGaussian() * 0.02;
            double d2 = this.field_70146_Z.nextGaussian() * 0.02;
            this.field_70170_p.func_175688_a(enumparticletypes, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70163_u + 0.5 + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, d0, d1, d2, new int[0]);
        }
    }

    public void func_70903_f(boolean tamed) {
        super.func_70903_f(tamed);
        if (tamed) {
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(20.0);
        } else {
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(10.0);
        }
    }

    public boolean func_70097_a(DamageSource par1DamageSource, float par2) {
        if (par1DamageSource.field_76373_n == "inWall" && this.func_70909_n()) {
            return false;
        }
        if (par1DamageSource.field_76373_n == "fall" && this.func_70909_n()) {
            return false;
        }
        if (par1DamageSource.field_76373_n == "drown" && this.func_70909_n()) {
            return false;
        }
        return super.func_70097_a(par1DamageSource, par2);
    }

    public float[] getSkinRGB() {
        return new float[]{this.R, this.G, this.B};
    }

    public void setSkinRGB(int[] RGB) {
        this.R = RGB[0];
        this.G = RGB[1];
        this.B = RGB[2];
    }

    public float[] getNewSkinRGB() {
        return new float[]{this.NewR, this.NewG, this.NewB};
    }

    public void setNewSkinRGB(int[] RGB) {
        this.NewR = RGB[0];
        this.NewG = RGB[1];
        this.NewB = RGB[2];
    }

    public void changeColor(Entity entity) {
        int k;
        int j;
        int i = MathHelper.func_76128_c((double)entity.field_70165_t);
        if (entity.field_70170_p.func_180495_p(new BlockPos(i, j = MathHelper.func_76128_c((double)entity.func_174813_aQ().field_72338_b), k = MathHelper.func_76128_c((double)entity.field_70161_v))).func_177230_c() == Blocks.field_150350_a) {
            j = MathHelper.func_76128_c((double)(entity.func_174813_aQ().field_72338_b - 0.1));
        }
        BlockPos pos = new BlockPos(i, j, k);
        IBlockState state = entity.field_70170_p.func_180495_p(pos);
        int colorMultiplier = Minecraft.func_71410_x().func_184125_al().func_186724_a(state, (IBlockAccess)this.field_70170_p, pos, 0);
        if (state.func_177230_c() != Blocks.field_150350_a && this.currentState != state && this.currentMultiplier != colorMultiplier) {
            this.currentState = state;
            this.currentMultiplier = colorMultiplier;
            int[] newColor = ColorUtil.getBlockStateColor(state, pos, this.field_70170_p);
            if (newColor != null) {
                this.setNewSkinRGB(newColor);
            }
        }
    }

    public boolean func_70601_bi() {
        return super.func_70601_bi();
    }
}

