/*
 * Decompiled with CFR 0.152.
 */
package net.daveyx0.primitivemobs.entity.passive;

import com.google.common.base.Optional;
import com.google.common.collect.Sets;
import javax.annotation.Nullable;
import net.daveyx0.primitivemobs.core.PrimitiveMobsSoundEvents;
import net.daveyx0.primitivemobs.entity.ai.EntityAITemptItemStack;
import net.daveyx0.primitivemobs.util.BlockStateUtil;
import net.daveyx0.primitivemobs.util.ColorUtil;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;

public class EntityGroveSprite
extends EntityCreature {
    private float LeavesR = 0.0f;
    private float LeavesG = 0.0f;
    private float LeavesB = 0.0f;
    private float LogR = 0.0f;
    private float LogG = 0.0f;
    private float LogB = 0.0f;
    private float LogTopR = 0.0f;
    private float LogTopG = 0.0f;
    private float LogTopB = 0.0f;
    private boolean changedColor = false;
    private static final DataParameter<Boolean> IS_CINDER = EntityDataManager.func_187226_a(EntityGroveSprite.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> SAPLING_AMOUNT = EntityDataManager.func_187226_a(EntityGroveSprite.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Optional<IBlockState>> LEAVES = EntityDataManager.func_187226_a(EntityGroveSprite.class, (DataSerializer)DataSerializers.field_187197_g);
    private static final DataParameter<Optional<IBlockState>> LOG = EntityDataManager.func_187226_a(EntityGroveSprite.class, (DataSerializer)DataSerializers.field_187197_g);
    private static final DataParameter<BlockPos> LEAVES_POS = EntityDataManager.func_187226_a(EntityGroveSprite.class, (DataSerializer)DataSerializers.field_187200_j);
    protected Block spawnableBlock = Blocks.field_150349_c;

    public EntityGroveSprite(World worldIn) {
        super(worldIn);
    }

    protected void func_184651_r() {
        int prio = 0;
        this.field_70714_bg.func_75776_a(++prio, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(++prio, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.0, false));
        this.field_70714_bg.func_75776_a(++prio, (EntityAIBase)new EntityAITemptItemStack((EntityCreature)this, 1.1, false, Sets.newHashSet((Object[])new ItemStack[]{this.func_184614_ca(), new ItemStack(Items.field_151100_aR, 1, 15)})));
        this.field_70714_bg.func_75776_a(++prio, (EntityAIBase)new EntityAIMoveTowardsRestriction((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(++prio, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(++prio, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(++prio, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        int attackPrio = 1;
        this.field_70715_bh.func_75776_a(++attackPrio, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true, new Class[0]));
    }

    @Nullable
    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData livingdata) {
        if (!this.field_70170_p.field_72995_K) {
            this.determineLogAndLeaves();
            ItemStack sapling = new ItemStack(this.getLeaves().func_177230_c().func_180660_a(this.getLeaves(), this.field_70146_Z, 100), 1, this.getLeaves().func_177230_c().func_180651_a(this.getLeaves()));
            if (sapling != null) {
                this.func_184201_a(EntityEquipmentSlot.MAINHAND, sapling);
            }
            this.setSaplingAmount(1 + this.field_70146_Z.nextInt(4));
        }
        return super.func_180482_a(difficulty, livingdata);
    }

    private void determineLogAndLeaves() {
        Object[] tree = BlockStateUtil.searchTree((Entity)this, 12.0);
        if (tree != null && tree.length > 0) {
            this.setLog((IBlockState)tree[0]);
            this.setLeaves((IBlockState)tree[1]);
            this.setLeavesPos((BlockPos)tree[2]);
        }
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(40.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.23000000298023224);
    }

    protected void func_70088_a() {
        Optional leaves = Optional.of((Object)Blocks.field_150362_t.func_176223_P());
        Optional log = Optional.of((Object)Blocks.field_150364_r.func_176223_P());
        this.func_184212_Q().func_187214_a(IS_CINDER, (Object)false);
        this.func_184212_Q().func_187214_a(SAPLING_AMOUNT, (Object)0);
        this.func_184212_Q().func_187214_a(LEAVES, (Object)leaves);
        this.func_184212_Q().func_187214_a(LOG, (Object)log);
        this.func_184212_Q().func_187214_a(LEAVES_POS, (Object)new BlockPos(0, 0, 0));
        super.func_70088_a();
    }

    public void func_70636_d() {
        if (this.field_70170_p.field_72995_K && !this.changedColor) {
            this.changedColor = true;
            this.setLeavesRGB(this.getColor((Entity)this, this.getLeaves(), this.getLeavesPos(), null));
            this.setLogRGB(this.getColor((Entity)this, this.getLog(), null, EnumFacing.WEST));
            this.setLogTopRGB(this.getColor((Entity)this, this.getLog(), null, null));
        }
        super.func_70636_d();
    }

    public int[] getColor(Entity entity, IBlockState state, @Nullable BlockPos pos, @Nullable EnumFacing face) {
        if (state.func_177230_c() != Blocks.field_150350_a) {
            int[] newColor = new int[3];
            newColor = face != null ? ColorUtil.getBlockStateColor(state, pos, this.field_70170_p, face) : ColorUtil.getBlockStateColor(state, pos, this.field_70170_p);
            if (newColor != null) {
                return newColor;
            }
        }
        return new int[]{255, 255, 255};
    }

    public float[] getLeavesRGB() {
        return new float[]{this.LeavesR, this.LeavesG, this.LeavesB};
    }

    public void setLeavesRGB(int[] RGB) {
        this.LeavesR = RGB[0];
        this.LeavesG = RGB[1];
        this.LeavesB = RGB[2];
    }

    public float[] getLogRGB() {
        return new float[]{this.LogR, this.LogG, this.LogB};
    }

    public void setLogRGB(int[] RGB) {
        this.LogR = RGB[0];
        this.LogG = RGB[1];
        this.LogB = RGB[2];
    }

    public float[] getLogTopRGB() {
        return new float[]{this.LogTopR, this.LogTopG, this.LogTopB};
    }

    public void setLogTopRGB(int[] RGB) {
        this.LogTopR = RGB[0];
        this.LogTopG = RGB[1];
        this.LogTopB = RGB[2];
    }

    public void setCinderSprite(boolean cinder) {
        this.func_184212_Q().func_187227_b(IS_CINDER, (Object)cinder);
    }

    public boolean isCinderSprite() {
        return (Boolean)this.func_184212_Q().func_187225_a(IS_CINDER);
    }

    public void setSaplingAmount(int saplings) {
        this.func_184212_Q().func_187227_b(SAPLING_AMOUNT, (Object)saplings);
    }

    public int getSaplingAmount() {
        return (Integer)this.func_184212_Q().func_187225_a(SAPLING_AMOUNT);
    }

    public void setLeaves(IBlockState leaves) {
        Optional newLeaves = Optional.of((Object)leaves);
        this.func_184212_Q().func_187227_b(LEAVES, (Object)newLeaves);
    }

    public IBlockState getLeaves() {
        Optional state = (Optional)this.func_184212_Q().func_187225_a(LEAVES);
        return state != null ? (IBlockState)state.get() : Blocks.field_150362_t.func_176223_P();
    }

    public void setLog(IBlockState log) {
        Optional newLog = Optional.of((Object)log);
        this.func_184212_Q().func_187227_b(LOG, (Object)newLog);
    }

    public IBlockState getLog() {
        Optional state = (Optional)this.func_184212_Q().func_187225_a(LOG);
        return state != null ? (IBlockState)state.get() : Blocks.field_150364_r.func_176223_P();
    }

    public void setLeavesPos(BlockPos pos) {
        this.func_184212_Q().func_187227_b(LEAVES_POS, (Object)pos);
    }

    public BlockPos getLeavesPos() {
        BlockPos pos = (BlockPos)this.func_184212_Q().func_187225_a(LEAVES_POS);
        return pos != null ? pos : new BlockPos(0, 0, 0);
    }

    protected SoundEvent func_184639_G() {
        return PrimitiveMobsSoundEvents.ENTITY_GROVESPRITE_IDLE;
    }

    protected float func_70599_aP() {
        return 0.4f;
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        int[] leavesPos = new int[]{this.getLeavesPos().func_177958_n(), this.getLeavesPos().func_177956_o(), this.getLeavesPos().func_177952_p()};
        compound.func_74783_a("LeavesPos", leavesPos);
        int leavesState = Block.func_176210_f((IBlockState)this.getLeaves());
        compound.func_74768_a("LeavesStateID", leavesState);
        int logState = Block.func_176210_f((IBlockState)this.getLog());
        compound.func_74768_a("LogStateID", logState);
        compound.func_74768_a("SaplingAmount", this.getSaplingAmount());
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        if (compound.func_74764_b("LeavesPos")) {
            int[] leavesPos = compound.func_74759_k("LeavesPos");
            this.setLeavesPos(new BlockPos(leavesPos[0], leavesPos[1], leavesPos[2]));
        }
        IBlockState leavesState = Block.func_176220_d((int)compound.func_74762_e("LeavesStateID"));
        IBlockState logState = Block.func_176220_d((int)compound.func_74762_e("LogStateID"));
        this.setLeaves(leavesState);
        this.setLog(logState);
        this.setSaplingAmount(compound.func_74762_e("SaplingAmount"));
    }

    public boolean func_70601_bi() {
        int k;
        int j;
        int i = MathHelper.func_76128_c((double)this.field_70165_t);
        BlockPos blockpos = new BlockPos(i, j = MathHelper.func_76128_c((double)this.func_174813_aQ().field_72338_b), k = MathHelper.func_76128_c((double)this.field_70161_v));
        return this.field_70170_p.func_180495_p(blockpos.func_177977_b()).func_177230_c() == this.spawnableBlock && this.field_70170_p.func_175699_k(blockpos) > 8 && super.func_70601_bi();
    }
}

