/*
 * Decompiled with CFR 0.152.
 */
package net.daveyx0.primitivemobs.loot;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.logging.Level;
import net.daveyx0.primitivemobs.config.PrimitiveMobsConfigMobs;
import net.daveyx0.primitivemobs.core.PrimitiveMobsLogger;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import scala.Tuple2;

public class FilchLizardLoot {
    private static final Map<Tuple2<Item, Integer>, Integer> possibleLoot = new HashMap<Tuple2<Item, Integer>, Integer>();

    public static void load() {
        String[] finalStealLoot;
        possibleLoot.clear();
        for (String entry : finalStealLoot = PrimitiveMobsConfigMobs.getFilchStealLoot()) {
            FilchLizardLoot.addLoot(entry);
        }
    }

    public static String[] getDefaultValues() {
        return new String[]{"modID:itemName:metaData:weight", "minecraft:gold_ingot:0:3", "minecraft:iron_ingot:0:6", "minecraft:dye:4:4", "minecraft:diamond:0:1", "minecraft:emerald:0:1", "minecraft:ender_pearl:0:2", "minecraft:flint:0:8"};
    }

    public static void addLoot(String configEntry) {
        if (configEntry.equals("modID:itemName:metaData:weight")) {
            return;
        }
        String[] dividedEntry = configEntry.split(":");
        if (dividedEntry != null && dividedEntry.length == 4) {
            String mod = dividedEntry[0];
            String item = dividedEntry[1];
            int meta = 0;
            int weight = 0;
            try {
                meta = Integer.parseInt(dividedEntry[2]);
                weight = Integer.parseInt(dividedEntry[3]);
            }
            catch (NumberFormatException e) {
                PrimitiveMobsLogger.PMlogger.log(Level.WARNING, "Treasure Slime treasure entry has incorrect format.");
            }
            if (!mod.isEmpty() && !item.isEmpty() && meta >= 0 && weight > 0) {
                FilchLizardLoot.addLoot(mod, item, meta, weight);
            } else {
                PrimitiveMobsLogger.PMlogger.log(Level.WARNING, "Treasure Slime treasure entry has incorrect format.");
            }
        }
    }

    public static void addLoot(Item item, int meta, int weight) {
        if (Item.field_150901_e.func_148741_d((Object)item.getRegistryName())) {
            possibleLoot.put((Tuple2<Item, Integer>)new Tuple2((Object)item, (Object)meta), weight);
        } else {
            PrimitiveMobsLogger.PMlogger.log(Level.WARNING, "Treasure Slime treasure entry does not excist.");
        }
    }

    public static void addLoot(String resourcelocation, int meta, int weight) {
        if (Item.field_150901_e.func_148741_d((Object)new ResourceLocation(resourcelocation))) {
            possibleLoot.put((Tuple2<Item, Integer>)new Tuple2(Item.field_150901_e.func_82594_a((Object)new ResourceLocation(resourcelocation)), (Object)meta), weight);
        } else {
            PrimitiveMobsLogger.PMlogger.log(Level.WARNING, "Treasure Slime treasure entry does not excist.");
        }
    }

    public static void addLoot(String mod, String itemName, int meta, int weight) {
        if (Item.field_150901_e.func_148741_d((Object)new ResourceLocation(mod, itemName))) {
            possibleLoot.put((Tuple2<Item, Integer>)new Tuple2(Item.field_150901_e.func_82594_a((Object)new ResourceLocation(mod, itemName)), (Object)meta), weight);
        } else {
            PrimitiveMobsLogger.PMlogger.log(Level.WARNING, "Treasure Slime treasure entry does not excist.");
        }
    }

    public static int getTotalWeight() {
        Collection<Integer> weights = possibleLoot.values();
        int totalWeights = 0;
        for (int weight : weights) {
            totalWeights += weight;
        }
        return totalWeights;
    }

    public static ItemStack[] getLootList() {
        if (!possibleLoot.isEmpty() && possibleLoot != null) {
            ItemStack[] itemstacks = new ItemStack[FilchLizardLoot.getTotalWeight()];
            Set<Tuple2<Item, Integer>> tuples = possibleLoot.keySet();
            Object[] tuplesArray = tuples.toArray(new Object[tuples.size()]);
            int currentIndex = 0;
            for (int i = 0; i < tuplesArray.length; ++i) {
                Tuple2 tuple = (Tuple2)tuplesArray[i];
                itemstacks[currentIndex] = new ItemStack((Item)tuple._1, 1, ((Integer)tuple._2).intValue());
                ++currentIndex;
            }
            return itemstacks;
        }
        return new ItemStack[]{new ItemStack(Items.field_151043_k)};
    }

    public static ItemStack getRandomLootItem(Random random) {
        if (!possibleLoot.isEmpty() && possibleLoot != null) {
            int randomIndex;
            ItemStack randomStack;
            Item[] items = new Item[FilchLizardLoot.getTotalWeight()];
            int[] metas = new int[FilchLizardLoot.getTotalWeight()];
            Collection<Integer> weights = possibleLoot.values();
            Set<Tuple2<Item, Integer>> tuples = possibleLoot.keySet();
            Object[] weightsArray = weights.toArray(new Object[weights.size()]);
            Object[] tuplesArray = tuples.toArray(new Object[tuples.size()]);
            int currentIndex = 0;
            for (int i = 0; i < tuplesArray.length; ++i) {
                for (int j = 0; j < (Integer)weightsArray[i]; ++j) {
                    Tuple2 tuple = (Tuple2)tuplesArray[i];
                    items[currentIndex] = (Item)tuple._1;
                    metas[currentIndex] = (Integer)tuple._2;
                    ++currentIndex;
                }
            }
            if (items != null && items.length > 0 && (randomStack = new ItemStack(items[randomIndex = random.nextInt(items.length)], 1, metas[randomIndex])) != null) {
                return randomStack;
            }
        }
        return new ItemStack(Items.field_151123_aH);
    }
}

