/*
 * Decompiled with CFR 0.152.
 */
package net.daveyx0.primitivemobs.loot;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.logging.Level;
import net.daveyx0.primitivemobs.config.PrimitiveMobsConfigMobs;
import net.daveyx0.primitivemobs.core.PrimitiveMobsLogger;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import scala.Tuple2;

public class HauntedToolLoot {
    private static final Map<Tuple2<Item, Integer>, Integer> possibleLoot = new HashMap<Tuple2<Item, Integer>, Integer>();

    public static void load() {
        String[] finalToolLoot;
        possibleLoot.clear();
        for (String entry : finalToolLoot = PrimitiveMobsConfigMobs.getHauntedToolLoot()) {
            HauntedToolLoot.addLoot(entry);
        }
    }

    public static String[] getDefaultValues() {
        return new String[]{"modID:toolName:metaData:weight", "minecraft:wooden_sword:0:10", "minecraft:wooden_axe:0:10", "minecraft:wooden_pickaxe:0:10", "minecraft:wooden_hoe:0:10", "minecraft:stone_sword:0:8", "minecraft:stone_axe:0:8", "minecraft:stone_pickaxe:0:8", "minecraft:stone_hoe:0:8", "minecraft:iron_sword:0:5", "minecraft:iron_axe:0:5", "minecraft:iron_pickaxe:0:5", "minecraft:iron_hoe:0:5", "minecraft:golden_sword:0:3", "minecraft:golden_axe:0:3", "minecraft:golden_pickaxe:0:3", "minecraft:golden_hoe:0:3", "minecraft:diamond_sword:0:1", "minecraft:diamond_axe:0:1", "minecraft:diamond_pickaxe:0:1", "minecraft:diamond_hoe:0:1"};
    }

    public static float getHealthFromTool(ItemStack tool) {
        if (tool != null && tool.func_77973_b() != null && tool.func_77973_b().func_77616_k(tool)) {
            float health = (float)tool.func_77973_b().getMaxDamage(tool) / 10.0f;
            if (health > 100.0f) {
                health = 100.0f;
            }
            return health;
        }
        return 10.0f;
    }

    public static double getDamageFromHeldItem(EntityLiving entity) {
        if (entity.func_184614_ca() != null && entity.func_184614_ca().func_77973_b() != null && entity.func_184614_ca().func_77973_b().func_77616_k(entity.func_184614_ca())) {
            Collection modifiers = entity.func_184614_ca().func_111283_C(EntityLiving.func_184640_d((ItemStack)entity.func_184614_ca())).get((Object)SharedMonsterAttributes.field_111264_e.func_111108_a());
            if (modifiers != null && !modifiers.isEmpty()) {
                Object[] mods = modifiers.toArray(new Object[modifiers.size()]);
                AttributeModifier attribute = (AttributeModifier)mods[0];
                double attackDamage = attribute.func_111164_d() / 2.0;
                if (attackDamage <= 1.0) {
                    attackDamage = 1.0;
                } else if (attackDamage > 8.0) {
                    attackDamage = 8.0;
                }
                return attackDamage;
            }
        }
        return 1.0;
    }

    public static double getSpeedFromHeldItem(EntityLiving entity) {
        if (entity.func_184614_ca() != null && entity.func_184614_ca().func_77973_b() != null && entity.func_184614_ca().func_77973_b().func_77616_k(entity.func_184614_ca())) {
            Collection modifiers = entity.func_184614_ca().func_111283_C(EntityLiving.func_184640_d((ItemStack)entity.func_184614_ca())).get((Object)SharedMonsterAttributes.field_188790_f.func_111108_a());
            if (modifiers != null && !modifiers.isEmpty()) {
                Object[] mods = modifiers.toArray(new Object[modifiers.size()]);
                AttributeModifier attribute = (AttributeModifier)mods[0];
                double attackSpeed = 0.5 - attribute.func_111164_d() * -1.0 * 0.1;
                if (attackSpeed <= 0.1) {
                    attackSpeed = 0.1;
                } else if (attackSpeed > 0.3) {
                    attackSpeed = 0.3;
                }
                return attackSpeed;
            }
        }
        return 0.2;
    }

    public static void addLoot(String configEntry) {
        if (configEntry.equals("modID:toolName:metaData:weight")) {
            return;
        }
        String[] dividedEntry = configEntry.split(":");
        if (dividedEntry != null && dividedEntry.length == 4) {
            String mod = dividedEntry[0];
            String item = dividedEntry[1];
            int meta = 0;
            int weight = 0;
            try {
                meta = Integer.parseInt(dividedEntry[2]);
                weight = Integer.parseInt(dividedEntry[3]);
            }
            catch (NumberFormatException e) {
                PrimitiveMobsLogger.PMlogger.log(Level.WARNING, "Haunted Tool tool entry has incorrect format.");
            }
            if (!mod.isEmpty() && !item.isEmpty() && meta >= 0 && weight > 0) {
                HauntedToolLoot.addLoot(mod, item, meta, weight);
            } else {
                PrimitiveMobsLogger.PMlogger.log(Level.WARNING, "Haunted Tool tool entry has incorrect format.");
            }
        }
    }

    public static void addLoot(Item item, int meta, int weight) {
        if (Item.field_150901_e.func_148741_d((Object)item.getRegistryName())) {
            possibleLoot.put((Tuple2<Item, Integer>)new Tuple2((Object)item, (Object)meta), weight);
        } else {
            PrimitiveMobsLogger.PMlogger.log(Level.WARNING, "Haunted Tool tool entry does not excist.");
        }
    }

    public static void addLoot(String resourcelocation, int meta, int weight) {
        if (Item.field_150901_e.func_148741_d((Object)new ResourceLocation(resourcelocation))) {
            possibleLoot.put((Tuple2<Item, Integer>)new Tuple2(Item.field_150901_e.func_82594_a((Object)new ResourceLocation(resourcelocation)), (Object)meta), weight);
        } else {
            PrimitiveMobsLogger.PMlogger.log(Level.WARNING, "Haunted Tool tool entry does not excist.");
        }
    }

    public static void addLoot(String mod, String itemName, int meta, int weight) {
        if (Item.field_150901_e.func_148741_d((Object)new ResourceLocation(mod, itemName))) {
            possibleLoot.put((Tuple2<Item, Integer>)new Tuple2(Item.field_150901_e.func_82594_a((Object)new ResourceLocation(mod, itemName)), (Object)meta), weight);
        } else {
            PrimitiveMobsLogger.PMlogger.log(Level.WARNING, "Haunted Tool tool entry does not excist.");
        }
    }

    public static int getTotalWeight() {
        Collection<Integer> weights = possibleLoot.values();
        int totalWeights = 0;
        for (int weight : weights) {
            totalWeights += weight;
        }
        return totalWeights;
    }

    public static ItemStack getRandomLootItem(Random random) {
        if (!possibleLoot.isEmpty() && possibleLoot != null) {
            int randomIndex;
            ItemStack randomStack;
            Item[] items = new Item[HauntedToolLoot.getTotalWeight()];
            int[] metas = new int[HauntedToolLoot.getTotalWeight()];
            Collection<Integer> weights = possibleLoot.values();
            Set<Tuple2<Item, Integer>> tuples = possibleLoot.keySet();
            Object[] weightsArray = weights.toArray(new Object[weights.size()]);
            Object[] tuplesArray = tuples.toArray(new Object[tuples.size()]);
            int currentIndex = 0;
            for (int i = 0; i < tuplesArray.length; ++i) {
                for (int j = 0; j < (Integer)weightsArray[i]; ++j) {
                    Tuple2 tuple = (Tuple2)tuplesArray[i];
                    items[currentIndex] = (Item)tuple._1;
                    metas[currentIndex] = (Integer)tuple._2;
                    ++currentIndex;
                }
            }
            if (items != null && items.length > 0 && (randomStack = new ItemStack(items[randomIndex = random.nextInt(items.length)], 1, metas[randomIndex])) != null) {
                return randomStack;
            }
        }
        return new ItemStack(Items.field_151041_m);
    }
}

