/*
 * Decompiled with CFR 0.152.
 */
package net.daveyx0.primitivemobs.spawn;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import net.daveyx0.primitivemobs.core.PrimitiveMobsSpawnList;
import net.daveyx0.primitivemobs.spawn.PrimitiveMobsSpawnEntry;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.management.PlayerChunkMapEntry;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.WorldEntitySpawner;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.common.eventhandler.Event;

public class PrimitiveMobsWorldSpawner {
    private final Set<ChunkPos> chunksForSpawning = Sets.newHashSet();

    public int doCustomSpawning(WorldServer worldServerIn) {
        this.chunksForSpawning.clear();
        int chunkCount = 0;
        int successCount = 0;
        for (EntityPlayer entityplayer : worldServerIn.field_73010_i) {
            if (entityplayer.func_175149_v()) continue;
            int playerX = MathHelper.func_76128_c((double)(entityplayer.field_70165_t / 16.0));
            int playerY = MathHelper.func_76128_c((double)(entityplayer.field_70161_v / 16.0));
            int center = 8;
            for (int x = -8; x <= 8; ++x) {
                for (int z = -8; z <= 8; ++z) {
                    PlayerChunkMapEntry entry;
                    boolean border = x == -8 || x == 8 || z == -8 || z == 8;
                    ChunkPos chunkpos = new ChunkPos(x + playerX, z + playerY);
                    if (this.chunksForSpawning.contains(chunkpos)) continue;
                    ++chunkCount;
                    if (border || !worldServerIn.func_175723_af().func_177730_a(chunkpos) || (entry = worldServerIn.func_184164_w().func_187301_b(chunkpos.field_77276_a, chunkpos.field_77275_b)) == null || !entry.func_187274_e()) continue;
                    this.chunksForSpawning.add(chunkpos);
                }
            }
        }
        for (PrimitiveMobsSpawnEntry entry : PrimitiveMobsSpawnList.getSpawnEntries()) {
            int max;
            int entityCount = worldServerIn.func_72907_a(entry.entityClass);
            if (entityCount > (max = Math.round((float)chunkCount * entry.rarity * 0.1f))) continue;
            ArrayList shuffled = Lists.newArrayList(this.chunksForSpawning);
            Collections.shuffle(shuffled);
            for (ChunkPos chunk : shuffled) {
                EntityLiving entity;
                Biome biome;
                BlockPos pos = PrimitiveMobsWorldSpawner.getRandomChunkPosition((World)worldServerIn, chunk.field_77276_a, chunk.field_77275_b);
                int x = pos.func_177958_n();
                int y = pos.func_177956_o();
                int z = pos.func_177952_p();
                IBlockState state = worldServerIn.func_180495_p(pos);
                float x1 = (float)x + 0.5f;
                float z1 = (float)z + 0.5f;
                if (state.func_185915_l() || worldServerIn.func_175636_b((double)x1, (double)y, (double)z1, 24.0) || !entry.isBiomeSuitable(biome = worldServerIn.func_180494_b(pos)) || !WorldEntitySpawner.func_180267_a((EntityLiving.SpawnPlacementType)EntitySpawnPlacementRegistry.func_180109_a(entry.entityClass), (World)worldServerIn, (BlockPos)pos)) continue;
                try {
                    entity = entry.entityClass.getConstructor(World.class).newInstance(worldServerIn);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    return successCount;
                }
                entity.func_70012_b((double)x1, (double)y, (double)z1, worldServerIn.field_73012_v.nextFloat() * 360.0f, 0.0f);
                Event.Result canSpawn = ForgeEventFactory.canEntitySpawn((EntityLiving)entity, (World)worldServerIn, (float)x1, (float)y, (float)z1);
                if (canSpawn != Event.Result.ALLOW && (canSpawn != Event.Result.DEFAULT || !entity.func_70601_bi() || !entity.func_70058_J())) continue;
                if (!ForgeEventFactory.doSpecialSpawn((EntityLiving)entity, (World)worldServerIn, (float)x1, (float)y, (float)z1)) {
                    entity.func_180482_a(worldServerIn.func_175649_E(new BlockPos((Entity)entity)), null);
                }
                if (entity.func_70058_J()) {
                    ++successCount;
                    worldServerIn.func_72838_d((Entity)entity);
                    continue;
                }
                entity.func_70106_y();
            }
        }
        return successCount;
    }

    private static BlockPos getRandomChunkPosition(World worldIn, int x, int z) {
        Chunk chunk = worldIn.func_72964_e(x, z);
        int i = x * 16 + worldIn.field_73012_v.nextInt(16);
        int j = z * 16 + worldIn.field_73012_v.nextInt(16);
        int k = MathHelper.func_154354_b((int)(chunk.func_177433_f(new BlockPos(i, 0, j)) + 1), (int)16);
        int l = worldIn.field_73012_v.nextInt(k > 0 ? k : chunk.func_76625_h() + 16 - 1);
        return new BlockPos(i, l, j);
    }
}

