/*
 * Decompiled with CFR 0.152.
 */
package net.daveyx0.primitivemobs.util;

import java.awt.Color;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.daveyx0.primitivemobs.util.ImageUtil;
import net.daveyx0.primitivemobs.util.ResourceLocationUtil;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.SimpleReloadableResourceManager;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ColorUtil {
    public static int[] getBlockStateColor(IBlockState state, @Nullable BlockPos pos, @Nullable World worldObj) {
        return ColorUtil.getBlockStateColor(state, pos, worldObj, EnumFacing.UP);
    }

    public static int[] getBlockStateColor(IBlockState state, @Nullable BlockPos pos, @Nullable World worldObj, EnumFacing face) {
        int[] color = new int[3];
        int colorMultiplier = -1;
        colorMultiplier = Minecraft.func_71410_x().func_184125_al().func_186724_a(state, (IBlockAccess)worldObj, pos, 0);
        if (state.func_177230_c() != Blocks.field_150350_a) {
            MapColor mapcolor;
            Color colour = new Color(colorMultiplier, true);
            if (colorMultiplier != -1 && (colour.getRed() != colour.getGreen() || colour.getGreen() != colour.getBlue() || colour.getBlue() != colour.getRed()) && state.func_177230_c() != Blocks.field_150398_cm) {
                color[0] = colour.getRed();
                color[1] = colour.getGreen();
                color[2] = colour.getBlue();
            } else {
                List quads;
                String textureName = Minecraft.func_71410_x().func_175602_ab().func_175023_a().func_178122_a(state).func_94215_i();
                String modelName = textureName.replaceAll(":", ":models/");
                ModelResourceLocation model = new ModelResourceLocation(modelName);
                String topTextureName = "";
                if (model != null && (quads = Minecraft.func_71410_x().func_175602_ab().func_175023_a().func_178125_b(state).func_188616_a(state, face, 1L)) != null && !quads.isEmpty() && quads.size() > 0) {
                    topTextureName = ((BakedQuad)quads.get(0)).func_187508_a().func_94215_i();
                }
                if (!topTextureName.equals("") && !topTextureName.equals("missingno")) {
                    color = ColorUtil.getTextureColor(topTextureName, "blocks");
                } else if (!textureName.equals("") && !textureName.equals("missingno")) {
                    color = ColorUtil.getTextureColor(textureName, "blocks");
                }
            }
            if (color == null && colorMultiplier == -1 && (mapcolor = state.func_185909_g()) != null) {
                colorMultiplier = mapcolor.field_76291_p;
            }
        }
        return color;
    }

    public static int[] getItemStackColor(ItemStack stack, World worldObj) {
        int[] color = new int[3];
        int colorMultiplier = -1;
        colorMultiplier = Minecraft.func_71410_x().getItemColors().func_186728_a(stack, 0);
        if (colorMultiplier != -1) {
            Color colour = new Color(colorMultiplier, true);
            color[0] = colour.getRed();
            color[1] = colour.getGreen();
            color[2] = colour.getBlue();
        } else {
            String textureName = "";
            List quads = Minecraft.func_71410_x().func_175599_af().func_184393_a(stack, worldObj, null).func_188616_a(null, null, 1L);
            if (quads != null && !quads.isEmpty() && quads.size() > 0) {
                textureName = ((BakedQuad)quads.get(0)).func_187508_a().func_94215_i();
            }
            if (!textureName.equals("") && !textureName.equals("missingno")) {
                color = ColorUtil.getTextureColor(textureName, "items");
            }
        }
        return color;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int[] getTextureColor(String name, String type) {
        SimpleReloadableResourceManager resourceManager = (SimpleReloadableResourceManager)Minecraft.func_71410_x().func_110442_L();
        Set set = resourceManager.func_135055_a();
        Object[] domains = set.toArray();
        IResource resource = null;
        int[] rgb = null;
        if (name.contains(":")) {
            String[] divided = name.split(":");
            if (divided != null && divided.length > 0) {
                resource = ResourceLocationUtil.getResource(divided[0].toString(), "textures/" + divided[1] + ".png");
            }
        } else {
            for (int i = 0; i < domains.length && (resource = ResourceLocationUtil.getResource(domains[i].toString(), "textures/" + type + "/" + name + ".png")) == null; ++i) {
            }
        }
        if (resource != null) {
            InputStream stream = resource.func_110527_b();
            try {
                rgb = ImageUtil.main(stream);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                try {
                    stream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return rgb;
    }

    public static int[] setBrightness(int[] rgb, float brightness) {
        float newBrightness;
        float newRed = (float)rgb[0] / 255.0f;
        float newGreen = (float)rgb[1] / 255.0f;
        float newBlue = (float)rgb[2] / 255.0f;
        if (brightness < 0.0f) {
            newBrightness = brightness * -1.0f;
            newBrightness = 1.0f - newBrightness / 100.0f;
            newRed *= newBrightness;
            newGreen *= newBrightness;
            newBlue *= newBrightness;
        } else if (brightness > 0.0f) {
            newBrightness = brightness;
            float tempRed = (1.0f - newRed) * (newBrightness /= 100.0f);
            float tempGreen = (1.0f - newGreen) * newBrightness;
            float tempBlue = (1.0f - newBlue) * newBrightness;
            newRed += tempRed;
            newGreen += tempGreen;
            newBlue += tempBlue;
        }
        if (newRed > 1.0f) {
            newRed = 1.0f;
        }
        if (newGreen > 1.0f) {
            newGreen = 1.0f;
        }
        if (newBlue > 1.0f) {
            newBlue = 1.0f;
        }
        int[] newColor = new int[]{Math.round(newRed * 255.0f), Math.round(newGreen * 255.0f), Math.round(newBlue * 255.0f)};
        return newColor;
    }
}

