/*
 * Decompiled with CFR 0.152.
 */
package net.daveyx0.primitivemobs.util;

import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;

public class ImageUtil {
    public static int[] main(InputStream fileloc) throws Exception {
        ImageInputStream is = ImageIO.createImageInputStream(fileloc);
        Iterator<ImageReader> iter = ImageIO.getImageReaders(is);
        if (!iter.hasNext()) {
            System.out.println("Cannot load the specified file ");
        }
        ImageReader imageReader = iter.next();
        imageReader.setInput(is);
        BufferedImage imageOld = imageReader.read(0);
        BufferedImage image = ImageUtil.getScaledImage(imageOld, 8, 8);
        int[] colour = ImageUtil.getAverageColour(image);
        try {
            is.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return colour;
    }

    public static int[] getMostCommonColour(BufferedImage image) {
        int height = image.getHeight();
        int width = image.getWidth();
        HashMap<Integer, Integer> map = new HashMap<Integer, Integer>();
        for (int i = 0; i < width; ++i) {
            for (int j = 0; j < height; ++j) {
                int rgb = image.getRGB(i, j);
                int[] rgbArr = ImageUtil.getRGBArr(rgb);
                if (rgbArr[3] == 0) continue;
                Integer counter = (Integer)map.get(rgb);
                if (counter == null) {
                    counter = 0;
                }
                Integer n = counter;
                Integer n2 = counter = Integer.valueOf(counter + 1);
                map.put(rgb, counter);
            }
        }
        LinkedList list = new LinkedList(map.entrySet());
        Collections.sort(list, new Comparator(){

            public int compare(Object o1, Object o2) {
                return ((Comparable)((Map.Entry)o1).getValue()).compareTo(((Map.Entry)o2).getValue());
            }
        });
        Map.Entry me = (Map.Entry)list.get(list.size() - 1);
        int[] rgb = ImageUtil.getRGBArr((Integer)me.getKey());
        return rgb;
    }

    public static int[] getAverageColour(BufferedImage image) {
        int height = image.getHeight();
        int width = image.getWidth();
        ArrayList<Object> list = new ArrayList<Object>();
        for (int i = 0; i < width; ++i) {
            for (int j = 0; j < height; ++j) {
                int rgb = image.getRGB(i, j);
                Object rgbArr = ImageUtil.getRGBArr(rgb);
                if (rgbArr[3] == false) continue;
                list.add(rgbArr);
            }
        }
        int totalRed = 0;
        int totalGreen = 0;
        int totalBlue = 0;
        for (int[] nArray : list) {
            totalRed += nArray[0];
            totalGreen += nArray[1];
            totalBlue += nArray[2];
        }
        int avgRed = totalRed / list.size();
        int n = totalGreen / list.size();
        int avgBlue = totalBlue / list.size();
        return new int[]{avgRed, n, avgBlue, 1};
    }

    public static int[] getRGBArr(int pixel) {
        int alpha = pixel >> 24 & 0xFF;
        int red = pixel >> 16 & 0xFF;
        int green = pixel >> 8 & 0xFF;
        int blue = pixel & 0xFF;
        return new int[]{red, green, blue, alpha};
    }

    private static BufferedImage getScaledImage(BufferedImage src, int w, int h) {
        int finalw = w;
        int finalh = h;
        double factor = 1.0;
        if (src.getWidth() > src.getHeight()) {
            factor = (double)src.getHeight() / (double)src.getWidth();
            finalh = (int)((double)finalw * factor);
        } else {
            factor = (double)src.getWidth() / (double)src.getHeight();
            finalw = (int)((double)finalh * factor);
        }
        if (finalw <= 0) {
            finalw = w;
        }
        if (finalh <= 0) {
            finalh = h;
        }
        BufferedImage resizedImg = new BufferedImage(finalw, finalh, 3);
        Graphics2D g2 = resizedImg.createGraphics();
        g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        g2.drawImage(src, 0, 0, finalw, finalh, null);
        g2.dispose();
        return resizedImg;
    }
}

