/*
 * Decompiled with CFR 0.152.
 */
package net.daveyx0.primitivemobs.entity.monster;

import net.daveyx0.primitivemobs.entity.monster.EntityTreasureSlime;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.Chunk;

public class EntityPrimitiveSlime
extends EntityLiving
implements IMob {
    public float squishAmount;
    public float squishFactor;
    public float prevSquishFactor;
    private int slimeJumpDelay;
    private static final String __OBFID = "CL_00001698";

    public EntityPrimitiveSlime(World p_i1742_1_) {
        super(p_i1742_1_);
        int i = 1 << this.field_70146_Z.nextInt(3);
        this.field_70129_M = 0.0f;
        this.slimeJumpDelay = this.field_70146_Z.nextInt(20) + 10;
        this.setSlimeSize(i);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(16, (Object)new Byte(1));
    }

    public void setSlimeSize(int p_70799_1_) {
        this.field_70180_af.func_75692_b(16, (Object)new Byte((byte)p_70799_1_));
        this.func_70105_a(0.6f * (float)p_70799_1_, 0.6f * (float)p_70799_1_);
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)(p_70799_1_ * p_70799_1_));
        this.func_70606_j(this.func_110138_aP());
        this.field_70728_aV = p_70799_1_;
    }

    public int getSlimeSize() {
        return this.field_70180_af.func_75683_a(16);
    }

    public void func_70014_b(NBTTagCompound p_70014_1_) {
        super.func_70014_b(p_70014_1_);
        p_70014_1_.func_74768_a("Size", this.getSlimeSize() - 1);
    }

    public void func_70037_a(NBTTagCompound p_70037_1_) {
        super.func_70037_a(p_70037_1_);
        int i = p_70037_1_.func_74762_e("Size");
        if (i < 0) {
            i = 0;
        }
        this.setSlimeSize(i + 1);
    }

    protected String getSlimeParticle() {
        return "slime";
    }

    protected String getJumpSound() {
        return "mob.slime." + (this.getSlimeSize() > 1 ? "big" : "small");
    }

    public void func_70071_h_() {
        int i;
        EntityTreasureSlime slime;
        if (this instanceof EntityTreasureSlime && (slime = (EntityTreasureSlime)this).getItem() != 20 && !this.field_70170_p.field_72995_K && this.field_70170_p.field_73013_u == EnumDifficulty.PEACEFUL && this.getSlimeSize() > 0) {
            this.field_70128_L = true;
        }
        this.squishFactor += (this.squishAmount - this.squishFactor) * 0.5f;
        this.prevSquishFactor = this.squishFactor;
        boolean flag = this.field_70122_E;
        super.func_70071_h_();
        if (this.field_70122_E && !flag) {
            i = this.getSlimeSize();
            for (int j = 0; j < i * 8; ++j) {
                float f = this.field_70146_Z.nextFloat() * (float)Math.PI * 2.0f;
                float f1 = this.field_70146_Z.nextFloat() * 0.5f + 0.5f;
                float f2 = MathHelper.func_76126_a((float)f) * (float)i * 0.5f * f1;
                float f3 = MathHelper.func_76134_b((float)f) * (float)i * 0.5f * f1;
                this.field_70170_p.func_72869_a(this.getSlimeParticle(), this.field_70165_t + (double)f2, this.field_70121_D.field_72338_b, this.field_70161_v + (double)f3, 0.0, 0.0, 0.0);
            }
            if (this.makesSoundOnLand()) {
                this.func_85030_a(this.getJumpSound(), this.func_70599_aP(), ((this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f) / 0.8f);
            }
            this.squishAmount = -0.5f;
        } else if (!this.field_70122_E && flag) {
            this.squishAmount = 1.0f;
        }
        this.alterSquishAmount();
        if (this.field_70170_p.field_72995_K) {
            i = this.getSlimeSize();
            this.func_70105_a(0.6f * (float)i, 0.6f * (float)i);
        }
    }

    protected void func_70626_be() {
        this.func_70623_bb();
        EntityPlayer entityplayer = this.field_70170_p.func_72856_b((Entity)this, 16.0);
        if (entityplayer != null) {
            this.func_70625_a((Entity)entityplayer, 10.0f, 20.0f);
        }
        if (this.field_70122_E && this.slimeJumpDelay-- <= 0) {
            this.slimeJumpDelay = this.getJumpDelay();
            if (entityplayer != null) {
                this.slimeJumpDelay /= 3;
            }
            this.field_70703_bu = true;
            if (this.makesSoundOnJump()) {
                this.func_85030_a(this.getJumpSound(), this.func_70599_aP(), ((this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f) * 0.8f);
            }
            this.field_70702_br = 1.0f - this.field_70146_Z.nextFloat() * 2.0f;
            this.field_70701_bs = 1 * this.getSlimeSize();
        } else {
            this.field_70703_bu = false;
            if (this.field_70122_E) {
                this.field_70701_bs = 0.0f;
                this.field_70702_br = 0.0f;
            }
        }
    }

    protected void alterSquishAmount() {
        this.squishAmount *= 0.6f;
    }

    protected int getJumpDelay() {
        return this.field_70146_Z.nextInt(20) + 10;
    }

    protected EntityPrimitiveSlime createInstance() {
        return new EntityPrimitiveSlime(this.field_70170_p);
    }

    public void func_70106_y() {
        int i = this.getSlimeSize();
        if (!this.field_70170_p.field_72995_K && i > 1 && this.func_110143_aJ() <= 0.0f) {
            int j = 2 + this.field_70146_Z.nextInt(3);
            for (int k = 0; k < j; ++k) {
                float f = ((float)(k % 2) - 0.5f) * (float)i / 4.0f;
                float f1 = ((float)(k / 2) - 0.5f) * (float)i / 4.0f;
                EntityPrimitiveSlime entityslime = this.createInstance();
                entityslime.setSlimeSize(i / 2);
                entityslime.func_70012_b(this.field_70165_t + (double)f, this.field_70163_u + 0.5, this.field_70161_v + (double)f1, this.field_70146_Z.nextFloat() * 360.0f, 0.0f);
                this.field_70170_p.func_72838_d((Entity)entityslime);
            }
        }
        super.func_70106_y();
    }

    public void func_70100_b_(EntityPlayer p_70100_1_) {
        if (this.canDamagePlayer()) {
            int i = this.getSlimeSize();
            if (this.func_70685_l((Entity)p_70100_1_) && this.func_70068_e((Entity)p_70100_1_) < 0.6 * (double)i * 0.6 * (double)i && p_70100_1_.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), (float)this.getAttackStrength())) {
                this.func_85030_a("mob.attack", 1.0f, (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f);
            }
        }
    }

    protected boolean canDamagePlayer() {
        return this.getSlimeSize() > 1;
    }

    protected int getAttackStrength() {
        return this.getSlimeSize();
    }

    protected String func_70621_aR() {
        return "mob.slime." + (this.getSlimeSize() > 1 ? "big" : "small");
    }

    protected String func_70673_aS() {
        return "mob.slime." + (this.getSlimeSize() > 1 ? "big" : "small");
    }

    protected Item func_146068_u() {
        return this.getSlimeSize() == 1 ? Items.field_151123_aH : Item.func_150899_d((int)0);
    }

    public boolean func_70601_bi() {
        Chunk chunk = this.field_70170_p.func_72938_d(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)this.field_70161_v));
        if (this.field_70170_p.func_72912_H().func_76067_t().handleSlimeSpawnReduction(this.field_70146_Z, this.field_70170_p)) {
            return false;
        }
        if (this.getSlimeSize() == 1 || this.field_70170_p.field_73013_u != EnumDifficulty.PEACEFUL) {
            BiomeGenBase biomegenbase = this.field_70170_p.func_72807_a(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)this.field_70161_v));
            if (biomegenbase == BiomeGenBase.field_76780_h && this.field_70163_u > 50.0 && this.field_70163_u < 70.0 && this.field_70146_Z.nextFloat() < 0.5f && this.field_70146_Z.nextFloat() < this.field_70170_p.func_130001_d() && this.field_70170_p.func_72957_l(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)this.field_70163_u), MathHelper.func_76128_c((double)this.field_70161_v)) <= this.field_70146_Z.nextInt(8)) {
                return super.func_70601_bi();
            }
            if (this.field_70146_Z.nextInt(10) == 0 && chunk.func_76617_a(987234911L).nextInt(10) == 0 && this.field_70163_u < 40.0) {
                return super.func_70601_bi();
            }
        }
        return false;
    }

    protected float func_70599_aP() {
        return 0.4f * (float)this.getSlimeSize();
    }

    public int func_70646_bf() {
        return 0;
    }

    protected boolean makesSoundOnJump() {
        return this.getSlimeSize() > 0;
    }

    protected boolean makesSoundOnLand() {
        return this.getSlimeSize() > 2;
    }
}

