/*
 * Decompiled with CFR 0.152.
 */
package net.daveyx0.primitivemobs.lib;

import cpw.mods.fml.common.registry.EntityRegistry;
import net.daveyx0.primitivemobs.lib.SpawnListWeightHelper;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.BiomeDictionary;

public class BiomeDictionarySpawnHelper {
    static BiomeGenBase[] biomes;
    public static boolean spawn;
    static float averageWeight;

    public static void addToAllBiomes(Class entityClass, float weightedProb, int min, int max, EnumCreatureType typeOfCreature, boolean isMultiplier) {
        spawn = !(weightedProb <= 0.0f);
        if (spawn) {
            BiomeDictionary.Type[] typeList = BiomeDictionary.Type.values();
            for (int i = 0; i < typeList.length; ++i) {
                biomes = BiomeDictionary.getBiomesForType((BiomeDictionary.Type)typeList[i]);
                for (int j = 0; j < biomes.length; ++j) {
                    int weight;
                    if (isMultiplier) {
                        averageWeight = SpawnListWeightHelper.checkAverageWeight(typeOfCreature, biomes[j]);
                        weight = (int)(weightedProb * averageWeight);
                    } else {
                        weight = (int)weightedProb;
                    }
                    if (weight == 0) continue;
                    BiomeDictionarySpawnHelper.addEntitySpawning(entityClass, weight, min, max, typeOfCreature, biomes[j]);
                }
            }
        }
    }

    public static void addToAllSurfaceBiomes(Class entityClass, float weightedProb, int min, int max, EnumCreatureType typeOfCreature, boolean isMultiplier) {
        spawn = !(weightedProb <= 0.0f);
        if (spawn) {
            BiomeDictionary.Type[] typeList = BiomeDictionary.Type.values();
            for (int i = 0; i < typeList.length; ++i) {
                biomes = BiomeDictionary.getBiomesForType((BiomeDictionary.Type)typeList[i]);
                if (typeList[i] == BiomeDictionary.Type.NETHER || typeList[i] == BiomeDictionary.Type.END) continue;
                for (int j = 0; j < biomes.length; ++j) {
                    int weight;
                    if (isMultiplier) {
                        averageWeight = SpawnListWeightHelper.checkAverageWeight(typeOfCreature, biomes[j]);
                        weight = (int)(weightedProb * averageWeight);
                    } else {
                        weight = (int)weightedProb;
                    }
                    if (weight == 0) continue;
                    BiomeDictionarySpawnHelper.addEntitySpawning(entityClass, weight, min, max, typeOfCreature, biomes[j]);
                }
            }
            BiomeGenBase[] netherBiomes = BiomeDictionary.getBiomesForType((BiomeDictionary.Type)BiomeDictionary.Type.NETHER);
            for (int k = 0; k < netherBiomes.length; ++k) {
                EntityRegistry.removeSpawn((Class)entityClass, (EnumCreatureType)typeOfCreature, (BiomeGenBase[])new BiomeGenBase[]{netherBiomes[k]});
            }
            BiomeGenBase[] endBiomes = BiomeDictionary.getBiomesForType((BiomeDictionary.Type)BiomeDictionary.Type.END);
            for (int l = 0; l < endBiomes.length; ++l) {
                EntityRegistry.removeSpawn((Class)entityClass, (EnumCreatureType)typeOfCreature, (BiomeGenBase[])new BiomeGenBase[]{endBiomes[l]});
            }
        }
    }

    public static void addToAllBiomesWithType(Class entityClass, float weightedProb, int min, int max, EnumCreatureType typeOfCreature, BiomeDictionary.Type type, boolean isMultiplier) {
        spawn = !(weightedProb <= 0.0f);
        if (spawn) {
            biomes = BiomeDictionary.getBiomesForType((BiomeDictionary.Type)type);
            for (int j = 0; j < biomes.length; ++j) {
                int weight;
                if (isMultiplier) {
                    averageWeight = SpawnListWeightHelper.checkAverageWeight(typeOfCreature, biomes[j]);
                    weight = (int)(weightedProb * averageWeight);
                } else {
                    weight = (int)weightedProb;
                }
                if (weight == 0) continue;
                BiomeDictionarySpawnHelper.addEntitySpawning(entityClass, weight, min, max, typeOfCreature, biomes[j]);
            }
        }
    }

    public static void addToSingleTypeBiome(Class entityClass, float weightedProb, int min, int max, EnumCreatureType typeOfCreature, BiomeDictionary.Type type, boolean isMultiplier) {
        spawn = !(weightedProb <= 0.0f);
        if (spawn) {
            biomes = BiomeDictionary.getBiomesForType((BiomeDictionary.Type)type);
            for (int i = 0; i < biomes.length; ++i) {
                BiomeDictionary.Type[] types = BiomeDictionary.getTypesForBiome((BiomeGenBase)biomes[i]);
                for (int j = 0; j < types.length; ++j) {
                    int weight;
                    if (types[j] != type) continue;
                    if (isMultiplier) {
                        averageWeight = SpawnListWeightHelper.checkAverageWeight(typeOfCreature, biomes[i]);
                        weight = (int)(weightedProb * averageWeight);
                    } else {
                        weight = (int)weightedProb;
                    }
                    if (weight == 0) continue;
                    BiomeDictionarySpawnHelper.addEntitySpawning(entityClass, weight, min, max, typeOfCreature, biomes[i]);
                }
            }
        }
    }

    public static void addToDoubleTypeBiome(Class entityClass, float weightedProb, int min, int max, EnumCreatureType typeOfCreature, BiomeDictionary.Type type1, BiomeDictionary.Type type2, boolean isMultiplier) {
        spawn = !(weightedProb <= 0.0f);
        if (spawn) {
            biomes = BiomeDictionary.getBiomesForType((BiomeDictionary.Type)type1);
            for (int i = 0; i < biomes.length; ++i) {
                int weight;
                if (!BiomeDictionary.isBiomeOfType((BiomeGenBase)biomes[i], (BiomeDictionary.Type)type2)) continue;
                if (isMultiplier) {
                    averageWeight = SpawnListWeightHelper.checkAverageWeight(typeOfCreature, biomes[i]);
                    weight = (int)(weightedProb * averageWeight);
                } else {
                    weight = (int)weightedProb;
                }
                if (weight == 0) continue;
                BiomeDictionarySpawnHelper.addEntitySpawning(entityClass, weight, min, max, typeOfCreature, biomes[i]);
            }
        }
    }

    public static void addToTripleTypeBiome(Class entityClass, float weightedProb, int min, int max, EnumCreatureType typeOfCreature, BiomeDictionary.Type type1, BiomeDictionary.Type type2, BiomeDictionary.Type type3, boolean isMultiplier) {
        spawn = !(weightedProb <= 0.0f);
        if (spawn) {
            biomes = BiomeDictionary.getBiomesForType((BiomeDictionary.Type)type1);
            for (int i = 0; i < biomes.length; ++i) {
                int weight;
                if (!BiomeDictionary.isBiomeOfType((BiomeGenBase)biomes[i], (BiomeDictionary.Type)type2) || !BiomeDictionary.isBiomeOfType((BiomeGenBase)biomes[i], (BiomeDictionary.Type)type3)) continue;
                if (isMultiplier) {
                    averageWeight = SpawnListWeightHelper.checkAverageWeight(typeOfCreature, biomes[i]);
                    weight = (int)(weightedProb * averageWeight);
                } else {
                    weight = (int)weightedProb;
                }
                if (weight == 0) continue;
                BiomeDictionarySpawnHelper.addEntitySpawning(entityClass, weight, min, max, typeOfCreature, biomes[i]);
            }
        }
    }

    public static void addEntitySpawning(Class entityClass, int weightedProb, int min, int max, EnumCreatureType typeOfCreature, BiomeGenBase ... biomes) {
        int adjmin = BiomeDictionarySpawnHelper.settingsLimiter(min);
        int adjmax = BiomeDictionarySpawnHelper.settingsLimiter(max);
        EntityRegistry.addSpawn((Class)entityClass, (int)weightedProb, (int)adjmin, (int)adjmax, (EnumCreatureType)typeOfCreature, (BiomeGenBase[])biomes);
    }

    public static int settingsLimiter(int par1) {
        if (par1 > 8) {
            par1 = 8;
            return 8;
        }
        if (par1 < 0) {
            par1 = 0;
            return 0;
        }
        return par1;
    }

    static {
        averageWeight = 0.0f;
    }
}

