/*
 * Decompiled with CFR 0.152.
 */
package net.daveyx0.primitivemobs.entity.monster;

import java.util.List;
import java.util.UUID;
import net.daveyx0.primitivemobs.client.PrimitiveMobsAchievementPage;
import net.daveyx0.primitivemobs.core.PrimitiveMobsItems;
import net.daveyx0.primitivemobs.entity.monster.EntityMotherSpider;
import net.daveyx0.primitivemobs.entity.monster.EntityPrimitiveSpider;
import net.daveyx0.primitivemobs.entity.monster.EntityTreasureSlime;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.monster.EntitySlime;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.pathfinding.PathEntity;
import net.minecraft.server.management.PreYggdrasilConverter;
import net.minecraft.stats.StatBase;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;

public class EntityBabySpider
extends EntityPrimitiveSpider {
    public int followDelay;
    private PathEntity pathToMother;
    public boolean attackStance;
    public int healCooldown;

    public EntityBabySpider(World world) {
        super(world);
        this.func_70105_a(0.65f, 0.5f);
        this.followDelay = 0;
        this.setPlayerOwned(false);
        this.attackStance = false;
        this.setAge(0);
        this.setSitting(false);
        this.healCooldown = 0;
    }

    @Override
    public boolean func_70617_f_() {
        int j = MathHelper.func_76128_c((double)this.field_70165_t);
        int k = MathHelper.func_76128_c((double)this.field_70163_u);
        int l = MathHelper.func_76128_c((double)this.field_70161_v);
        Block m = this.field_70170_p.func_147439_a(j, k - 1, l);
        Block n = this.field_70170_p.func_147439_a(j, k + 1, l);
        Block o = this.field_70170_p.func_147439_a(j - 1, k, l);
        Block p = this.field_70170_p.func_147439_a(j + 1, k, l);
        return this.isBesideClimbableBlock() && m != Blocks.field_150422_aJ && n != Blocks.field_150422_aJ && o != Blocks.field_150422_aJ && p != Blocks.field_150422_aJ;
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(8.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)0.8f);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(1.0);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(17, (Object)0);
        this.field_70180_af.func_75682_a(18, (Object)0);
        this.field_70180_af.func_75682_a(19, (Object)0);
        this.field_70180_af.func_75682_a(20, (Object)0);
        this.field_70180_af.func_75682_a(21, (Object)"");
        this.field_70180_af.func_75682_a(22, (Object)0);
    }

    @Override
    public boolean func_70097_a(DamageSource par1DamageSource, float par2) {
        if (par1DamageSource.field_76373_n == "inWall" && this.getPlayerOwned()) {
            return false;
        }
        if (par1DamageSource.field_76373_n == "fall" && this.getPlayerOwned()) {
            return false;
        }
        if (par1DamageSource.field_76373_n == "drown" && this.getPlayerOwned()) {
            return false;
        }
        return super.func_70097_a(par1DamageSource, par2);
    }

    @Override
    protected Entity func_70782_k() {
        return null;
    }

    public int getAttackStrength(Entity par1Entity) {
        if (this.func_70654_ax() < 5) {
            return 1;
        }
        return 4;
    }

    public EntityMotherSpider findMother(double d) {
        List list = this.field_70170_p.func_72839_b((Entity)this, this.field_70121_D.func_72314_b(d, 4.0, d));
        for (int i = 0; i < list.size(); ++i) {
            EntityMotherSpider entitymother;
            Entity entity = (Entity)list.get(i);
            if (entity == null || !(entity instanceof EntityMotherSpider) || (entitymother = (EntityMotherSpider)entity).getMotherID() != this.getBabyID()) continue;
            return entitymother;
        }
        return null;
    }

    protected void func_70069_a(float f) {
    }

    @Override
    protected void func_70785_a(Entity p_70785_1_, float p_70785_2_) {
        if (this.getPlayerOwned()) {
            ((EntityPlayer)this.getOwner()).func_71064_a((StatBase)PrimitiveMobsAchievementPage.spiderAttack, 1);
        }
        super.func_70785_a(p_70785_1_, p_70785_2_);
    }

    public EntityLiving findAttacker(double d) {
        List list = this.field_70170_p.func_72839_b((Entity)this, this.field_70121_D.func_72314_b(d, 4.0, d));
        for (int i = 0; i < list.size(); ++i) {
            Entity entity = (Entity)list.get(i);
            if (entity == null || !(entity instanceof EntitySlime) && !(entity instanceof EntityMob) || entity instanceof EntityCreeper || entity instanceof EntityBabySpider) continue;
            if (entity instanceof EntityTreasureSlime) {
                EntityTreasureSlime entityslime = (EntityTreasureSlime)entity;
                if (entityslime.getItem() == 20) continue;
                return entityslime;
            }
            if (!(entity instanceof EntitySlime) && !(entity instanceof EntityMob)) continue;
            return (EntityLiving)entity;
        }
        return null;
    }

    public void attemptRideMother() {
        EntityMotherSpider entity = this.findMother(1.0);
        if (entity != null && entity.field_70153_n == null && entity.func_70777_m() == null && !this.field_70170_p.field_72995_K) {
            this.func_70078_a((Entity)entity);
        }
    }

    public void func_70664_aZ() {
        if (this.field_70153_n == null) {
            super.func_70664_aZ();
        }
    }

    @Override
    public final void func_70071_h_() {
        int l;
        int k;
        int j = MathHelper.func_76128_c((double)this.field_70165_t);
        Block m = this.field_70170_p.func_147439_a(j, k = MathHelper.func_76128_c((double)this.field_70163_u), l = MathHelper.func_76128_c((double)this.field_70161_v));
        if (m != null && m.func_149688_o() == Material.field_151586_h && !this.field_70123_F) {
            this.field_70181_x = 0.01;
        }
        this.attemptRideMother();
        float f = 0.01745278f;
        double d = this.field_70165_t - Math.sin(this.field_70177_z * f) / 3.0;
        double d1 = this.field_70163_u + this.field_70146_Z.nextDouble() / 3.0;
        double d2 = this.field_70161_v + Math.cos(this.field_70177_z * f) / 3.0;
        EntityMotherSpider entitymother = this.findMother(6.0);
        EntityMotherSpider entitymother1 = this.findMother(15.0);
        if (entitymother != null) {
            if (--this.followDelay <= 0) {
                this.followDelay = 10;
                this.pathToMother = this.field_70170_p.func_72865_a((Entity)this, (Entity)entitymother, 16.0f, true, false, false, true);
                this.func_70778_a(this.pathToMother);
            }
            if (this.func_70068_e((Entity)entitymother) < 2.0) {
                this.func_70778_a(null);
            }
            if (entitymother.func_70777_m() != null) {
                this.pathToMother = null;
                this.field_70789_a = entitymother.func_70777_m();
            }
        } else if (entitymother1 != null && entitymother == null) {
            this.func_70107_b(entitymother1.field_70165_t, entitymother1.field_70163_u, entitymother1.field_70161_v);
        }
        if (!this.getPlayerOwned() && this.field_70789_a == null && entitymother == null) {
            this.field_70170_p.func_72869_a("splash", d, d1 + 0.3, d2, 0.0, 0.0, 0.0);
        }
        if (this.field_70789_a != null || this.attackStance) {
            this.field_70170_p.func_72869_a("smoke", this.field_70165_t, this.field_70163_u + (double)this.field_70146_Z.nextFloat(), this.field_70161_v, 0.0, 0.0, 0.0);
        }
        if (this.getPlayerOwned() && !this.getSitting()) {
            EntityPlayer entityplayer = this.field_70170_p.func_72977_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, 12.0);
            EntityPlayer entityplayer1 = this.field_70170_p.func_72977_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, 25.0);
            if (this.func_70777_m() != this.getOwner() || this.getPlayerOwned()) {
                // empty if block
            }
            if (entityplayer != null && entityplayer.func_110124_au().toString().equals(this.getOwnerUUID())) {
                if (--this.followDelay <= 0) {
                    this.followDelay = 10;
                    this.pathToMother = this.field_70170_p.func_72865_a((Entity)this, (Entity)entityplayer, 16.0f, true, false, false, true);
                    this.func_70778_a(this.pathToMother);
                }
                if (this.func_70068_e((Entity)entityplayer) < 2.0) {
                    this.func_70778_a(null);
                }
                if (this.attackStance) {
                    this.field_70789_a = entityplayer != null && entityplayer.func_110144_aD() != null && this.func_70685_l((Entity)entityplayer.func_110144_aD()) ? entityplayer.func_110144_aD() : (entityplayer != null && entityplayer.func_70643_av() != null && this.func_70685_l((Entity)entityplayer.func_70643_av()) ? entityplayer.func_70643_av() : this.findAttacker(3.0));
                }
            } else if (entityplayer1 != null && entityplayer == null && !this.getSitting() && entityplayer1.func_110124_au().toString().equals(this.getOwnerUUID())) {
                this.func_70107_b(entityplayer1.field_70165_t, entityplayer1.field_70163_u, entityplayer1.field_70161_v);
            }
        }
        if (this.getPlayerOwned()) {
            if (this.field_70146_Z.nextInt(200) == 0) {
                this.field_70170_p.func_72869_a("heart", this.field_70165_t + (double)(this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()), this.field_70163_u + (double)this.field_70146_Z.nextFloat() + 1.0, this.field_70161_v + (double)(this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()), 1.0, 1.0, 1.0);
            }
            if (this.healCooldown > 0) {
                --this.healCooldown;
                this.field_70170_p.func_72869_a("instantSpell", this.field_70165_t, this.field_70163_u + (double)this.field_70146_Z.nextFloat(), this.field_70161_v, 0.0, 0.0, 0.0);
            }
        }
        if (this.getPlayerOwned() && this.getSitting()) {
            this.func_70661_as().func_75499_g();
        }
        if (!this.field_70170_p.field_72995_K && this.field_70170_p.field_73013_u == EnumDifficulty.PEACEFUL && !this.getPlayerOwned()) {
            this.func_70106_y();
        }
        if (this.func_70654_ax() <= 5) {
            this.func_70105_a(1.4f, 0.9f);
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(30.0);
            this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(3.0);
        }
        super.func_70071_h_();
    }

    public boolean func_70692_ba() {
        if (this.getPlayerOwned()) {
            return false;
        }
        return this.findMother(6.0) == null;
    }

    public boolean func_70085_c(EntityPlayer entityplayer) {
        ItemStack itemstack = entityplayer.field_71071_by.func_70448_g();
        if (itemstack == null && this.getPlayerOwned() && this.func_70654_ax() < 5 && !entityplayer.func_70093_af() && entityplayer.func_110124_au().toString().equals(this.getOwnerUUID())) {
            if (!this.attackStance) {
                this.attackStance = true;
            } else {
                this.attackStance = false;
                this.field_70789_a = null;
            }
            return true;
        }
        if (itemstack != null && this.getPlayerOwned() && itemstack.func_77973_b() == Items.field_151007_F && this.func_70654_ax() >= 5 && !entityplayer.func_70093_af() && entityplayer.func_110124_au().toString().equals(this.getOwnerUUID())) {
            if (!this.attackStance) {
                this.attackStance = true;
            } else {
                this.attackStance = false;
                this.field_70789_a = null;
            }
            return true;
        }
        if (super.func_70085_c(entityplayer)) {
            return true;
        }
        if (itemstack == null && this.getPlayerOwned() && this.func_70654_ax() >= 5 && !this.field_70170_p.field_72995_K && !entityplayer.func_70093_af() && entityplayer.func_110124_au().toString().equals(this.getOwnerUUID())) {
            entityplayer.field_70177_z = this.field_70177_z;
            entityplayer.field_70125_A = this.field_70125_A;
            entityplayer.field_70163_u = this.field_70163_u;
            entityplayer.func_70078_a((Entity)this);
            this.setSitting(false);
            return true;
        }
        if (itemstack != null && itemstack.func_77973_b() == PrimitiveMobsItems.spiderEggShell && this.func_70654_ax() < 5 && !entityplayer.func_70093_af()) {
            if (--itemstack.field_77994_a == 0) {
                entityplayer.field_71071_by.func_70299_a(entityplayer.field_71071_by.field_70461_c, null);
            }
            for (int i = 0; i < 8; ++i) {
                this.field_70170_p.func_72869_a("splash", this.field_70165_t + (double)(this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()), this.field_70163_u + (double)this.field_70146_Z.nextFloat() + 1.0, this.field_70161_v + (double)(this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()), 0.0, 0.0, 0.0);
            }
            if (!this.field_70170_p.field_72995_K) {
                this.func_145779_a(new ItemStack(PrimitiveMobsItems.customEgg, 1, 1).func_77973_b(), 1);
            }
            if (!this.getPlayerOwned()) {
                entityplayer.func_71064_a((StatBase)PrimitiveMobsAchievementPage.spiderStealer, 1);
            }
            this.func_70097_a(DamageSource.func_76365_a((EntityPlayer)entityplayer), 1.0f);
            this.func_70106_y();
            return true;
        }
        if (itemstack != null && itemstack.func_77973_b() == Items.field_151071_bq && this.func_70654_ax() < 5 && !entityplayer.func_70093_af() && entityplayer.func_110124_au().toString().equals(this.getOwnerUUID())) {
            if (--itemstack.field_77994_a == 0) {
                entityplayer.field_71071_by.func_70299_a(entityplayer.field_71071_by.field_70461_c, null);
            }
            for (int i = 0; i < 8; ++i) {
                this.field_70170_p.func_72869_a("smoke", this.field_70165_t + (double)(this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()), this.field_70163_u + (double)(this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()), 0.0, 0.0, 0.0);
            }
            this.setAge(this.func_70654_ax() + 1);
            if (this.func_70654_ax() >= 5) {
                entityplayer.func_71064_a((StatBase)PrimitiveMobsAchievementPage.spiderGrown, 1);
                this.func_70606_j(30.0f);
            }
            return true;
        }
        if (itemstack != null && itemstack.func_77973_b() == Items.field_151078_bh && !entityplayer.func_70093_af() && this.getPlayerOwned() && this.healCooldown == 0) {
            if (--itemstack.field_77994_a == 0) {
                entityplayer.field_71071_by.func_70299_a(entityplayer.field_71071_by.field_70461_c, null);
            }
            for (int i = 0; i < 8; ++i) {
                this.field_70170_p.func_72869_a("heart", this.field_70165_t + (double)(this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()), this.field_70163_u + (double)(this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()), 0.0, 0.0, 0.0);
            }
            this.healCooldown = 300;
            this.func_70606_j(30.0f);
            return true;
        }
        if (itemstack == null && this.getPlayerOwned() && entityplayer.func_70093_af() && entityplayer.func_110124_au().toString().equals(this.getOwnerUUID())) {
            for (int i = 0; i < 8; ++i) {
                this.field_70170_p.func_72869_a("note", this.field_70165_t + (double)(this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()), this.field_70163_u + (double)(this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()), 0.0, 0.0, 0.0);
            }
            if (!this.getSitting()) {
                this.setSitting(true);
            } else {
                this.setSitting(false);
            }
        }
        return true;
    }

    public void func_70612_e(float p_70612_1_, float p_70612_2_) {
        if (this.field_70153_n != null && this.field_70153_n instanceof EntityLivingBase) {
            this.field_70126_B = this.field_70177_z = this.field_70153_n.field_70177_z;
            this.field_70125_A = this.field_70153_n.field_70125_A * 0.5f;
            this.func_70101_b(this.field_70177_z, this.field_70125_A);
            this.field_70759_as = this.field_70761_aq = this.field_70177_z;
            p_70612_1_ = ((EntityLivingBase)this.field_70153_n).field_70702_br * 0.5f;
            p_70612_2_ = ((EntityLivingBase)this.field_70153_n).field_70701_bs;
            if (p_70612_2_ <= 0.0f) {
                p_70612_2_ *= 0.25f;
            }
            if (!this.field_70170_p.field_72995_K) {
                this.setBesideClimbableBlock(this.field_70123_F);
            }
            this.field_70138_W = 1.0f;
            this.field_70747_aH = this.func_70689_ay() * 0.1f;
            if (!this.field_70170_p.field_72995_K) {
                this.func_70659_e((float)this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e());
                super.func_70612_e(p_70612_1_, p_70612_2_);
            }
            this.field_70722_aY = this.field_70721_aZ;
            double d1 = this.field_70165_t - this.field_70169_q;
            double d0 = this.field_70161_v - this.field_70166_s;
            float f4 = MathHelper.func_76133_a((double)(d1 * d1 + d0 * d0)) * 4.0f;
            if (f4 > 1.0f) {
                f4 = 1.0f;
            }
            this.field_70721_aZ += (f4 - this.field_70721_aZ) * 0.4f;
            this.field_70754_ba += this.field_70721_aZ;
            if (this.getIsJumping()) {
                this.func_70664_aZ();
            }
            if (this.field_70122_E) {
                this.setIsJumping(false);
            }
        } else {
            this.field_70138_W = 0.5f;
            this.field_70747_aH = 0.02f;
            super.func_70612_e(p_70612_1_, p_70612_2_);
        }
        super.func_70612_e(p_70612_1_, p_70612_2_);
    }

    public boolean func_70780_i() {
        return this.field_70153_n instanceof EntityPlayer || this.getSitting();
    }

    public double func_70042_X() {
        return (double)this.field_70131_O - 0.2;
    }

    public boolean getSitting() {
        return (this.field_70180_af.func_75683_a(20) & 1) != 0;
    }

    public void setSitting(boolean par1) {
        if (par1) {
            this.field_70180_af.func_75692_b(20, (Object)1);
        } else {
            this.field_70180_af.func_75692_b(20, (Object)0);
        }
    }

    public int getBabyID() {
        return this.field_70180_af.func_75683_a(17);
    }

    public void setBabyID(int par1) {
        this.field_70180_af.func_75692_b(17, (Object)((byte)par1));
    }

    public boolean getPlayerOwned() {
        return (this.field_70180_af.func_75683_a(18) & 1) != 0;
    }

    public void setPlayerOwned(boolean par1) {
        if (par1) {
            this.field_70180_af.func_75692_b(18, (Object)1);
        } else {
            this.field_70180_af.func_75692_b(18, (Object)0);
        }
    }

    public int func_70654_ax() {
        return this.field_70180_af.func_75683_a(19);
    }

    public void setAge(int par1) {
        this.field_70180_af.func_75692_b(19, (Object)((byte)par1));
    }

    public String getOwnerUUID() {
        return this.field_70180_af.func_75681_e(21);
    }

    public void setOwnerUUID(String p_152115_1_) {
        this.field_70180_af.func_75692_b(21, (Object)p_152115_1_);
    }

    public EntityLivingBase getOwner() {
        try {
            UUID uuid = UUID.fromString(this.getOwnerUUID());
            return uuid == null ? null : this.field_70170_p.func_152378_a(uuid);
        }
        catch (IllegalArgumentException illegalargumentexception) {
            return null;
        }
    }

    public boolean getIsJumping() {
        return (this.field_70180_af.func_75683_a(22) & 1) != 0;
    }

    public void setIsJumping(boolean par1) {
        if (par1) {
            this.field_70180_af.func_75692_b(22, (Object)1);
        } else {
            this.field_70180_af.func_75692_b(22, (Object)0);
        }
    }

    public void func_70014_b(NBTTagCompound nbttagcompound) {
        super.func_70014_b(nbttagcompound);
        nbttagcompound.func_74757_a("Tamed", this.getPlayerOwned());
        nbttagcompound.func_74768_a("Mother", this.getBabyID());
        nbttagcompound.func_74768_a("Age", this.func_70654_ax());
        nbttagcompound.func_74757_a("Sitting", this.getSitting());
        if (this.getOwnerUUID() == null) {
            nbttagcompound.func_74778_a("OwnerUUID", "");
        } else {
            nbttagcompound.func_74778_a("OwnerUUID", this.getOwnerUUID());
        }
        nbttagcompound.func_74757_a("Jumping", this.getIsJumping());
    }

    public void func_70037_a(NBTTagCompound nbttagcompound) {
        super.func_70037_a(nbttagcompound);
        this.setPlayerOwned(nbttagcompound.func_74767_n("Tamed"));
        this.setBabyID(nbttagcompound.func_74762_e("Mother"));
        this.setAge(nbttagcompound.func_74762_e("Age"));
        this.setSitting(nbttagcompound.func_74767_n("Sitting"));
        this.setIsJumping(nbttagcompound.func_74767_n("Jumping"));
        String var2 = nbttagcompound.func_74779_i("Owner");
        String s = "";
        if (nbttagcompound.func_150297_b("OwnerUUID", 8)) {
            s = nbttagcompound.func_74779_i("OwnerUUID");
        } else {
            String s1 = nbttagcompound.func_74779_i("Owner");
            s = PreYggdrasilConverter.func_152719_a((String)s1);
        }
        if (s.length() > 0) {
            this.setOwnerUUID(s);
            this.setPlayerOwned(true);
        }
    }
}

