/*
 * Decompiled with CFR 0.152.
 */
package net.daveyx0.primitivemobs.entity.monster;

import java.util.List;
import java.util.UUID;
import net.daveyx0.primitivemobs.entity.monster.EntityPrimitiveCreeper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.server.management.PreYggdrasilConverter;
import net.minecraft.util.DamageSource;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;

public class EntitySupportCreeper
extends EntityPrimitiveCreeper {
    EntityMob supportMob;
    int followDelay;

    public EntitySupportCreeper(World world) {
        super(world);
        this.setPlayerOwned(false);
        this.supportMob = null;
        this.followDelay = 0;
        this.field_70178_ae = true;
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(22, (Object)new Integer(0));
        this.field_70180_af.func_75682_a(19, (Object)0);
        this.field_70180_af.func_75682_a(20, (Object)0);
        this.field_70180_af.func_75682_a(21, (Object)"");
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(20.0);
    }

    @Override
    public void func_70636_d() {
        int var1;
        EntityMob mob;
        super.func_70636_d();
        if (this.supportMob == null && !this.getPlayerOwned()) {
            this.supportMob = this.findMob();
        } else if (this.supportMob != null) {
            this.setCreeperState(0);
            this.timeSinceIgnited = 0;
            if (--this.followDelay <= 0) {
                this.followDelay = 10;
                this.func_70661_as().func_75497_a((Entity)this.supportMob, 0.5);
            }
            if (this.func_70068_e((Entity)this.supportMob) < 2.0) {
                this.func_70661_as().func_75499_g();
            }
            if (!(this.supportMob instanceof EntityCreeper)) {
                this.supportMob.func_70690_d(new PotionEffect(Potion.field_76420_g.field_76415_H, 60, 1));
                this.supportMob.func_70690_d(new PotionEffect(Potion.field_76424_c.field_76415_H, 60, 1));
                this.supportMob.func_70690_d(new PotionEffect(Potion.field_76426_n.field_76415_H, 60, 1));
                this.func_70690_d(new PotionEffect(Potion.field_76424_c.field_76415_H, 60, 1));
            } else if (this.supportMob instanceof EntityCreeper) {
                EntityCreeper entitycreeper = (EntityCreeper)this.supportMob;
                if (!entitycreeper.func_70830_n() && this.field_70170_p.func_72890_a((Entity)this, 10.0) != null && !this.field_70170_p.field_72995_K) {
                    EntityLightningBolt var6 = new EntityLightningBolt(this.field_70170_p, entitycreeper.field_70165_t, entitycreeper.field_70163_u, entitycreeper.field_70161_v);
                    this.field_70170_p.func_72838_d((Entity)var6);
                }
                this.supportMob.func_70690_d(new PotionEffect(Potion.field_76426_n.field_76415_H, 60, 1));
            }
            if (this.supportMob.field_70128_L || this.supportMob.func_110143_aJ() < 0.0f) {
                this.supportMob = null;
            }
        }
        EntityPlayer entityplayer2 = this.field_70170_p.func_72977_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, 5.0);
        if (entityplayer2 != null && !this.getPlayerOwned()) {
            entityplayer2.func_70690_d(new PotionEffect(Potion.field_76421_d.field_76415_H, 60, 1));
        }
        if ((mob = this.findMob()) != null && this.getPlayerOwned()) {
            mob.func_70690_d(new PotionEffect(Potion.field_76421_d.field_76415_H, 60, 1));
        }
        if (this.getPlayerOwned() && !this.getSitting()) {
            EntityPlayer entityplayer = this.field_70170_p.func_72977_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, 12.0);
            EntityPlayer entityplayer1 = this.field_70170_p.func_72977_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, 25.0);
            if (entityplayer != null && entityplayer.func_110124_au().toString().equals(this.getOwnerUUID())) {
                if (--this.followDelay <= 0) {
                    this.followDelay = 10;
                    this.func_70661_as().func_75497_a((Entity)entityplayer, 0.5);
                }
                if (this.func_70068_e((Entity)entityplayer) < 2.0) {
                    this.func_70661_as().func_75499_g();
                }
                entityplayer.func_70690_d(new PotionEffect(Potion.field_76420_g.field_76415_H, 60, 1));
                entityplayer.func_70690_d(new PotionEffect(Potion.field_76424_c.field_76415_H, 60, 1));
                entityplayer.func_70690_d(new PotionEffect(Potion.field_76426_n.field_76415_H, 60, 1));
                this.func_70690_d(new PotionEffect(Potion.field_76424_c.field_76415_H, 60, 1));
            } else if (entityplayer1 != null && entityplayer == null && !this.getSitting() && entityplayer1.func_110124_au().toString().equals(this.getOwnerUUID())) {
                this.func_70107_b(entityplayer1.field_70165_t, entityplayer1.field_70163_u, entityplayer1.field_70161_v);
            }
        }
        if (this.getPlayerOwned()) {
            if (this.field_70146_Z.nextInt(200) == 0) {
                this.field_70170_p.func_72869_a("heart", this.field_70165_t + (double)(this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()), this.field_70163_u + (double)this.field_70146_Z.nextFloat() + 1.0, this.field_70161_v + (double)(this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()), 1.0, 1.0, 1.0);
            }
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(30.0);
            this.setCreeperState(0);
        }
        if (this.getPlayerOwned() && this.getSitting()) {
            this.func_70661_as().func_75499_g();
        }
        if (!this.field_70170_p.field_72995_K && this.field_70170_p.field_73013_u == EnumDifficulty.PEACEFUL && !this.getPlayerOwned()) {
            this.func_70106_y();
        }
        if ((var1 = this.getGrowingAge()) < 0) {
            this.setGrowingAge(++var1);
        } else if (var1 > 0) {
            this.setGrowingAge(--var1);
        }
    }

    @Override
    public void func_70645_a(DamageSource par1DamageSource) {
        super.func_70645_a(par1DamageSource);
    }

    @Override
    public boolean func_70097_a(DamageSource par1DamageSource, float par2) {
        if (par1DamageSource.field_76373_n == "inWall" && this.getPlayerOwned()) {
            return false;
        }
        if (par1DamageSource.field_76373_n == "fall" && this.getPlayerOwned()) {
            return false;
        }
        return super.func_70097_a(par1DamageSource, par2);
    }

    @Override
    public boolean func_70085_c(EntityPlayer entityplayer) {
        int i;
        ItemStack itemstack = entityplayer.field_71071_by.func_70448_g();
        if (itemstack != null && itemstack.func_77973_b() == Items.field_151127_ba && !entityplayer.func_70093_af()) {
            if (--itemstack.field_77994_a == 0) {
                entityplayer.field_71071_by.func_70299_a(entityplayer.field_71071_by.field_70461_c, null);
            }
            for (int i2 = 0; i2 < 8; ++i2) {
                this.field_70170_p.func_72869_a("heart", this.field_70165_t + (double)(this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()), this.field_70163_u + (double)(this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()), 0.0, 0.0, 0.0);
            }
            this.func_70606_j(this.func_110138_aP());
            return true;
        }
        if (itemstack == null && this.getPlayerOwned() && entityplayer.func_70093_af() && entityplayer.func_110124_au().toString().equals(this.getOwnerUUID())) {
            for (i = 0; i < 8; ++i) {
                this.field_70170_p.func_72869_a("note", this.field_70165_t + (double)(this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()), this.field_70163_u + (double)(this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()), 0.0, 0.0, 0.0);
            }
            if (!this.getSitting()) {
                this.setSitting(true);
            } else {
                this.setSitting(false);
            }
        }
        if (itemstack != null && itemstack.func_77973_b() == Items.field_151016_H && !entityplayer.func_70093_af() && entityplayer.func_110124_au().toString().equals(this.getOwnerUUID())) {
            if (--itemstack.field_77994_a == 0) {
                entityplayer.field_71071_by.func_70299_a(entityplayer.field_71071_by.field_70461_c, null);
            }
            for (i = 0; i < 8; ++i) {
                this.field_70170_p.func_72869_a("heart", this.field_70165_t + (double)(this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()), this.field_70163_u + (double)(this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()), 0.0, 0.0, 0.0);
            }
            this.func_70606_j(this.func_110138_aP());
            return true;
        }
        return true;
    }

    @Override
    protected Item func_146068_u() {
        return Items.field_151059_bz;
    }

    public EntityMob findMob() {
        List list = this.field_70170_p.func_72839_b((Entity)this, this.field_70121_D.func_72314_b(12.0, 3.0, 12.0));
        for (int i = 0; i < list.size(); ++i) {
            Entity entity = (Entity)list.get(i);
            if (entity == null || !(entity instanceof EntityMob) || entity instanceof EntitySupportCreeper) continue;
            EntityMob entitymob = (EntityMob)entity;
            return entitymob;
        }
        return null;
    }

    public int getGrowingAge() {
        return this.field_70180_af.func_75679_c(22);
    }

    public void setGrowingAge(int par1) {
        this.field_70180_af.func_75692_b(22, (Object)par1);
    }

    public boolean getSitting() {
        return (this.field_70180_af.func_75683_a(19) & 1) != 0;
    }

    public void setSitting(boolean par1) {
        if (par1) {
            this.field_70180_af.func_75692_b(19, (Object)1);
        } else {
            this.field_70180_af.func_75692_b(19, (Object)0);
        }
    }

    public boolean getPlayerOwned() {
        return (this.field_70180_af.func_75683_a(20) & 1) != 0;
    }

    public void setPlayerOwned(boolean par1) {
        if (par1) {
            this.field_70180_af.func_75692_b(20, (Object)1);
        } else {
            this.field_70180_af.func_75692_b(20, (Object)0);
        }
    }

    public String getOwnerUUID() {
        return this.field_70180_af.func_75681_e(21);
    }

    public void setOwnerUUID(String p_152115_1_) {
        this.field_70180_af.func_75692_b(21, (Object)p_152115_1_);
    }

    public EntityLivingBase getOwner() {
        try {
            UUID uuid = UUID.fromString(this.getOwnerUUID());
            return uuid == null ? null : this.field_70170_p.func_152378_a(uuid);
        }
        catch (IllegalArgumentException illegalargumentexception) {
            return null;
        }
    }

    public boolean func_152114_e(EntityLivingBase p_152114_1_) {
        return p_152114_1_ == this.getOwner();
    }

    public boolean func_70692_ba() {
        return !this.getPlayerOwned();
    }

    @Override
    public void func_70014_b(NBTTagCompound par1NBTTagCompound) {
        super.func_70014_b(par1NBTTagCompound);
        par1NBTTagCompound.func_74768_a("Age", this.getGrowingAge());
        par1NBTTagCompound.func_74757_a("Tamed", this.getPlayerOwned());
        par1NBTTagCompound.func_74757_a("Sitting", this.getSitting());
        if (this.getOwnerUUID() == null) {
            par1NBTTagCompound.func_74778_a("OwnerUUID", "");
        } else {
            par1NBTTagCompound.func_74778_a("OwnerUUID", this.getOwnerUUID());
        }
    }

    @Override
    public void func_70037_a(NBTTagCompound par1NBTTagCompound) {
        super.func_70037_a(par1NBTTagCompound);
        this.setGrowingAge(par1NBTTagCompound.func_74762_e("Age"));
        this.setPlayerOwned(par1NBTTagCompound.func_74767_n("Tamed"));
        this.setSitting(par1NBTTagCompound.func_74767_n("Sitting"));
        String s = "";
        if (par1NBTTagCompound.func_150297_b("OwnerUUID", 8)) {
            s = par1NBTTagCompound.func_74779_i("OwnerUUID");
        } else {
            String s1 = par1NBTTagCompound.func_74779_i("Owner");
            s = PreYggdrasilConverter.func_152719_a((String)s1);
        }
        if (s.length() > 0) {
            this.setOwnerUUID(s);
            this.setPlayerOwned(true);
        }
    }

    public boolean func_70631_g_() {
        return this.getGrowingAge() < 0;
    }
}

