/*
 * Decompiled with CFR 0.152.
 */
package net.daveyx0.primitivemobs.entity.passive;

import java.awt.Color;
import java.io.InputStream;
import java.util.Set;
import java.util.UUID;
import net.daveyx0.primitivemobs.client.PrimitiveMobsAchievementPage;
import net.daveyx0.primitivemobs.core.PrimitiveMobsItems;
import net.daveyx0.primitivemobs.lib.ImageTester;
import net.daveyx0.primitivemobs.lib.ResourceChecker;
import net.minecraft.block.Block;
import net.minecraft.block.BlockGrass;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockLilyPad;
import net.minecraft.block.BlockTallGrass;
import net.minecraft.block.BlockVine;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.SimpleReloadableResourceManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIFollowParent;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIPanic;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.pathfinding.PathEntity;
import net.minecraft.server.management.PreYggdrasilConverter;
import net.minecraft.stats.StatBase;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.ColorizerFoliage;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.BlockFluidBase;

public class EntityChameleon
extends EntityAnimal {
    private float R;
    private float G;
    private float B;
    private float NewR;
    private float NewG;
    private float NewB;
    private boolean hasChanged;
    private Block currentBlock;
    private int currentMeta;
    private int currentFoliage;
    public double tongueX;
    public double tongueY;
    public double tongueZ;
    private boolean stretched;
    public int followDelay;
    private PathEntity pathToOwner;

    public EntityChameleon(World par1World) {
        super(par1World);
        this.func_70105_a(0.7f, 0.5f);
        this.func_70661_as().func_75491_a(true);
        this.func_70661_as().func_75495_e(true);
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIPanic((EntityCreature)this, 2.0));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 6.0f));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIFollowParent((EntityAnimal)this, 1.25));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.currentBlock = Blocks.field_150357_h;
        this.stretched = false;
        this.followDelay = 0;
        this.setSitting(false);
        this.setPlayerOwned(false);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(19, (Object)0);
        this.field_70180_af.func_75682_a(20, (Object)0);
        this.field_70180_af.func_75682_a(21, (Object)"");
    }

    public boolean func_70097_a(DamageSource par1DamageSource, float par2) {
        if (par1DamageSource.field_76373_n == "inWall" && this.getPlayerOwned()) {
            return false;
        }
        if (par1DamageSource.field_76373_n == "fall" && this.getPlayerOwned()) {
            return false;
        }
        if (par1DamageSource.field_76373_n == "drown" && this.getPlayerOwned()) {
            return false;
        }
        return super.func_70097_a(par1DamageSource, par2);
    }

    public void func_70071_h_() {
        if (this.func_70090_H() && !this.field_70123_F) {
            this.field_70181_x = 0.02;
        }
        if (this.field_70170_p.field_72995_K) {
            this.changeColor();
        }
        if (this.R != this.NewR || this.G != this.NewG || this.B != this.NewB) {
            this.hasChanged = false;
            if (this.R > this.NewR) {
                this.R -= 1.0f;
            } else if (this.R < this.NewR) {
                this.R += 1.0f;
            }
            if (this.G > this.NewG) {
                this.G -= 1.0f;
            } else if (this.G < this.NewG) {
                this.G += 1.0f;
            }
            if (this.B > this.NewB) {
                this.B -= 1.0f;
            } else if (this.B < this.NewB) {
                this.B += 1.0f;
            }
        } else {
            this.hasChanged = true;
        }
        if (this.getPlayerOwned() && !this.getSitting()) {
            EntityPlayer entityplayer = this.field_70170_p.func_72977_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, 12.0);
            EntityPlayer entityplayer1 = this.field_70170_p.func_72977_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, 25.0);
            if (entityplayer != null && entityplayer.func_110124_au().toString().equals(this.getOwnerUUID())) {
                if (--this.followDelay <= 0) {
                    this.followDelay = 10;
                    this.func_70661_as().func_75497_a((Entity)entityplayer, 1.0);
                }
                if (this.func_70068_e((Entity)entityplayer) < 2.0) {
                    this.func_70778_a(null);
                }
            } else if (entityplayer1 != null && entityplayer == null && !this.getSitting() && entityplayer1.func_110124_au().toString().equals(this.getOwnerUUID())) {
                this.func_70107_b(entityplayer1.field_70165_t, entityplayer1.field_70163_u, entityplayer1.field_70161_v);
            }
        }
        if (this.getPlayerOwned()) {
            if (this.field_70146_Z.nextInt(200) == 0) {
                this.field_70170_p.func_72869_a("heart", this.field_70165_t + (double)(this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()), this.field_70163_u + (double)this.field_70146_Z.nextFloat() + 1.0, this.field_70161_v + (double)(this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()), 1.0, 1.0, 1.0);
            }
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(30.0);
        }
        if (this.getPlayerOwned() && this.getSitting()) {
            this.func_70661_as().func_75499_g();
        }
        super.func_70071_h_();
    }

    public void changeColor() {
        BlockGrass test;
        int k;
        int j;
        int i = MathHelper.func_76128_c((double)this.field_70165_t);
        if (this.field_70170_p.func_147439_a(i, j = MathHelper.func_76128_c((double)this.field_70121_D.field_72338_b), k = MathHelper.func_76128_c((double)this.field_70161_v)) == Blocks.field_150350_a) {
            j = MathHelper.func_76128_c((double)(this.field_70121_D.field_72338_b - 0.1));
        }
        Block m = this.field_70170_p.func_147439_a(i, j, k);
        int meta = this.field_70170_p.func_72805_g(i, j, k);
        int foliage = 0;
        if (m instanceof BlockGrass) {
            test = (BlockGrass)m;
            foliage = test.func_149720_d((IBlockAccess)this.field_70170_p, i, j, k);
        } else if (m instanceof BlockLeaves) {
            test = (BlockLeaves)m;
            foliage = test.func_149720_d((IBlockAccess)this.field_70170_p, i, j, k);
        } else if (m instanceof BlockLilyPad) {
            test = (BlockLilyPad)m;
            foliage = test.func_149720_d((IBlockAccess)this.field_70170_p, i, j, k);
        }
        if (m instanceof BlockVine) {
            m = this.currentBlock;
        }
        if (m != Blocks.field_150350_a && this.hasChanged && (m != this.currentBlock || meta != this.currentMeta || foliage != this.currentFoliage)) {
            this.currentBlock = m;
            this.currentMeta = meta;
            this.currentFoliage = foliage;
            IIcon icon = m.func_149691_a(1, meta);
            if (!(icon == null || m instanceof BlockGrass || m instanceof BlockLeaves || m instanceof BlockFluidBase || m instanceof BlockTallGrass)) {
                this.changeColorFromTexture(icon);
            } else if (m instanceof BlockGrass) {
                BlockGrass grass = (BlockGrass)m;
                int color = grass.func_149720_d((IBlockAccess)this.field_70170_p, i, j, k);
                icon = m.func_149691_a(0, meta);
                Color colour = new Color(color, true);
                if (colour.getRed() == colour.getGreen() && colour.getRed() == colour.getBlue() && colour.getGreen() == colour.getBlue()) {
                    this.changeColorFromTexture(icon);
                } else {
                    this.setNewR(colour.getRed());
                    this.setNewG(colour.getGreen());
                    this.setNewB(colour.getBlue());
                }
            } else if (m instanceof BlockTallGrass) {
                BlockTallGrass grass = (BlockTallGrass)m;
                int color = grass.func_149720_d((IBlockAccess)this.field_70170_p, i, j, k);
                icon = m.func_149691_a(0, meta);
                Color colour = new Color(color, true);
                if (colour.getRed() == colour.getGreen() && colour.getRed() == colour.getBlue() && colour.getGreen() == colour.getBlue()) {
                    this.changeColorFromTexture(icon);
                } else {
                    this.setNewR(colour.getRed());
                    this.setNewG(colour.getGreen());
                    this.setNewB(colour.getBlue());
                }
            } else if (m instanceof BlockLeaves) {
                BlockLeaves grass = (BlockLeaves)m;
                int color = grass.func_149720_d((IBlockAccess)this.field_70170_p, i, j, k);
                if (meta == 1 || meta == 5) {
                    color = ColorizerFoliage.func_77466_a();
                }
                if (meta == 2 || meta == 6) {
                    color = ColorizerFoliage.func_77469_b();
                }
                icon = m.func_149691_a(0, meta);
                Color colour = new Color(color, true);
                if (colour.getRed() == colour.getGreen() && colour.getRed() == colour.getBlue() && colour.getGreen() == colour.getBlue()) {
                    this.changeColorFromTexture(icon);
                } else {
                    this.setNewR(colour.getRed());
                    this.setNewG(colour.getGreen());
                    this.setNewB(colour.getBlue());
                }
            } else if (m instanceof BlockLilyPad) {
                BlockLilyPad grass = (BlockLilyPad)m;
                int color = grass.func_149720_d((IBlockAccess)this.field_70170_p, i, j, k);
                icon = m.func_149691_a(0, meta);
                Color colour = new Color(color, true);
                if (colour.getRed() == colour.getGreen() && colour.getRed() == colour.getBlue() && colour.getGreen() == colour.getBlue()) {
                    this.changeColorFromTexture(icon);
                } else {
                    this.setNewR(colour.getRed());
                    this.setNewG(colour.getGreen());
                    this.setNewB(colour.getBlue());
                }
            } else if (m instanceof BlockFluidBase) {
                BlockFluidBase water = (BlockFluidBase)m;
                int color = water.func_149720_d((IBlockAccess)this.field_70170_p, i, j, k);
                icon = m.func_149691_a(0, meta);
                Color colour = new Color(color, true);
                if (colour.getRed() == colour.getGreen() && colour.getRed() == colour.getBlue() && colour.getGreen() == colour.getBlue()) {
                    this.changeColorFromTexture(icon);
                } else {
                    this.setNewR(colour.getRed());
                    this.setNewG(colour.getGreen());
                    this.setNewB(colour.getBlue());
                }
            }
        }
    }

    public void changeColorFromTexture(IIcon icon) {
        SimpleReloadableResourceManager resourceManager = (SimpleReloadableResourceManager)Minecraft.func_71410_x().func_110442_L();
        Set set = resourceManager.func_135055_a();
        Object[] domains = set.toArray();
        IResource resource = null;
        for (int i = 0; i < domains.length; ++i) {
            resource = ResourceChecker.getResource(domains[i].toString(), "textures/blocks/" + icon.func_94215_i() + ".png");
            if (resource == null) {
                String[] divided = icon.func_94215_i().split(":");
                resource = ResourceChecker.getResource(domains[i].toString(), "textures/blocks/" + divided[1] + ".png");
            }
            if (resource != null) break;
        }
        if (resource != null) {
            InputStream stream = resource.func_110527_b();
            int[] rgb = null;
            try {
                rgb = ImageTester.main(stream);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (rgb != null) {
                this.setNewR(rgb[0]);
                this.setNewG(rgb[1]);
                this.setNewB(rgb[2]);
            }
        }
    }

    public boolean func_70650_aV() {
        return true;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(10.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)0.2f);
    }

    protected float func_70599_aP() {
        return 0.4f;
    }

    protected Item func_146068_u() {
        return PrimitiveMobsItems.camouflageDye;
    }

    public boolean func_70085_c(EntityPlayer entityplayer) {
        ItemStack itemstack = entityplayer.field_71071_by.func_70448_g();
        if (super.func_70085_c(entityplayer)) {
            return true;
        }
        if (!this.getPlayerOwned() && itemstack != null && itemstack.func_77973_b() == Items.field_151127_ba && !entityplayer.func_70093_af()) {
            if (--itemstack.field_77994_a == 0) {
                entityplayer.field_71071_by.func_70299_a(entityplayer.field_71071_by.field_70461_c, null);
            }
            this.setPlayerOwned(true);
            this.setOwnerUUID(entityplayer.func_110124_au().toString());
            for (int i = 0; i < 8; ++i) {
                this.field_70170_p.func_72869_a("heart", this.field_70165_t + (double)(this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()), this.field_70163_u + (double)(this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()), 0.0, 0.0, 0.0);
            }
            entityplayer.func_71064_a((StatBase)PrimitiveMobsAchievementPage.chameleonFriend, 1);
            return true;
        }
        if (itemstack != null && itemstack.func_77973_b() == Items.field_151070_bp && !entityplayer.func_70093_af() && this.getPlayerOwned()) {
            if (--itemstack.field_77994_a == 0) {
                entityplayer.field_71071_by.func_70299_a(entityplayer.field_71071_by.field_70461_c, null);
            }
            for (int i = 0; i < 8; ++i) {
                this.field_70170_p.func_72869_a("heart", this.field_70165_t + (double)(this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()), this.field_70163_u + (double)(this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()), 0.0, 0.0, 0.0);
            }
            this.func_70606_j(30.0f);
            return true;
        }
        if (itemstack == null && this.getPlayerOwned() && entityplayer.func_70093_af() && entityplayer.func_110124_au().toString().equals(this.getOwnerUUID())) {
            for (int i = 0; i < 8; ++i) {
                this.field_70170_p.func_72869_a("note", this.field_70165_t + (double)(this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()), this.field_70163_u + (double)(this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()), 0.0, 0.0, 0.0);
            }
            if (!this.getSitting()) {
                this.setSitting(true);
            } else {
                this.setSitting(false);
            }
        }
        return true;
    }

    protected void func_70628_a(boolean par1, int par2) {
        int j = this.field_70146_Z.nextInt(3) + this.field_70146_Z.nextInt(1 + par2);
        for (int k = 0; k < j; ++k) {
            this.func_145779_a(PrimitiveMobsItems.camouflageDye, 1);
        }
    }

    public EntityChameleon spawnBabyAnimal(EntityAgeable par1EntityAgeable) {
        return new EntityChameleon(this.field_70170_p);
    }

    public EntityAgeable func_90011_a(EntityAgeable par1EntityAgeable) {
        return this.spawnBabyAnimal(par1EntityAgeable);
    }

    public float getR() {
        return this.R;
    }

    public float getG() {
        return this.G;
    }

    public float getB() {
        return this.B;
    }

    public void setR(float set) {
        this.R = set;
    }

    public void setG(float set) {
        this.G = set;
    }

    public void setB(float set) {
        this.B = set;
    }

    public float getNewR() {
        return this.NewR;
    }

    public float getNewG() {
        return this.NewG;
    }

    public float getNewB() {
        return this.NewB;
    }

    public void setNewR(float set) {
        this.NewR = set;
    }

    public void setNewG(float set) {
        this.NewG = set;
    }

    public void setNewB(float set) {
        this.NewB = set;
    }

    public boolean getSitting() {
        return (this.field_70180_af.func_75683_a(20) & 1) != 0;
    }

    public void setSitting(boolean par1) {
        if (par1) {
            this.field_70180_af.func_75692_b(20, (Object)1);
        } else {
            this.field_70180_af.func_75692_b(20, (Object)0);
        }
    }

    public boolean getPlayerOwned() {
        return (this.field_70180_af.func_75683_a(19) & 1) != 0;
    }

    public void setPlayerOwned(boolean par1) {
        if (par1) {
            this.field_70180_af.func_75692_b(19, (Object)1);
        } else {
            this.field_70180_af.func_75692_b(19, (Object)0);
        }
    }

    public String getOwnerUUID() {
        return this.field_70180_af.func_75681_e(21);
    }

    public void setOwnerUUID(String p_152115_1_) {
        this.field_70180_af.func_75692_b(21, (Object)p_152115_1_);
    }

    public EntityLivingBase getOwner() {
        try {
            UUID uuid = UUID.fromString(this.getOwnerUUID());
            return uuid == null ? null : this.field_70170_p.func_152378_a(uuid);
        }
        catch (IllegalArgumentException illegalargumentexception) {
            return null;
        }
    }

    public void func_70014_b(NBTTagCompound nbttagcompound) {
        super.func_70014_b(nbttagcompound);
        nbttagcompound.func_74757_a("Tamed", this.getPlayerOwned());
        nbttagcompound.func_74757_a("Sitting", this.getSitting());
        if (this.getOwnerUUID() == null) {
            nbttagcompound.func_74778_a("OwnerUUID", "");
        } else {
            nbttagcompound.func_74778_a("OwnerUUID", this.getOwnerUUID());
        }
    }

    public void func_70037_a(NBTTagCompound nbttagcompound) {
        super.func_70037_a(nbttagcompound);
        this.setPlayerOwned(nbttagcompound.func_74767_n("Tamed"));
        this.setSitting(nbttagcompound.func_74767_n("Sitting"));
        String var2 = nbttagcompound.func_74779_i("Owner");
        String s = "";
        if (nbttagcompound.func_150297_b("OwnerUUID", 8)) {
            s = nbttagcompound.func_74779_i("OwnerUUID");
        } else {
            String s1 = nbttagcompound.func_74779_i("Owner");
            s = PreYggdrasilConverter.func_152719_a((String)s1);
        }
        if (s.length() > 0) {
            this.setOwnerUUID(s);
            this.setPlayerOwned(true);
        }
    }
}

