/*
 * Decompiled with CFR 0.152.
 */
package net.daveyx0.primitivemobs.item;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.awt.Color;
import java.io.InputStream;
import java.util.Set;
import net.daveyx0.primitivemobs.client.PrimitiveMobsAchievementPage;
import net.daveyx0.primitivemobs.common.PrimitiveMobs;
import net.daveyx0.primitivemobs.common.packets.PrimitiveColorPacket;
import net.daveyx0.primitivemobs.lib.ImageTester;
import net.daveyx0.primitivemobs.lib.ResourceChecker;
import net.minecraft.block.Block;
import net.minecraft.block.BlockGrass;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockLilyPad;
import net.minecraft.block.BlockTallGrass;
import net.minecraft.block.BlockVine;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.SimpleReloadableResourceManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatBase;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.ColorizerFoliage;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.BlockFluidBase;

public class ItemCamouflageArmor
extends ItemArmor {
    private float R;
    private float G;
    private float B;
    private float NewR;
    private float NewG;
    private float NewB;
    private boolean hasChanged;
    private Block currentBlock;
    private int currentMeta;
    private int currentFoliage;
    byte camo = 0;
    byte camoChanged;
    String[] names = new String[]{"CamouflageHelmet", "CamouflageChestplate", "CamouflageLeggings", "CamouflageBoots"};
    private Color thisArmorColor = new Color(255, 255, 255);

    public ItemCamouflageArmor(int p_i45325_3_) {
        super(ItemArmor.ArmorMaterial.CLOTH, 0, p_i45325_3_);
        this.func_77637_a(PrimitiveMobs.tabPrimitiveMobs);
        this.func_77655_b(this.names[p_i45325_3_]);
        this.currentBlock = Blocks.field_150357_h;
    }

    public String func_77667_c(ItemStack par1ItemStack) {
        String localName = super.func_77658_a().replace("item.", "");
        return "item.primitivemobs." + localName;
    }

    public boolean hasContainerItem(ItemStack stack) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister p_94581_1_) {
        this.field_111218_cA = "minecraft:leather_helmet";
        super.func_94581_a(p_94581_1_);
        switch (this.field_77881_a) {
            case 0: {
                this.field_77791_bV = p_94581_1_.func_94245_a("minecraft:leather_helmet");
                break;
            }
            case 1: {
                this.field_77791_bV = p_94581_1_.func_94245_a("minecraft:leather_chestplate");
                break;
            }
            case 2: {
                this.field_77791_bV = p_94581_1_.func_94245_a("minecraft:leather_leggings");
                break;
            }
            case 3: {
                this.field_77791_bV = p_94581_1_.func_94245_a("minecraft:leather_boots");
                break;
            }
            default: {
                this.field_77791_bV = p_94581_1_.func_94245_a("minecraft:leather_helmet");
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public int func_82790_a(ItemStack p_82790_1_, int p_82790_2_) {
        return this.func_82814_b(p_82790_1_);
    }

    public void onArmorTick(World world, EntityPlayer player, ItemStack armor) {
        this.camoChanged = this.getNoCamo(armor);
        if (player != null && this.camoChanged != this.camo) {
            this.camo = this.camoChanged;
            this.surroundWithParticles(player);
        }
        if (player != null && world.field_72995_K && this.getNoCamo(armor) == 0) {
            this.changeColor(world, player);
        }
        if (this.R != this.NewR || this.G != this.NewG || this.B != this.NewB) {
            this.hasChanged = false;
            if (this.R > this.NewR) {
                this.R -= 1.0f;
            } else if (this.R < this.NewR) {
                this.R += 1.0f;
            }
            if (this.G > this.NewG) {
                this.G -= 1.0f;
            } else if (this.G < this.NewG) {
                this.G += 1.0f;
            }
            if (this.B > this.NewB) {
                this.B -= 1.0f;
            } else if (this.B < this.NewB) {
                this.B += 1.0f;
            }
            if (this.field_77881_a == 0) {
                PrimitiveMobs.network.sendToServer((IMessage)new PrimitiveColorPacket("3" + new Color(this.R / 255.0f, this.G / 255.0f, this.B / 255.0f).hashCode()));
            } else if (this.field_77881_a == 1) {
                PrimitiveMobs.network.sendToServer((IMessage)new PrimitiveColorPacket("2" + new Color(this.R / 255.0f, this.G / 255.0f, this.B / 255.0f).hashCode()));
            } else if (this.field_77881_a == 2) {
                PrimitiveMobs.network.sendToServer((IMessage)new PrimitiveColorPacket("1" + new Color(this.R / 255.0f, this.G / 255.0f, this.B / 255.0f).hashCode()));
            } else if (this.field_77881_a == 3) {
                PrimitiveMobs.network.sendToServer((IMessage)new PrimitiveColorPacket("0" + new Color(this.R / 255.0f, this.G / 255.0f, this.B / 255.0f).hashCode()));
            }
        } else {
            this.hasChanged = true;
        }
        int currentColor = this.func_82814_b(armor);
        if (currentColor == -9345685 && this.hasChanged) {
            player.func_71064_a((StatBase)PrimitiveMobsAchievementPage.specialColor1, 1);
        } else if (currentColor == -13279398 && this.hasChanged) {
            player.func_71064_a((StatBase)PrimitiveMobsAchievementPage.specialColor2, 1);
        } else if (currentColor == -13380919 && this.hasChanged) {
            player.func_71064_a((StatBase)PrimitiveMobsAchievementPage.specialColor3, 1);
        }
    }

    public int func_82814_b(ItemStack p_82814_1_) {
        NBTTagCompound nbttagcompound = p_82814_1_.func_77978_p();
        if (nbttagcompound == null) {
            return 10511680;
        }
        NBTTagCompound nbttagcompound1 = nbttagcompound.func_74775_l("display");
        return nbttagcompound1 == null ? 10511680 : (nbttagcompound1.func_150297_b("color", 3) ? nbttagcompound1.func_74762_e("color") : 10511680);
    }

    public byte getNoCamo(ItemStack p_82814_1_) {
        NBTTagCompound nbttagcompound = p_82814_1_.func_77978_p();
        if (nbttagcompound == null) {
            return 0;
        }
        NBTTagCompound nbttagcompound1 = nbttagcompound.func_74775_l("display");
        return nbttagcompound1 == null ? (byte)0 : (nbttagcompound1.func_150297_b("camo", 1) ? nbttagcompound1.func_74771_c("camo") : (byte)0);
    }

    public void setNoCamo(ItemStack p_82814_1_, byte set) {
        NBTTagCompound nbttagcompound = p_82814_1_.func_77978_p();
        if (nbttagcompound == null) {
            nbttagcompound = new NBTTagCompound();
            p_82814_1_.func_77982_d(nbttagcompound);
        }
        NBTTagCompound nbttagcompound1 = nbttagcompound.func_74775_l("display");
        if (!nbttagcompound.func_150297_b("display", 10)) {
            nbttagcompound.func_74782_a("display", (NBTBase)nbttagcompound1);
        }
        nbttagcompound1.func_74774_a("camo", set);
    }

    public void surroundWithParticles(EntityPlayer player) {
        for (int i = 0; i < 8; ++i) {
            player.field_70170_p.func_72869_a("magicCrit", player.field_70165_t + (double)(field_77697_d.nextFloat() - field_77697_d.nextFloat()), player.field_70163_u + (double)(field_77697_d.nextFloat() - field_77697_d.nextFloat()), player.field_70161_v + (double)(field_77697_d.nextFloat() - field_77697_d.nextFloat()), 0.0, 0.0, 0.0);
        }
    }

    public void changeColor(World worldObj, EntityPlayer player) {
        BlockGrass test;
        int k;
        int j;
        int i = MathHelper.func_76128_c((double)player.field_70165_t);
        if (worldObj.func_147439_a(i, j = MathHelper.func_76128_c((double)player.field_70121_D.field_72338_b), k = MathHelper.func_76128_c((double)player.field_70161_v)) == Blocks.field_150350_a) {
            j = MathHelper.func_76128_c((double)(player.field_70121_D.field_72338_b - 0.1));
        }
        Block m = worldObj.func_147439_a(i, j, k);
        int meta = worldObj.func_72805_g(i, j, k);
        int foliage = 0;
        if (m instanceof BlockGrass) {
            test = (BlockGrass)m;
            foliage = test.func_149720_d((IBlockAccess)worldObj, i, j, k);
        } else if (m instanceof BlockLeaves) {
            test = (BlockLeaves)m;
            foliage = test.func_149720_d((IBlockAccess)worldObj, i, j, k);
        }
        if (m instanceof BlockVine) {
            m = this.currentBlock;
        }
        if (m != Blocks.field_150350_a && this.hasChanged && (m != this.currentBlock || meta != this.currentMeta || foliage != this.currentFoliage)) {
            this.currentBlock = m;
            this.currentMeta = meta;
            this.currentFoliage = foliage;
            IIcon icon = m.func_149691_a(1, meta);
            if (!(icon == null || m instanceof BlockGrass || m instanceof BlockLeaves || m instanceof BlockFluidBase || m instanceof BlockTallGrass)) {
                this.changeColorFromTexture(icon);
            } else if (m instanceof BlockGrass) {
                BlockGrass grass = (BlockGrass)m;
                int color = grass.func_149720_d((IBlockAccess)worldObj, i, j, k);
                icon = m.func_149691_a(0, meta);
                Color colour = new Color(color, true);
                if (colour.getRed() == colour.getGreen() && colour.getRed() == colour.getBlue() && colour.getGreen() == colour.getBlue()) {
                    this.changeColorFromTexture(icon);
                } else {
                    this.setNewR(colour.getRed());
                    this.setNewG(colour.getGreen());
                    this.setNewB(colour.getBlue());
                }
            } else if (m instanceof BlockTallGrass) {
                BlockTallGrass grass = (BlockTallGrass)m;
                int color = grass.func_149720_d((IBlockAccess)worldObj, i, j, k);
                icon = m.func_149691_a(0, meta);
                Color colour = new Color(color, true);
                if (colour.getRed() == colour.getGreen() && colour.getRed() == colour.getBlue() && colour.getGreen() == colour.getBlue()) {
                    this.changeColorFromTexture(icon);
                } else {
                    this.setNewR(colour.getRed());
                    this.setNewG(colour.getGreen());
                    this.setNewB(colour.getBlue());
                }
            } else if (m instanceof BlockLeaves) {
                BlockLeaves grass = (BlockLeaves)m;
                int color = grass.func_149720_d((IBlockAccess)worldObj, i, j, k);
                if (meta == 1 || meta == 5) {
                    color = ColorizerFoliage.func_77466_a();
                }
                if (meta == 2 || meta == 6) {
                    color = ColorizerFoliage.func_77469_b();
                }
                icon = m.func_149691_a(0, meta);
                Color colour = new Color(color, true);
                if (colour.getRed() == colour.getGreen() && colour.getRed() == colour.getBlue() && colour.getGreen() == colour.getBlue()) {
                    this.changeColorFromTexture(icon);
                } else {
                    this.setNewR(colour.getRed());
                    this.setNewG(colour.getGreen());
                    this.setNewB(colour.getBlue());
                }
            } else if (m instanceof BlockLilyPad) {
                BlockLilyPad grass = (BlockLilyPad)m;
                int color = grass.func_149720_d((IBlockAccess)worldObj, i, j, k);
                icon = m.func_149691_a(0, meta);
                Color colour = new Color(color, true);
                if (colour.getRed() == colour.getGreen() && colour.getRed() == colour.getBlue() && colour.getGreen() == colour.getBlue()) {
                    this.changeColorFromTexture(icon);
                } else {
                    this.setNewR(colour.getRed());
                    this.setNewG(colour.getGreen());
                    this.setNewB(colour.getBlue());
                }
            } else if (m instanceof BlockFluidBase) {
                BlockFluidBase water = (BlockFluidBase)m;
                int color = water.func_149720_d((IBlockAccess)worldObj, i, j, k);
                icon = m.func_149691_a(0, meta);
                Color colour = new Color(color, true);
                if (colour.getRed() == colour.getGreen() && colour.getRed() == colour.getBlue() && colour.getGreen() == colour.getBlue()) {
                    this.changeColorFromTexture(icon);
                } else {
                    this.setNewR(colour.getRed());
                    this.setNewG(colour.getGreen());
                    this.setNewB(colour.getBlue());
                }
            }
        }
    }

    public void changeColorFromTexture(IIcon icon) {
        SimpleReloadableResourceManager resourceManager = (SimpleReloadableResourceManager)Minecraft.func_71410_x().func_110442_L();
        Set set = resourceManager.func_135055_a();
        Object[] domains = set.toArray();
        IResource resource = null;
        for (int i = 0; i < domains.length; ++i) {
            resource = ResourceChecker.getResource(domains[i].toString(), "textures/blocks/" + icon.func_94215_i() + ".png");
            if (resource == null) {
                String[] divided = icon.func_94215_i().split(":");
                resource = ResourceChecker.getResource(domains[i].toString(), "textures/blocks/" + divided[1] + ".png");
            }
            if (resource != null) break;
        }
        if (resource != null) {
            InputStream stream = resource.func_110527_b();
            int[] rgb = null;
            try {
                rgb = ImageTester.main(stream);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (rgb != null) {
                this.setNewR(rgb[0]);
                this.setNewG(rgb[1]);
                this.setNewB(rgb[2]);
            }
        }
    }

    public float getR() {
        return this.R;
    }

    public float getG() {
        return this.G;
    }

    public float getB() {
        return this.B;
    }

    public void setR(float set) {
        this.R = set;
    }

    public void setG(float set) {
        this.G = set;
    }

    public void setB(float set) {
        this.B = set;
    }

    public float getNewR() {
        return this.NewR;
    }

    public float getNewG() {
        return this.NewG;
    }

    public float getNewB() {
        return this.NewB;
    }

    public void setNewR(float set) {
        this.NewR = set;
    }

    public void setNewG(float set) {
        this.NewG = set;
    }

    public void setNewB(float set) {
        this.NewB = set;
    }
}

