/*
 * Decompiled with CFR 0.152.
 */
package net.daveyx0.primitivemobs.lib;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Random;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.WeightedRandom;
import net.minecraft.util.WeightedRandomChestContent;
import net.minecraftforge.common.ChestGenHooks;

public class CustomChestGenHooks
extends ChestGenHooks {
    public static final String MIMIC_CHEST_SKELLY = "mimicChest";
    public static final String MIMIC_CHEST_TOOL = "mimicChestTool";
    public static final String MIMIC_CHEST_BAT = "mimicChestBat";
    public static final String CHEST_SPIDER_CAVE = "chestSpiderCave";
    public static final WeightedRandomChestContent[] customMimicContents = new WeightedRandomChestContent[]{new WeightedRandomChestContent(Items.field_151103_aS, 0, 1, 5, 15), new WeightedRandomChestContent(Items.field_151007_F, 0, 1, 3, 8), new WeightedRandomChestContent(Items.field_151040_l, 0, 1, 1, 1), new WeightedRandomChestContent((Item)Items.field_151031_f, 0, 1, 1, 1), new WeightedRandomChestContent((Item)Items.field_151024_Q, 0, 1, 1, 1)};
    public static final WeightedRandomChestContent[] customMimicToolContents = new WeightedRandomChestContent[]{new WeightedRandomChestContent(Items.field_151055_y, 0, 1, 5, 15), new WeightedRandomChestContent(Items.field_151042_j, 0, 1, 3, 3)};
    public static final WeightedRandomChestContent[] customMimicBatContents = new WeightedRandomChestContent[]{new WeightedRandomChestContent(Items.field_151103_aS, 0, 1, 5, 15), new WeightedRandomChestContent(Items.field_151007_F, 0, 1, 3, 8)};
    public static final WeightedRandomChestContent[] chestSpiderCaveContents = new WeightedRandomChestContent[]{new WeightedRandomChestContent(Items.field_151103_aS, 0, 1, 5, 15), new WeightedRandomChestContent(Items.field_151007_F, 0, 1, 3, 8)};
    private static final HashMap<String, CustomChestGenHooks> chestInfo = new HashMap();
    private static boolean hasInit = false;
    private String category;
    private int countMin = 0;
    private int countMax = 0;
    private ArrayList<WeightedRandomChestContent> contents = new ArrayList();

    private static void init() {
        if (hasInit) {
            return;
        }
        hasInit = true;
        CustomChestGenHooks.addInfo(MIMIC_CHEST_SKELLY, customMimicContents, 3, 7);
        CustomChestGenHooks.addInfo(MIMIC_CHEST_TOOL, customMimicToolContents, 3, 7);
        CustomChestGenHooks.addInfo(MIMIC_CHEST_BAT, customMimicBatContents, 3, 7);
        CustomChestGenHooks.addInfo(CHEST_SPIDER_CAVE, chestSpiderCaveContents, 3, 7);
    }

    static void addDungeonLoot(CustomChestGenHooks dungeon, ItemStack item, int weight, int min, int max) {
        dungeon.addItem(new WeightedRandomChestContent(item, min, max, weight));
    }

    private static void addInfo(String category, WeightedRandomChestContent[] items, int min, int max) {
        chestInfo.put(category, new CustomChestGenHooks(category, items, min, max));
    }

    public static CustomChestGenHooks getInfo(String category) {
        if (!chestInfo.containsKey(category)) {
            chestInfo.put(category, new CustomChestGenHooks(category));
        }
        return chestInfo.get(category);
    }

    public static ItemStack[] generateStacks(Random rand, ItemStack source, int min, int max) {
        ItemStack[] ret;
        int count = min + rand.nextInt(max - min + 1);
        if (source.func_77973_b() == null) {
            ret = new ItemStack[]{};
        } else if (count > source.func_77976_d()) {
            ret = new ItemStack[count];
            for (int x = 0; x < count; ++x) {
                ret[x] = source.func_77946_l();
                ret[x].field_77994_a = 1;
            }
        } else {
            ret = new ItemStack[]{source.func_77946_l()};
            ret[0].field_77994_a = count;
        }
        return ret;
    }

    public static WeightedRandomChestContent[] getItems(String category, Random rnd) {
        return CustomChestGenHooks.getInfo(category).getItems(rnd);
    }

    public static int getCount(String category, Random rand) {
        return CustomChestGenHooks.getInfo(category).getCount(rand);
    }

    public static void addItem(String category, WeightedRandomChestContent item) {
        CustomChestGenHooks.getInfo(category).addItem(item);
    }

    public static void removeItem(String category, ItemStack item) {
        CustomChestGenHooks.getInfo(category).removeItem(item);
    }

    public static ItemStack getOneItem(String category, Random rand) {
        return CustomChestGenHooks.getInfo(category).getOneItem(rand);
    }

    public CustomChestGenHooks(String category) {
        super(category);
        this.category = category;
    }

    public CustomChestGenHooks(String category, WeightedRandomChestContent[] items, int min, int max) {
        this(category);
        for (WeightedRandomChestContent item : items) {
            this.contents.add(item);
        }
        this.countMin = min;
        this.countMax = max;
    }

    public void addItem(WeightedRandomChestContent item) {
        this.contents.add(item);
    }

    public void removeItem(ItemStack item) {
        Iterator<WeightedRandomChestContent> itr = this.contents.iterator();
        while (itr.hasNext()) {
            WeightedRandomChestContent cont = itr.next();
            if (!item.func_77969_a(cont.field_76297_b) && (item.func_77960_j() != Short.MAX_VALUE || item.func_77973_b() != cont.field_76297_b.func_77973_b())) continue;
            itr.remove();
        }
    }

    public WeightedRandomChestContent[] getItems(Random rnd) {
        ArrayList<WeightedRandomChestContent> ret = new ArrayList<WeightedRandomChestContent>();
        for (WeightedRandomChestContent orig : this.contents) {
            WeightedRandomChestContent n;
            Item item = orig.field_76297_b.func_77973_b();
            if (item == null || (n = item.getChestGenBase((ChestGenHooks)this, rnd, orig)) == null) continue;
            ret.add(n);
        }
        return ret.toArray(new WeightedRandomChestContent[ret.size()]);
    }

    public int getCount(Random rand) {
        return this.countMin < this.countMax ? this.countMin + rand.nextInt(this.countMax - this.countMin) : this.countMin;
    }

    public ItemStack getOneItem(Random rand) {
        WeightedRandomChestContent[] items = this.getItems(rand);
        WeightedRandomChestContent item = (WeightedRandomChestContent)WeightedRandom.func_76274_a((Random)rand, (WeightedRandom.Item[])items);
        ItemStack[] stacks = ChestGenHooks.generateStacks((Random)rand, (ItemStack)item.field_76297_b, (int)item.field_76295_d, (int)item.field_76296_e);
        return stacks.length > 0 ? stacks[0] : null;
    }

    public int getMin() {
        return this.countMin;
    }

    public int getMax() {
        return this.countMax;
    }

    public void setMin(int value) {
        this.countMin = value;
    }

    public void setMax(int value) {
        this.countMax = value;
    }

    static {
        CustomChestGenHooks.init();
    }
}

