/*
 * Decompiled with CFR 0.152.
 */
package net.daveyx0.primitivemobs.entity.monster;

import java.util.Random;
import javax.annotation.Nullable;
import net.daveyx0.multimob.common.capabilities.CapabilityTameableEntity;
import net.daveyx0.multimob.common.capabilities.ITameableEntity;
import net.daveyx0.multimob.entity.IMultiMob;
import net.daveyx0.multimob.entity.ai.EntityAICustomFollowOwner;
import net.daveyx0.multimob.entity.ai.EntityAICustomOwnerHurtByTarget;
import net.daveyx0.multimob.entity.ai.EntityAICustomOwnerHurtTarget;
import net.daveyx0.multimob.util.EntityUtil;
import net.daveyx0.primitivemobs.entity.monster.EntityMotherSpider;
import net.daveyx0.primitivemobs.entity.monster.EntityPrimitiveSpider;
import net.daveyx0.primitivemobs.entity.monster.EntityPrimitiveTameableMob;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILeapAtTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;

public class EntityBabySpider
extends EntityPrimitiveSpider
implements IMultiMob {
    private int rideAttemptDelay;
    boolean initChild;
    private int jumpMountTicks;
    private static final DataParameter<Byte> DYE_COLOR = EntityDataManager.func_187226_a(EntityBabySpider.class, (DataSerializer)DataSerializers.field_187191_a);
    private static final DataParameter<Integer> GROWTH_LEVEL = EntityDataManager.func_187226_a(EntityBabySpider.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> IS_JUMPING = EntityDataManager.func_187226_a(EntityBabySpider.class, (DataSerializer)DataSerializers.field_187198_h);

    public EntityBabySpider(World worldIn) {
        super(worldIn);
        this.rideAttemptDelay = this.field_70146_Z.nextInt(100);
        this.initChild = false;
        this.setTamed(false);
        this.func_70105_a(0.5f, 0.3f);
        this.setGrowthLevel(0);
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(8.0);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(2.0);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(GROWTH_LEVEL, (Object)0);
        this.func_184212_Q().func_187214_a(DYE_COLOR, (Object)0);
        this.func_184212_Q().func_187214_a(IS_JUMPING, (Object)false);
    }

    @Override
    public float func_70047_e() {
        return this.field_70131_O / 2.0f;
    }

    public boolean func_82171_bF() {
        return this.getGrowthLevel() >= 5;
    }

    @Override
    public boolean func_70617_f_() {
        int j = MathHelper.func_76128_c((double)this.field_70165_t);
        int k = MathHelper.func_76128_c((double)this.field_70163_u);
        int l = MathHelper.func_76128_c((double)this.field_70161_v);
        boolean side1 = this.field_70170_p.func_175665_u(new BlockPos(j + 1, k, l));
        boolean side2 = this.field_70170_p.func_175665_u(new BlockPos(j - 1, k, l));
        boolean side3 = this.field_70170_p.func_175665_u(new BlockPos(j, k, l + 1));
        boolean side4 = this.field_70170_p.func_175665_u(new BlockPos(j, k, l - 1));
        return this.isBesideClimbableBlock() || side1 || side2 || side3 || side4;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAILeapAtTarget((EntityLiving)this, 0.4f));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityPrimitiveSpider.AISpiderAttack(this));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 0.8));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAICustomFollowOwner((EntityPrimitiveTameableMob)this, 1.0, 8.0f, 2.0f));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAICustomOwnerHurtByTarget((EntityPrimitiveTameableMob)this));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAICustomOwnerHurtTarget((EntityPrimitiveTameableMob)this));
    }

    protected boolean func_70610_aX() {
        ITameableEntity tameable = (ITameableEntity)EntityUtil.getCapability((Entity)this, (Capability)CapabilityTameableEntity.TAMEABLE_ENTITY_CAPABILITY, null);
        return tameable != null && tameable.isTamed() && tameable.getFollowState() == 0;
    }

    public boolean func_70104_M() {
        return !this.func_184207_aI();
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.getOwner() != null && this.getOwner() instanceof EntityMotherSpider) {
            ((EntityMotherSpider)this.getOwner()).setIsAngry(true);
        }
        return source.func_76355_l().equals("inWall") ? !this.func_184218_aH() : super.func_70097_a(source, amount);
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.initChild && this.getOwner() != null && this.getOwner() instanceof EntityMotherSpider) {
            EntityMotherSpider mother = (EntityMotherSpider)this.getOwner();
            mother.addFollower((EntityLivingBase)this);
            this.initChild = true;
        }
        if (this.rideAttemptDelay++ > 100 && this.getOwner() != null && !this.getOwner().func_184207_aI() && this.getOwner() instanceof EntityMotherSpider) {
            this.func_184220_m((Entity)this.getOwner());
        }
        if (this.func_130014_f_().field_72995_K && this.getOwner() == null) {
            this.func_130014_f_().func_175688_a(EnumParticleTypes.WATER_SPLASH, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()), this.field_70163_u + (double)(this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) + 1.0, this.field_70161_v + (double)(this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()), 0.0, 0.0, 0.0, new int[0]);
        }
        switch (this.getGrowthLevel()) {
            case 0: {
                this.func_70105_a(0.5f, 0.3f);
                break;
            }
            case 1: {
                this.func_70105_a(0.7f, 0.4f);
                break;
            }
            case 2: {
                this.func_70105_a(0.9f, 0.5f);
                break;
            }
            case 3: {
                this.func_70105_a(1.1f, 0.6f);
                break;
            }
            case 4: {
                this.func_70105_a(1.3f, 0.7f);
                break;
            }
            case 5: {
                this.func_70105_a(1.5f, 0.8f);
            }
        }
    }

    public void setGrowthLevel(int saplings) {
        this.func_184212_Q().func_187227_b(GROWTH_LEVEL, (Object)saplings);
    }

    public int getGrowthLevel() {
        return (Integer)this.func_184212_Q().func_187225_a(GROWTH_LEVEL);
    }

    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        boolean flag;
        ItemStack itemstack = player.func_184586_b(hand);
        boolean bl = flag = itemstack.func_77973_b() == Items.field_151071_bq;
        if (flag) {
            this.consumeItemFromStack(player, itemstack);
            this.setGrowthLevel(this.getGrowthLevel() + 1);
            for (int i = 0; i < 8; ++i) {
                this.field_70170_p.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()), this.field_70163_u + (double)this.field_70146_Z.nextFloat() + 1.0, this.field_70161_v + (double)(this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()), 0.0, 0.0, 0.0, new int[0]);
            }
            if (this.getGrowthLevel() == 5) {
                this.setEyeColor(EntityBabySpider.getRandomEyeColor(this.field_70170_p.field_73012_v));
                this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)0.3f + (double)this.field_70146_Z.nextFloat() * 0.1);
                this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(30.0);
                this.func_70606_j(30.0f);
            }
            return true;
        }
        if (!itemstack.func_190926_b() && itemstack.func_77973_b() == Items.field_151100_aR) {
            EnumDyeColor enumdyecolor = EnumDyeColor.func_176766_a((int)itemstack.func_77960_j());
            if (this.getEyeColor() != enumdyecolor) {
                this.setEyeColor(enumdyecolor);
                itemstack.func_190918_g(1);
            }
        }
        return super.func_184645_a(player, hand);
    }

    protected void consumeItemFromStack(EntityPlayer player, ItemStack stack) {
        if (!player.field_71075_bZ.field_75098_d) {
            stack.func_190918_g(1);
        }
    }

    @Override
    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74768_a("Growth", this.getGrowthLevel());
        compound.func_74757_a("Jumping", this.getIsJumping());
        compound.func_74774_a("Color", (byte)this.getEyeColor().func_176765_a());
    }

    @Override
    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.setGrowthLevel(compound.func_74762_e("Growth"));
        this.setIsJumping(compound.func_74767_n("Jumping"));
        this.setEyeColor(EnumDyeColor.func_176764_b((int)compound.func_74771_c("Color")));
    }

    public EnumDyeColor getEyeColor() {
        return EnumDyeColor.func_176764_b((int)((Byte)this.field_70180_af.func_187225_a(DYE_COLOR) & 0xF));
    }

    public void setEyeColor(EnumDyeColor color) {
        byte b0 = (Byte)this.field_70180_af.func_187225_a(DYE_COLOR);
        this.field_70180_af.func_187227_b(DYE_COLOR, (Object)((byte)(b0 & 0xF0 | color.func_176765_a() & 0xF)));
    }

    @Nullable
    public Entity func_184179_bs() {
        return this.func_184188_bt().isEmpty() ? null : (Entity)this.func_184188_bt().get(0);
    }

    public void func_191986_a(float strafe, float vertical, float forward) {
        if (this.jumpMountTicks > 0) {
            --this.jumpMountTicks;
        }
        if (this.func_184207_aI() && this.func_82171_bF()) {
            EntityLivingBase entitylivingbase = (EntityLivingBase)this.func_184179_bs();
            this.field_70126_B = this.field_70177_z = entitylivingbase.field_70177_z;
            this.field_70125_A = entitylivingbase.field_70125_A * 0.5f;
            this.func_70101_b(this.field_70177_z, this.field_70125_A);
            this.field_70759_as = this.field_70761_aq = this.field_70177_z;
            strafe = entitylivingbase.field_70702_br * 0.5f;
            forward = entitylivingbase.field_191988_bg;
            if (!this.field_70170_p.field_72995_K) {
                this.setBesideClimbableBlock(this.field_70123_F);
            }
            if (forward <= 0.0f) {
                forward *= 0.5f;
            }
            if (this.func_70090_H() && !this.isBesideClimbableBlock()) {
                this.field_70181_x = 0.02;
            }
            this.field_70747_aH = this.func_70689_ay() * 0.5f;
            if (this.func_184186_bw()) {
                this.func_70659_e((float)this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e() / 1.5f);
                super.func_191986_a(strafe, vertical, forward);
            }
            this.field_184618_aE = this.field_70721_aZ;
            double d1 = this.field_70165_t - this.field_70169_q;
            double d0 = this.field_70161_v - this.field_70166_s;
            float f2 = MathHelper.func_76133_a((double)(d1 * d1 + d0 * d0)) * 4.0f;
            if (f2 > 1.0f) {
                f2 = 1.0f;
            }
            this.field_70721_aZ += (f2 - this.field_70721_aZ) * 0.4f;
            this.field_184619_aG += this.field_70721_aZ;
        } else {
            super.func_191986_a(strafe, vertical, forward);
        }
    }

    protected float func_175134_bD() {
        return 0.62f;
    }

    public void setIsJumping(boolean b) {
        this.field_70180_af.func_187227_b(IS_JUMPING, (Object)b);
    }

    public boolean getIsJumping() {
        return (Boolean)this.field_70180_af.func_187225_a(IS_JUMPING);
    }

    public static EnumDyeColor getRandomEyeColor(Random random) {
        int i = random.nextInt(EnumDyeColor.values().length);
        return EnumDyeColor.func_176764_b((int)i);
    }

    public boolean isCreatureType(EnumCreatureType type, boolean forSpawnCount) {
        if (type == EnumCreatureType.MONSTER) {
            return false;
        }
        return super.isCreatureType(type, forSpawnCount);
    }
}

