/*
 * Decompiled with CFR 0.152.
 */
package net.daveyx0.primitivemobs.entity.monster;

import net.daveyx0.multimob.common.capabilities.CapabilityTameableEntity;
import net.daveyx0.multimob.common.capabilities.ITameableEntity;
import net.daveyx0.multimob.util.EntityUtil;
import net.daveyx0.primitivemobs.entity.monster.EntityFestiveCreeper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;

public class EntityPrimitiveCreeper
extends EntityCreeper {
    private int timeSinceIgnited;
    private int lastActiveTime;
    private static final DataParameter<Boolean> BABY = EntityDataManager.func_187226_a(EntityPrimitiveCreeper.class, (DataSerializer)DataSerializers.field_187198_h);
    protected int growingAge;
    protected int forcedAge;
    protected int forcedAgeTimer;
    private float ageWidth = -1.0f;
    private float ageHeight;

    public EntityPrimitiveCreeper(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.6f, 1.7f);
    }

    public void func_70071_h_() {
        ITameableEntity tameable;
        if (this instanceof EntityFestiveCreeper) {
            this.timeSinceIgnited = 0;
        }
        if (this.func_70638_az() != null && (tameable = (ITameableEntity)EntityUtil.getCapability((Entity)this, (Capability)CapabilityTameableEntity.TAMEABLE_ENTITY_CAPABILITY, null)) != null && tameable.isTamed() && tameable.getFollowState() == 0) {
            this.setIgnitedTime(0);
            this.func_70829_a(-1);
        }
        super.func_70071_h_();
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        ITameableEntity tameable = (ITameableEntity)EntityUtil.getCapability((Entity)this, (Capability)CapabilityTameableEntity.TAMEABLE_ENTITY_CAPABILITY, null);
        if (tameable != null && tameable.isTamed()) {
            return source != DamageSource.field_191552_t && source != DamageSource.field_76368_d && source != DamageSource.field_76379_h && source != DamageSource.field_76369_e && super.func_70097_a(source, amount);
        }
        return super.func_70097_a(source, amount);
    }

    public void setIgnitedTime(int time) {
        this.timeSinceIgnited = time;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(BABY, (Object)false);
    }

    public int getGrowingAge() {
        if (this.field_70170_p.field_72995_K) {
            return (Boolean)this.field_70180_af.func_187225_a(BABY) != false ? -1 : 1;
        }
        return this.growingAge;
    }

    public void ageUp(int growthSeconds, boolean updateForcedAge) {
        int i;
        int j = i = this.getGrowingAge();
        if ((i += growthSeconds * 20) > 0) {
            i = 0;
            if (j < 0) {
                this.onGrowingAdult();
            }
        }
        int k = i - j;
        this.setGrowingAge(i);
        if (updateForcedAge) {
            this.forcedAge += k;
            if (this.forcedAgeTimer == 0) {
                this.forcedAgeTimer = 40;
            }
        }
        if (this.getGrowingAge() == 0) {
            this.setGrowingAge(this.forcedAge);
        }
    }

    public void addGrowth(int growth) {
        this.ageUp(growth, false);
    }

    public void setGrowingAge(int age) {
        this.field_70180_af.func_187227_b(BABY, (Object)(age < 0 ? 1 : 0));
        this.growingAge = age;
        this.setScaleForAge(this.func_70631_g_());
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74768_a("Age", this.getGrowingAge());
        compound.func_74768_a("ForcedAge", this.forcedAge);
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.setGrowingAge(compound.func_74762_e("Age"));
        this.forcedAge = compound.func_74762_e("ForcedAge");
    }

    public void func_184206_a(DataParameter<?> key) {
        if (BABY.equals(key)) {
            this.setScaleForAge(this.func_70631_g_());
        }
        super.func_184206_a(key);
    }

    public void func_70636_d() {
        ITameableEntity tameable;
        super.func_70636_d();
        if (this.field_70170_p.field_72995_K) {
            if (this.forcedAgeTimer > 0) {
                if (this.forcedAgeTimer % 4 == 0) {
                    this.field_70170_p.func_175688_a(EnumParticleTypes.VILLAGER_HAPPY, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70163_u + 0.5 + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, 0.0, 0.0, 0.0, new int[0]);
                }
                --this.forcedAgeTimer;
            }
        } else {
            int i = this.getGrowingAge();
            if (i < 0) {
                this.setGrowingAge(++i);
                if (i == 0) {
                    this.onGrowingAdult();
                }
            } else if (i > 0) {
                this.setGrowingAge(--i);
            }
        }
        if ((tameable = (ITameableEntity)EntityUtil.getCapability((Entity)this, (Capability)CapabilityTameableEntity.TAMEABLE_ENTITY_CAPABILITY, null)) != null && tameable.isTamed() && this.func_70631_g_()) {
            CapabilityTameableEntity.EventHandler.resetEntityTargetAI((EntityLiving)this);
        }
    }

    protected void onGrowingAdult() {
    }

    public boolean func_70631_g_() {
        return this.getGrowingAge() < 0;
    }

    public void setScaleForAge(boolean child) {
        this.setScale(child ? 0.5f : 1.0f);
    }

    protected final void func_70105_a(float width, float height) {
        boolean flag = this.ageWidth > 0.0f;
        this.ageWidth = width;
        this.ageHeight = height;
        if (!flag) {
            this.setScale(1.0f);
        }
    }

    protected final void setScale(float scale) {
        super.func_70105_a(this.ageWidth * scale, this.ageHeight * scale);
    }
}

