/*
 * Decompiled with CFR 0.152.
 */
package net.daveyx0.primitivemobs.entity.monster;

import java.util.List;
import javax.annotation.Nullable;
import net.daveyx0.multimob.entity.EntityMMFlyingCreature;
import net.daveyx0.multimob.entity.IMultiMob;
import net.daveyx0.multimob.entity.ai.EntityAIFlyingAround;
import net.daveyx0.multimob.entity.ai.EntityAISenseEntityNearestPlayer;
import net.daveyx0.multimob.message.MMMessageRegistry;
import net.daveyx0.primitivemobs.core.PrimitiveMobsLootTables;
import net.daveyx0.primitivemobs.core.PrimitiveMobsSoundEvents;
import net.daveyx0.primitivemobs.message.MessageTeleportEye;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.EntityMoveHelper;
import net.minecraft.entity.boss.EntityDragon;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.EnderTeleportEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class EntityVoidEye
extends EntityMMFlyingCreature
implements IMultiMob {
    private static final DataParameter<Integer> TARGET_ENTITY = EntityDataManager.func_187226_a(EntityVoidEye.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> CAN_SEE_TARGET = EntityDataManager.func_187226_a(EntityVoidEye.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> DOES_TELEPORT = EntityDataManager.func_187226_a(EntityVoidEye.class, (DataSerializer)DataSerializers.field_187198_h);
    private EntityLivingBase targetedEntity;
    private int clientSideAttackTime;

    public EntityVoidEye(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.6f, 0.6f);
        this.setTeleports(false);
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(5.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(1.0);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(30.0);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(15.0);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new AIVoidEyeAttack(this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIFlyingAround((EntityMMFlyingCreature)this));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAISenseEntityNearestPlayer((EntityLiving)this, 18));
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(TARGET_ENTITY, (Object)0);
        this.field_70180_af.func_187214_a(CAN_SEE_TARGET, (Object)false);
        this.field_70180_af.func_187214_a(DOES_TELEPORT, (Object)false);
    }

    public void setCanSeeTarget(boolean sees) {
        this.func_184212_Q().func_187227_b(CAN_SEE_TARGET, (Object)sees);
    }

    public boolean canSeeTarget() {
        return (Boolean)this.func_184212_Q().func_187225_a(CAN_SEE_TARGET);
    }

    public void setTeleports(boolean sees) {
        this.func_184212_Q().func_187227_b(DOES_TELEPORT, (Object)sees);
    }

    public boolean doesTeleport() {
        return (Boolean)this.func_184212_Q().func_187225_a(DOES_TELEPORT);
    }

    public float getAttackAnimationScale(float p_175477_1_) {
        return ((float)this.clientSideAttackTime + p_175477_1_) / (float)this.getAttackDuration();
    }

    public float func_70047_e() {
        return this.field_70131_O * 0.5f;
    }

    public void func_70636_d() {
        if (this.field_70170_p.field_72995_K && this.hasTargetedEntity() && this.clientSideAttackTime < this.getAttackDuration()) {
            ++this.clientSideAttackTime;
        }
        if (!this.field_70170_p.field_72995_K) {
            if (this.getTargetedEntity() != null && this.func_70685_l((Entity)this.getTargetedEntity())) {
                this.setCanSeeTarget(true);
            } else {
                this.setCanSeeTarget(false);
            }
        }
        if (this.doesTeleport()) {
            this.teleportRandomly();
        }
        if (this.hasTargetedEntity()) {
            this.field_70177_z = this.field_70759_as;
        }
        super.func_70636_d();
    }

    @Nullable
    public EntityLivingBase getTargetedEntity() {
        if (!this.hasTargetedEntity()) {
            return null;
        }
        if (this.field_70170_p.field_72995_K) {
            if (this.targetedEntity != null) {
                return this.targetedEntity;
            }
            Entity entity = this.field_70170_p.func_73045_a(((Integer)this.field_70180_af.func_187225_a(TARGET_ENTITY)).intValue());
            if (entity instanceof EntityLivingBase) {
                this.targetedEntity = (EntityLivingBase)entity;
                return this.targetedEntity;
            }
            return null;
        }
        return this.func_70638_az();
    }

    public void func_184206_a(DataParameter<?> key) {
        super.func_184206_a(key);
        if (TARGET_ENTITY.equals(key)) {
            this.clientSideAttackTime = 0;
            this.targetedEntity = null;
        }
    }

    public int getAttackDuration() {
        return 75;
    }

    private void setTargetedEntity(int entityId) {
        this.field_70180_af.func_187227_b(TARGET_ENTITY, (Object)entityId);
    }

    public boolean hasTargetedEntity() {
        return (Integer)this.field_70180_af.func_187225_a(TARGET_ENTITY) != 0;
    }

    public int getTargetedEntityID() {
        return (Integer)this.field_70180_af.func_187225_a(TARGET_ENTITY);
    }

    protected boolean func_70041_e_() {
        return false;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.func_130014_f_().func_175688_a(EnumParticleTypes.SMOKE_LARGE, this.field_70165_t, this.field_70163_u + 0.5, this.field_70161_v, 0.0, 0.0, 0.0, new int[0]);
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_180431_b(source)) {
            return false;
        }
        boolean flag = super.func_70097_a(source, amount);
        if (source.func_76363_c() && this.field_70146_Z.nextInt(5) != 0 && this.field_70170_p.field_72995_K) {
            this.setTeleports(true);
            MMMessageRegistry.getNetwork().sendToServer((IMessage)new MessageTeleportEye(true, this.func_110124_au().toString()));
        }
        return flag;
    }

    protected boolean teleportRandomly() {
        double d0 = this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * 16.0;
        double d1 = this.field_70163_u + (double)(this.field_70146_Z.nextInt(32) - 16);
        double d2 = this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * 16.0;
        return this.teleportTo(d0, d1, d2);
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return PrimitiveMobsLootTables.ENTITIES_VOIDEYE;
    }

    private boolean teleportTo(double x, double y, double z) {
        EnderTeleportEvent event = new EnderTeleportEvent((EntityLivingBase)this, x, y, z, 0.0f);
        if (MinecraftForge.EVENT_BUS.post((Event)event)) {
            return false;
        }
        boolean flag = this.func_184595_k(event.getTargetX(), event.getTargetY(), event.getTargetZ());
        if (flag) {
            this.field_70170_p.func_184148_a((EntityPlayer)null, this.field_70169_q, this.field_70167_r, this.field_70166_s, SoundEvents.field_187534_aX, this.func_184176_by(), 1.0f, 1.0f);
            this.func_184185_a(SoundEvents.field_187534_aX, 1.0f, 1.0f);
            this.setTeleports(false);
        }
        return flag;
    }

    @Nullable
    public SoundEvent func_184639_G() {
        return PrimitiveMobsSoundEvents.ENTITY_VOIDEYE_IDLE;
    }

    protected SoundEvent func_184601_bQ(DamageSource p_184601_1_) {
        return SoundEvents.field_187528_aR;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_193777_bb;
    }

    public boolean func_70601_bi() {
        if (this.field_70170_p.field_73011_w.getDimension() == 1) {
            for (Entity entity : this.field_70170_p.field_72996_f) {
                if (!(entity instanceof EntityDragon)) continue;
                return false;
            }
        }
        return super.func_70601_bi();
    }

    public boolean isCreatureType(EnumCreatureType type, boolean forSpawnCount) {
        if (type == EnumCreatureType.MONSTER) {
            return false;
        }
        return super.isCreatureType(type, forSpawnCount);
    }

    static class AIVoidEyeAttack
    extends EntityAIBase {
        private final EntityVoidEye eye;
        private int tickCounter;

        public AIVoidEyeAttack(EntityVoidEye eye) {
            this.eye = eye;
            this.func_75248_a(3);
        }

        public boolean func_75250_a() {
            EntityLivingBase entitylivingbase = this.eye.func_70638_az();
            List voidEyesList = this.eye.field_70170_p.func_175647_a(EntityVoidEye.class, this.eye.func_174813_aQ().func_72314_b(20.0, 20.0, 20.0), null);
            if (voidEyesList != null && !voidEyesList.isEmpty() && !this.eye.hasTargetedEntity()) {
                for (EntityVoidEye voidEye : voidEyesList) {
                    if (entitylivingbase == null || !voidEye.hasTargetedEntity() || voidEye.getTargetedEntityID() != entitylivingbase.func_145782_y()) continue;
                    return false;
                }
            }
            return entitylivingbase != null && entitylivingbase.func_70089_S();
        }

        public void func_75249_e() {
            this.tickCounter = -10;
            this.eye.func_70661_as().func_75499_g();
            this.eye.func_70671_ap().func_75651_a((Entity)this.eye.func_70638_az(), 90.0f, 90.0f);
            this.eye.field_70160_al = true;
        }

        public void func_75251_c() {
            this.eye.setTargetedEntity(0);
            this.eye.func_70624_b(null);
        }

        public void func_75246_d() {
            EntityLivingBase entitylivingbase = this.eye.func_70638_az();
            this.eye.func_70661_as().func_75499_g();
            this.eye.func_70605_aq().field_188491_h = EntityMoveHelper.Action.WAIT;
            this.eye.func_70671_ap().func_75651_a((Entity)entitylivingbase, 90.0f, 90.0f);
            ++this.tickCounter;
            if (this.tickCounter == 0) {
                this.eye.func_184185_a(SoundEvents.field_187789_eW, 1.0f, 1.0f);
                this.eye.setTargetedEntity(this.eye.func_70638_az().func_145782_y());
            } else if (this.tickCounter >= this.eye.getAttackDuration()) {
                if (this.eye.canSeeTarget()) {
                    entitylivingbase.func_70097_a(DamageSource.func_76354_b((Entity)this.eye, (Entity)this.eye), (float)this.eye.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e());
                }
                entitylivingbase.func_70690_d(new PotionEffect(MobEffects.field_76419_f, 240, 0));
                entitylivingbase.func_70690_d(new PotionEffect(MobEffects.field_76440_q, 240, 0));
                entitylivingbase.func_70690_d(new PotionEffect(MobEffects.field_76438_s, 240, 0));
                this.eye.func_70624_b(null);
            }
            super.func_75246_d();
        }
    }
}

