/*
 * Decompiled with CFR 0.152.
 */
package net.daveyx0.primitivemobs.item;

import java.awt.Color;
import java.util.List;
import javax.annotation.Nullable;
import net.daveyx0.multimob.message.MMMessageRegistry;
import net.daveyx0.multimob.util.ColorUtil;
import net.daveyx0.primitivemobs.core.PrimitiveMobs;
import net.daveyx0.primitivemobs.item.ItemPrimitive;
import net.daveyx0.primitivemobs.message.MessagePrimitiveColor;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemCamouflageArmor
extends ItemArmor {
    private float R;
    private float G;
    private float B;
    private float NewR;
    private float NewG;
    private float NewB;
    private int colorSpeed = 4;
    private IBlockState currentState;
    private int currentMultiplier;

    public ItemCamouflageArmor(ItemArmor.ArmorMaterial material, EntityEquipmentSlot equipmentSlot, String armourName) {
        super(material, -1, equipmentSlot);
        ItemPrimitive.setItemName((Item)this, armourName);
        this.func_77637_a(PrimitiveMobs.tabPrimitiveMobs);
        this.setSkinRGB(new int[]{255, 255, 255});
    }

    public void onArmorTick(World world, EntityPlayer player, ItemStack armor) {
        if (player != null && player.func_130014_f_().field_72995_K && !this.getCannotChange(armor)) {
            this.changeColor((Entity)player);
            this.func_82813_b(armor, new Color((int)this.getSkinRGB()[0], (int)this.getSkinRGB()[1], (int)this.getSkinRGB()[2]).hashCode());
            if (this.currentState != null) {
                this.setColorBlockState(armor, this.currentState);
            }
            MMMessageRegistry.getNetwork().sendToServer((IMessage)new MessagePrimitiveColor(this.func_82814_b(armor), this.field_77881_a, player.func_110124_au().toString()));
        }
        if (this.R != this.NewR || this.G != this.NewG || this.B != this.NewB) {
            for (int i = 0; i < this.colorSpeed; ++i) {
                if (this.R > this.NewR) {
                    this.R -= 1.0f;
                } else if (this.R < this.NewR) {
                    this.R += 1.0f;
                }
                if (this.G > this.NewG) {
                    this.G -= 1.0f;
                } else if (this.G < this.NewG) {
                    this.G += 1.0f;
                }
                if (this.B > this.NewB) {
                    this.B -= 1.0f;
                    continue;
                }
                if (!(this.B < this.NewB)) continue;
                this.B += 1.0f;
            }
        }
        player.field_71069_bz.func_75142_b();
        super.onArmorTick(world, player, armor);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        if (!stack.func_190926_b() && stack.func_77973_b() instanceof ItemCamouflageArmor) {
            ItemCamouflageArmor armor = (ItemCamouflageArmor)stack.func_77973_b();
            if (armor.getCannotChange(stack)) {
                tooltip.add("Camouflage: disabled");
            } else {
                tooltip.add("Camouflage: enabled");
            }
            Color color = new Color(armor.func_82814_b(stack));
            IBlockState state = armor.getColorBlockState(stack);
            if (state != null) {
                String name = new ItemStack(state.func_177230_c(), 1, state.func_177230_c().func_176201_c(state)).func_82833_r();
                if (name.equals(Blocks.field_150350_a.func_149732_F())) {
                    tooltip.add("Block: " + state.func_177230_c().func_149732_F());
                } else {
                    tooltip.add("Block: " + new ItemStack(state.func_177230_c(), 1, state.func_177230_c().func_176201_c(state)).func_82833_r());
                }
            }
        }
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
    }

    public boolean hasOverlay(ItemStack stack) {
        return true;
    }

    public float[] getSkinRGB() {
        return new float[]{this.R, this.G, this.B};
    }

    public void setSkinRGB(int[] RGB) {
        this.R = RGB[0];
        this.G = RGB[1];
        this.B = RGB[2];
    }

    public float[] getNewSkinRGB() {
        return new float[]{this.NewR, this.NewG, this.NewB};
    }

    public void setNewSkinRGB(int[] RGB) {
        this.NewR = RGB[0];
        this.NewG = RGB[1];
        this.NewB = RGB[2];
    }

    public void changeColor(Entity entity) {
        int i = MathHelper.func_76128_c((double)entity.field_70165_t);
        int j = MathHelper.func_76128_c((double)entity.func_174813_aQ().field_72338_b);
        int k = MathHelper.func_76128_c((double)entity.field_70161_v);
        if (entity.func_130014_f_().func_180495_p(new BlockPos(i, j, k)).func_177230_c() == Blocks.field_150350_a) {
            j = MathHelper.func_76128_c((double)(entity.func_174813_aQ().field_72338_b - 0.1));
        }
        BlockPos pos = new BlockPos(i, j, k);
        IBlockState state = entity.func_130014_f_().func_180495_p(pos);
        int colorMultiplier = Minecraft.func_71410_x().func_184125_al().func_186724_a(state, (IBlockAccess)entity.func_130014_f_(), pos, 0);
        if (state.func_177230_c() != Blocks.field_150350_a && (this.currentState != state || this.currentMultiplier != colorMultiplier)) {
            this.currentState = state;
            this.currentMultiplier = colorMultiplier;
            int[] newColor = ColorUtil.getBlockStateColor((IBlockState)state, (BlockPos)pos, (World)entity.func_130014_f_(), (boolean)true);
            if (newColor != null) {
                if (ColorUtil.isColorInvalid((int[])newColor)) {
                    newColor = new int[]{255, 255, 255, 255};
                }
                this.setNewSkinRGB(newColor);
            }
        }
    }

    public boolean func_82816_b_(ItemStack stack) {
        NBTTagCompound nbttagcompound = stack.func_77978_p();
        return nbttagcompound != null && nbttagcompound.func_150297_b("display", 10) ? nbttagcompound.func_74775_l("display").func_150297_b("color", 3) : false;
    }

    public int func_82814_b(ItemStack stack) {
        NBTTagCompound nbttagcompound1;
        NBTTagCompound nbttagcompound = stack.func_77978_p();
        if (nbttagcompound != null && (nbttagcompound1 = nbttagcompound.func_74775_l("display")) != null && nbttagcompound1.func_150297_b("color", 3)) {
            return nbttagcompound1.func_74762_e("color");
        }
        return 0xFFFFFF;
    }

    public void func_82815_c(ItemStack stack) {
        NBTTagCompound nbttagcompound1;
        NBTTagCompound nbttagcompound = stack.func_77978_p();
        if (nbttagcompound != null && (nbttagcompound1 = nbttagcompound.func_74775_l("display")).func_74764_b("color")) {
            nbttagcompound1.func_82580_o("color");
        }
    }

    @Nullable
    public IBlockState getColorBlockState(ItemStack p_82814_1_) {
        NBTTagCompound nbttagcompound = p_82814_1_.func_77978_p();
        if (nbttagcompound == null) {
            return Blocks.field_150350_a.func_176223_P();
        }
        return NBTUtil.func_190008_d((NBTTagCompound)nbttagcompound);
    }

    public void setColorBlockState(ItemStack stack, IBlockState state) {
        NBTTagCompound nbttagcompound = stack.func_77978_p();
        if (nbttagcompound == null) {
            nbttagcompound = new NBTTagCompound();
            stack.func_77982_d(nbttagcompound);
        }
        NBTUtil.func_190009_a((NBTTagCompound)nbttagcompound, (IBlockState)state);
    }

    public void func_82813_b(ItemStack stack, int color) {
        NBTTagCompound nbttagcompound = stack.func_77978_p();
        if (nbttagcompound == null) {
            nbttagcompound = new NBTTagCompound();
            stack.func_77982_d(nbttagcompound);
        }
        NBTTagCompound nbttagcompound1 = nbttagcompound.func_74775_l("display");
        if (!nbttagcompound.func_150297_b("display", 10)) {
            nbttagcompound.func_74782_a("display", (NBTBase)nbttagcompound1);
        }
        nbttagcompound1.func_74768_a("color", color);
    }

    public boolean getCannotChange(ItemStack p_82814_1_) {
        NBTTagCompound nbttagcompound = p_82814_1_.func_77978_p();
        if (nbttagcompound == null) {
            return false;
        }
        return nbttagcompound == null ? false : (nbttagcompound.func_74764_b("change") ? nbttagcompound.func_74767_n("change") : false);
    }

    public void setCannotChange(ItemStack stack, boolean set) {
        NBTTagCompound nbttagcompound = stack.func_77978_p();
        if (nbttagcompound == null) {
            nbttagcompound = new NBTTagCompound();
            stack.func_77982_d(nbttagcompound);
        }
        nbttagcompound.func_74757_a("change", set);
    }

    public static void setCamouflageArmorNBT(EntityLivingBase entity, EntityEquipmentSlot slot) {
        int color;
        ItemCamouflageArmor item;
        ItemStack stack = entity.func_184582_a(slot);
        if (stack.func_77973_b() instanceof ItemCamouflageArmor && !(item = (ItemCamouflageArmor)stack.func_77973_b()).getCannotChange(stack) && entity.func_130014_f_().field_72995_K && (color = ColorUtil.getBlockColor((Entity)entity)) < -1) {
            item.func_82813_b(stack, color);
            item.setColorBlockState(stack, ColorUtil.getBlockState((Entity)entity));
            MMMessageRegistry.getNetwork().sendToServer((IMessage)new MessagePrimitiveColor(item.func_82814_b(stack), slot, entity.func_110124_au().toString()));
        }
    }
}

