/*
 * Decompiled with CFR 0.152.
 */
package technicianlp.reauth;

import java.io.IOException;
import java.nio.file.LinkOption;
import java.security.GeneralSecurityException;
import java.security.SecureRandom;
import java.util.Base64;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import technicianlp.reauth.Crypto;
import technicianlp.reauth.ReAuth;

public final class Configuration {
    private final ForgeConfigSpec spec;
    private final ForgeConfigSpec.IntValue versionSpec;
    private final ForgeConfigSpec.ConfigValue<String> profileNameSpec;
    private final ForgeConfigSpec.ConfigValue<String> saltSpec;
    private final ForgeConfigSpec.ConfigValue<String> usernameSpec;
    private final ForgeConfigSpec.ConfigValue<String> passwordSpec;
    private Crypto crypto;

    public Configuration() {
        ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
        this.versionSpec = builder.comment("Version Number of the Configuration File").defineInRange("version", 2, 1, 2);
        builder.comment("Credentials for login, encrypted with AES-CBC-PKCS5Padding and PBKDF2WithHmacSHA512 based on the Path of this file and the contained Salt.\nManually editing one of the Encrypted Values or the Salt, is inadvisable - Reset them to \"\" if required\nKeep in mind that while the credentials are no longer humanly readable, they could still be decrypted by malicious third parties").push("credentials");
        this.saltSpec = builder.comment("One of the values required to decrypt the credentials\nSee https://en.wikipedia.org/wiki/Salt_(cryptography) for details").define("salt", (Object)"");
        this.profileNameSpec = builder.comment("The Name of the last used Profile").define("profile", (Object)"");
        this.usernameSpec = builder.comment("Your Username (encrypted)").define("username", (Object)"");
        this.passwordSpec = builder.comment("Your Password (encrypted)").define("password", (Object)"");
        builder.pop();
        this.spec = builder.build();
        if (!Boolean.getBoolean("mods.reauth.disableCrypto")) {
            try {
                this.crypto = new Crypto();
            }
            catch (GeneralSecurityException e) {
                ReAuth.log.error("Unable to locate cryptographic algorithms. Credentials cannot be saved", (Throwable)e);
            }
        } else {
            ReAuth.log.error("Crypto disabled by commandline");
        }
    }

    public ForgeConfigSpec getSpec() {
        return this.spec;
    }

    public void setConfig(ModConfig config) {
        if ((Integer)this.versionSpec.get() == 1) {
            this.convertConfigV1(config);
            return;
        }
        byte[] salt = null;
        boolean saltLoaded = false;
        String saltRaw = (String)this.saltSpec.get();
        if (!saltRaw.isEmpty()) {
            try {
                salt = Base64.getDecoder().decode(saltRaw);
                if (salt.length == 16) {
                    saltLoaded = true;
                } else {
                    ReAuth.log.error("Salt corrupted, saved credentials cannot be recovered");
                }
            }
            catch (IllegalArgumentException e) {
                ReAuth.log.error("Could not load salt, saved credentials cannot be recovered", (Throwable)e);
            }
        }
        if (!saltLoaded) {
            salt = this.createSalt();
            this.saltSpec.set((Object)Base64.getEncoder().encodeToString(salt));
        }
        if (this.crypto != null) {
            this.crypto.setup(this.getPath(config), salt);
        }
    }

    private void convertConfigV1(ModConfig config) {
        this.versionSpec.set((Object)2);
        byte[] salt = this.createSalt();
        this.saltSpec.set((Object)Base64.getEncoder().encodeToString(salt));
        if (this.crypto != null) {
            this.crypto.setup(this.getPath(config), salt);
        }
        this.setCredentials("", (String)this.usernameSpec.get(), (String)this.passwordSpec.get());
    }

    private String getPath(ModConfig config) {
        try {
            return config.getFullPath().toRealPath(new LinkOption[0]).toString();
        }
        catch (IOException e) {
            ReAuth.log.error("Could not resolve real path", (Throwable)e);
            return config.getFullPath().toString();
        }
    }

    private byte[] createSalt() {
        byte[] salt = new byte[16];
        new SecureRandom().nextBytes(salt);
        return salt;
    }

    public void setCredentials(String profileName, String username, String password) {
        if (this.crypto == null) {
            return;
        }
        this.profileNameSpec.set((Object)profileName);
        if (!username.isEmpty()) {
            username = this.crypto.encryptString(username);
        }
        this.usernameSpec.set((Object)username);
        if (!password.isEmpty()) {
            password = this.crypto.encryptString(password);
        }
        this.passwordSpec.set((Object)password);
        this.spec.save();
    }

    public String getUsername() {
        String username = (String)this.usernameSpec.get();
        if (username.isEmpty()) {
            return (String)this.profileNameSpec.get();
        }
        if (this.crypto != null) {
            return this.crypto.decryptString(username);
        }
        return "";
    }

    public String getProfile() {
        return (String)this.profileNameSpec.get();
    }

    public String getPassword() {
        String password = (String)this.passwordSpec.get();
        if (!password.isEmpty() && this.crypto != null) {
            return this.crypto.decryptString(password);
        }
        return "";
    }

    public boolean hasCrypto() {
        return this.crypto != null;
    }

    public boolean hasCredentials() {
        return this.hasCrypto() && !((String)this.usernameSpec.get()).isEmpty() && !((String)this.passwordSpec.get()).isEmpty() && !((String)this.profileNameSpec.get()).isEmpty();
    }
}

