/*
 * Decompiled with CFR 0.152.
 */
package reauth;

import cpw.mods.fml.client.event.ConfigChangedEvent;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.ModMetadata;
import cpw.mods.fml.common.event.FMLFingerprintViolationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.io.File;
import net.minecraft.client.Minecraft;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import reauth.GuiHandler;
import reauth.Secure;

@Mod(modid="reauth", name="ReAuth", version="3.5.0", guiFactory="reauth.GuiFactory", canBeDeactivated=true, acceptedMinecraftVersions="[1.7.10]", certificateFingerprint="aa395513cd0890f9c69d4229ac5d779667421c85")
public class Main {
    static final Logger log = LogManager.getLogger((String)"ReAuth");
    static Configuration config;
    static boolean OfflineModeEnabled;
    @Mod.Instance(value="ReAuth")
    static Main main;
    @Mod.Metadata
    static ModMetadata meta;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent evt) throws NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException {
        MinecraftForge.EVENT_BUS.register((Object)new GuiHandler());
        FMLCommonHandler.instance().bus().register((Object)this);
        File config = new File(Minecraft.func_71410_x().field_71412_D, ".ReAuth.cfg");
        if (evt.getSuggestedConfigurationFile().exists() && !config.exists()) {
            evt.getSuggestedConfigurationFile().renameTo(config);
        }
        Main.config = new Configuration(config);
        Main.loadConfig();
        Secure.init();
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent evt) {
        if (evt.modID.equals("reauth")) {
            Main.loadConfig();
        }
    }

    private static void loadConfig() {
        Property username = config.get("general", "username", "", "Your Username");
        Secure.username = username.getString();
        Property password = config.get("general", "password", "", "Your Password in plaintext if chosen to save to disk");
        Secure.password = password.getString();
        Property offline = config.get("general", "offlineModeEnabled", false, "Enables play-offline button");
        OfflineModeEnabled = offline.getBoolean();
        Property validator = config.get("general", "validatorEnabled", true, "Disables the Session Validator");
        GuiHandler.enabled = validator.getBoolean();
        Property bold = config.get("general", "validatorBold", true, "If the Session-Validator look weird disable this");
        GuiHandler.bold = bold.getBoolean();
        config.save();
    }

    @Mod.EventHandler
    public void securityError(FMLFingerprintViolationEvent event) {
        boolean dev = false;
        if (!dev) {
            throw new SecurityException("The Version of ReAuth is not signed! It is a modified version!");
        }
        log.fatal("+-----------------------------------------------------------------------------------+");
        log.fatal("|The Version of ReAuth is not signed! It was modified! Ignoring because of Dev-Mode!|");
        log.fatal("+-----------------------------------------------------------------------------------+");
    }
}

