/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.lib;

import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.silentchaos512.lib.debug.DataDump;
import net.silentchaos512.lib.event.SilentLibClientEvents;
import net.silentchaos512.lib.event.SilentLibCommonEvents;
import net.silentchaos512.lib.gui.GuiHandlerLibF;
import net.silentchaos512.lib.network.NetworkHandlerSL;
import net.silentchaos512.lib.network.internal.MessageLeftClick;
import net.silentchaos512.lib.util.LocalizationHelper;
import net.silentchaos512.lib.util.LogHelper;

@Mod(modid="silentlib", name="Silent Lib", version="2.1.5", dependencies="required-after:Forge@[12.18.2.2125,);", acceptedMinecraftVersions="[1.10.2]")
public class SilentLib {
    public static final String MOD_ID = "silentlib";
    public static final String MOD_NAME = "Silent Lib";
    public static final String DEPENDENCIES = "required-after:Forge@[12.18.2.2125,);";
    public static final String VERSION = "2.1.5";
    public static NetworkHandlerSL network;
    public static LogHelper logHelper;
    @Mod.Instance(value="silentlib")
    public static SilentLib instance;
    private final Map<String, LocalizationHelper> locHelpers = Maps.newHashMap();

    public LocalizationHelper getLocalizationHelperForMod(String modId) {
        return this.locHelpers.get(modId.toLowerCase());
    }

    public void registerLocalizationHelperForMod(String modId, LocalizationHelper loc) {
        this.locHelpers.put(modId.toLowerCase(), loc);
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        network = new NetworkHandlerSL(MOD_ID);
        network.register(MessageLeftClick.class, Side.SERVER);
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)this, (IGuiHandler)new GuiHandlerLibF());
        MinecraftForge.EVENT_BUS.register((Object)new SilentLibCommonEvents());
        if (event.getSide() == Side.CLIENT) {
            MinecraftForge.EVENT_BUS.register((Object)new SilentLibClientEvents());
        }
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        DataDump.dumpEntityList();
        DataDump.dumpEnchantments();
        DataDump.dumpPotionEffects();
    }

    public static int getMCVersion() {
        return 10;
    }

    static {
        logHelper = new LogHelper(MOD_NAME);
    }
}

