/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.lib.config;

import java.io.File;
import java.util.List;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.ConfigElement;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.client.config.IConfigElement;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public abstract class ConfigBase {
    public static final String SEP = ".";
    public static final String CAT_MAIN = "main";
    protected Configuration config;
    protected final String modId;

    public ConfigBase(String modId) {
        this.modId = modId;
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public abstract void load();

    public int loadInt(String key, String category, int defaultValue, String comment) {
        Property prop = this.config.get(category, key, defaultValue);
        prop.setComment(comment);
        return prop.getInt(defaultValue);
    }

    public int loadInt(String key, String category, int defaultValue, int min, int max, String comment) {
        Property prop = this.config.get(category, key, defaultValue);
        prop.setComment(comment + " [range: " + min + " ~ " + max + ", default: " + defaultValue + "]");
        prop.setMinValue(min);
        prop.setMaxValue(max);
        int val = prop.getInt(defaultValue);
        return val < min ? min : (val > max ? max : val);
    }

    public double loadDouble(String key, String category, double defaultValue, String comment) {
        Property prop = this.config.get(category, key, defaultValue);
        prop.setComment(comment);
        return prop.getDouble();
    }

    public double loadDouble(String key, String category, double defaultValue, double min, double max, String comment) {
        Property prop = this.config.get(category, key, defaultValue);
        prop.setComment(comment + " [range: " + min + " ~ " + max + ", default: " + defaultValue + "]");
        prop.setMinValue(min);
        prop.setMaxValue(max);
        double val = prop.getDouble(defaultValue);
        return val < min ? min : (val > max ? max : val);
    }

    public float loadFloat(String key, String category, float defaultValue, String comment) {
        return (float)this.loadDouble(key, category, defaultValue, comment);
    }

    public float loadFloat(String key, String category, float defaultValue, float min, float max, String comment) {
        return (float)this.loadDouble(key, category, defaultValue, min, max, comment);
    }

    public boolean loadBoolean(String key, String category, boolean defaultValue, String comment) {
        Property prop = this.config.get(category, key, defaultValue);
        prop.setComment(comment);
        return prop.getBoolean();
    }

    public void init(File file) {
        this.config = new Configuration(file);
        this.load();
    }

    public void save() {
        if (this.config.hasChanged()) {
            this.config.save();
        }
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equalsIgnoreCase(this.modId)) {
            this.load();
            this.save();
        }
    }

    public ConfigCategory getCategory(String category) {
        return this.config.getCategory(category);
    }

    public List<IConfigElement> getConfigElements() {
        return new ConfigElement(this.getCategory(CAT_MAIN)).getChildElements();
    }

    public Configuration getConfiguration() {
        return this.config;
    }
}

