/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.lib.debug;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.EntityList;
import net.minecraft.potion.Potion;
import net.silentchaos512.lib.SilentLib;

public class DataDump {
    static final String SEPARATOR = "--------------------------------------------------------------------------------";

    public static void dumpEnchantments() {
        SilentLib.logHelper.info(SEPARATOR);
        SilentLib.logHelper.info("The following is a list of all enchantments registered as of Silent Lib's post-init:");
        for (Enchantment ench : Enchantment.field_185264_b) {
            try {
                String str = "  %-30s %-40s type=%-10s";
                str = String.format(str, ench.func_77316_c(1).replaceFirst(" I$", ""), ench.getRegistryName(), ench.field_77351_y == null ? "null" : ench.field_77351_y.name());
                SilentLib.logHelper.info(str);
            }
            catch (Exception ex) {
                SilentLib.logHelper.info("Errored on enchantment: " + ench);
            }
        }
        SilentLib.logHelper.info(SEPARATOR);
    }

    public static void dumpEntityList() {
        SilentLib.logHelper.info(SEPARATOR);
        SilentLib.logHelper.info("The following is a list of all enchantments registered as of Silent Lib's post-init:");
        ArrayList list = Lists.newArrayList();
        for (String name : EntityList.func_180124_b()) {
            try {
                int id = EntityList.func_180122_a((String)name);
                Class clazz = EntityList.func_90035_a((int)id);
                String str2 = "  %-40s %4d   %-40s";
                str2 = String.format(str2, name, id, clazz);
                list.add(str2);
            }
            catch (Exception ex) {
                list.add("***Errored on entity: " + name);
            }
        }
        list.sort((s1, s2) -> s1.compareToIgnoreCase((String)s2));
        list.forEach(str -> SilentLib.logHelper.info(str));
        SilentLib.logHelper.info(SEPARATOR);
    }

    public static void dumpPotionEffects() {
        SilentLib.logHelper.info(SEPARATOR);
        SilentLib.logHelper.info("The following is a list of all potion effects registered as of Silent Lib's post-init:");
        for (Potion pot : Potion.field_188414_b) {
            try {
                String str = "%-30s %-40s";
                str = String.format(str, pot.func_76393_a(), pot.getRegistryName().toString());
                SilentLib.logHelper.info(str);
            }
            catch (Exception ex) {
                SilentLib.logHelper.info("Errored on potion: " + pot);
            }
        }
        SilentLib.logHelper.info(SEPARATOR);
    }
}

