/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.lib.guidebook.misc;

import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.silentchaos512.lib.guidebook.GuideBook;
import net.silentchaos512.lib.guidebook.IGuideChapter;
import net.silentchaos512.lib.guidebook.IGuidePage;
import net.silentchaos512.lib.guidebook.gui.GuiEntry;
import net.silentchaos512.lib.guidebook.gui.GuiMainPage;
import net.silentchaos512.lib.guidebook.gui.GuiPage;
import net.silentchaos512.lib.guidebook.internal.GuiGuideBase;
import net.silentchaos512.lib.item.ItemGuideBookSL;
import net.silentchaos512.lib.util.StackHelper;

public final class GuideBookUtils {
    public static IGuidePage findFirstPageForStack(GuideBook book, ItemStack stack) {
        for (IGuidePage page : book.getPagesWithItemOrFluidData()) {
            ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
            page.getItemStacksForPage(stacks);
            if (stacks == null || stacks.isEmpty()) continue;
            for (ItemStack pageStack : stacks) {
                if (!pageStack.func_77969_a(stack)) continue;
                return page;
            }
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public static GuiPage createBookletGuiFromPage(GuideBook book, GuiScreen previousScreen, IGuidePage page) {
        GuiMainPage mainPage = new GuiMainPage(book, previousScreen);
        IGuideChapter chapter = page.getChapter();
        GuiEntry entry = new GuiEntry(book, previousScreen, (GuiGuideBase)mainPage, chapter.getEntry(), chapter, "", false);
        return GuideBookUtils.createPageGui(book, previousScreen, entry, page);
    }

    @SideOnly(value=Side.CLIENT)
    public static GuiPage createPageGui(GuideBook book, GuiScreen previousScreen, GuiGuideBase parentPage, IGuidePage page) {
        IGuidePage page2;
        IGuidePage page1;
        IGuideChapter chapter = page.getChapter();
        IGuidePage[] allPages = chapter.getAllPages();
        int pageIndex = chapter.getPageIndex(page);
        if (page.shouldBeOnLeftSide()) {
            page1 = page;
            page2 = pageIndex >= allPages.length - 1 ? null : allPages[pageIndex + 1];
        } else {
            page1 = pageIndex <= 0 ? null : allPages[pageIndex - 1];
            page2 = page;
        }
        return new GuiPage(book, previousScreen, parentPage, page1, page2);
    }

    public static IGuidePage getBookletPageById(GuideBook book, String id) {
        if (id != null) {
            for (IGuideChapter chapter : book.getChapters()) {
                for (IGuidePage page : chapter.getAllPages()) {
                    if (!id.equals(page.getIdentifier())) continue;
                    return page;
                }
            }
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public static GuideBook getBookFromClientPlayerHand() {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (player != null) {
            ItemStack stack = player.func_184614_ca();
            if (StackHelper.isEmpty(stack)) {
                stack = player.func_184592_cb();
            }
            if (stack.func_77973_b() instanceof ItemGuideBookSL) {
                ItemGuideBookSL itemBook = (ItemGuideBookSL)stack.func_77973_b();
                return itemBook.book;
            }
        }
        return null;
    }
}

