/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.lib.guidebook.page;

import java.util.Arrays;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraftforge.fml.client.config.GuiUtils;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import net.silentchaos512.lib.SilentLib;
import net.silentchaos512.lib.guidebook.GuideBook;
import net.silentchaos512.lib.guidebook.internal.GuiGuideBase;
import net.silentchaos512.lib.guidebook.page.GuidePage;
import net.silentchaos512.lib.guidebook.page.PageTextOnly;
import net.silentchaos512.lib.util.StackHelper;

public class PageCrafting
extends GuidePage {
    private final List<IRecipe> recipes;
    private int recipeAt;
    private String recipeTypeLocKey;
    private boolean isWildcard;

    public PageCrafting(GuideBook book, int localizationKey, int priority, List<IRecipe> recipes) {
        super(book, localizationKey, priority);
        this.recipes = recipes;
    }

    public PageCrafting(GuideBook book, int localizationKey, List<IRecipe> recipes) {
        this(book, localizationKey, 0, recipes);
    }

    public PageCrafting(GuideBook book, int localizationKey, IRecipe ... recipes) {
        this(book, localizationKey, 0, recipes);
    }

    public PageCrafting(GuideBook book, int localizationKey, int priority, IRecipe ... recipes) {
        this(book, localizationKey, priority, Arrays.asList(recipes));
    }

    public GuidePage setWildcard() {
        this.isWildcard = true;
        return this;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawScreenPre(GuiGuideBase gui, int startX, int startY, int mouseX, int mouseY, float partialTicks) {
        super.drawScreenPre(gui, startX, startY, mouseX, mouseY, partialTicks);
        gui.field_146297_k.func_110434_K().func_110577_a(this.book.getResourceGadgets());
        GuiUtils.drawTexturedModalRect((int)(startX + 5), (int)(startY + 6), (int)20, (int)0, (int)116, (int)54, (float)0.0f);
        gui.renderScaledAsciiString("(" + this.book.loc.getLocalizedString(this.recipeTypeLocKey, new Object[0]) + ")", startX + 6, startY + 65, 0, false, gui.getMediumFontSize());
        PageTextOnly.renderTextToPage(gui, this, startX + 6, startY + 80);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void updateScreen(GuiGuideBase gui, int startX, int startY, int pageTimer) {
        super.updateScreen(gui, startX, startY, pageTimer);
        if (pageTimer % 20 == 0) {
            this.findRecipe(gui, startX, startY);
        }
    }

    private void findRecipe(GuiGuideBase gui, int startX, int startY) {
        if (!this.recipes.isEmpty()) {
            IRecipe recipe = this.recipes.get(this.recipeAt);
            if (recipe != null) {
                this.setupRecipe(gui, recipe, startX, startY);
            }
            ++this.recipeAt;
            if (this.recipeAt >= this.recipes.size()) {
                this.recipeAt = 0;
            }
        }
    }

    @Override
    public void initGui(GuiGuideBase gui, int startX, int startY) {
        super.initGui(gui, startX, startY);
        this.findRecipe(gui, startX, startY);
    }

    @Override
    public void getItemStacksForPage(List<ItemStack> list) {
        super.getItemStacksForPage(list);
        if (!this.recipes.isEmpty()) {
            for (IRecipe recipe : this.recipes) {
                ItemStack output;
                if (recipe == null || !StackHelper.isValid(output = recipe.func_77571_b())) continue;
                ItemStack copy = StackHelper.safeCopy(output);
                if (this.isWildcard) {
                    copy.func_77964_b(Short.MAX_VALUE);
                }
                list.add(copy);
            }
        }
    }

    private void setupRecipe(GuiGuideBase gui, IRecipe recipe, int startX, int startY) {
        Object input;
        int i;
        ShapelessRecipes shapeless;
        ShapedRecipes shaped;
        ItemStack[] stacks = new ItemStack[9];
        int width = 3;
        int height = 3;
        if (recipe instanceof ShapedRecipes) {
            shaped = (ShapedRecipes)recipe;
            width = shaped.field_77576_b;
            height = shaped.field_77577_c;
            stacks = shaped.field_77574_d;
            this.recipeTypeLocKey = "guide.silentlib:shapedRecipe";
        } else if (recipe instanceof ShapelessRecipes) {
            shapeless = (ShapelessRecipes)recipe;
            for (i = 0; i < shapeless.field_77579_b.size(); ++i) {
                stacks[i] = (ItemStack)shapeless.field_77579_b.get(i);
            }
            this.recipeTypeLocKey = "guide.silentlib:shapelessRecipe";
        } else if (recipe instanceof ShapedOreRecipe) {
            shaped = (ShapedOreRecipe)recipe;
            try {
                width = (Integer)ReflectionHelper.getPrivateValue(ShapedOreRecipe.class, (Object)shaped, (int)4);
                height = (Integer)ReflectionHelper.getPrivateValue(ShapedOreRecipe.class, (Object)shaped, (int)5);
            }
            catch (Exception e) {
                SilentLib.logHelper.warning("Something went wrong trying to get the Crafting Recipe in the booklet to display!");
                e.printStackTrace();
            }
            for (i = 0; i < shaped.getInput().length; ++i) {
                input = shaped.getInput()[i];
                if (input == null) continue;
                stacks[i] = input instanceof ItemStack ? (ItemStack)input : (((List)input).isEmpty() ? StackHelper.empty() : (ItemStack)((List)input).get(0));
            }
            this.recipeTypeLocKey = "guide.silentlib:shapedOreRecipe";
        } else if (recipe instanceof ShapelessOreRecipe) {
            shapeless = (ShapelessOreRecipe)recipe;
            for (i = 0; i < shapeless.getInput().size(); ++i) {
                input = shapeless.getInput().get(i);
                stacks[i] = input instanceof ItemStack ? (ItemStack)input : (((List)input).isEmpty() ? StackHelper.empty() : (ItemStack)((List)input).get(0));
            }
            this.recipeTypeLocKey = "guide.silentlib:shapelessOreRecipe";
        }
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                ItemStack stack = stacks[y * width + x];
                if (!StackHelper.isValid(stack)) continue;
                ItemStack copy = StackHelper.safeCopy(stack);
                if ((copy = StackHelper.setCount(copy, 1)).func_77952_i() == Short.MAX_VALUE) {
                    copy.func_77964_b(0);
                }
                gui.addOrModifyItemRenderer(copy, startX + 6 + x * 18, startY + 7 + y * 18, 1.0f, true);
            }
        }
        gui.addOrModifyItemRenderer(recipe.func_77571_b(), startX + 100, startY + 25, 1.0f, false);
    }
}

