/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.lib.guidebook.page;

import java.util.List;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraftforge.fml.client.config.GuiUtils;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.silentchaos512.lib.guidebook.GuideBook;
import net.silentchaos512.lib.guidebook.internal.GuiGuideBase;
import net.silentchaos512.lib.guidebook.page.GuidePage;
import net.silentchaos512.lib.guidebook.page.PageTextOnly;
import net.silentchaos512.lib.util.StackHelper;

public class PageFurnace
extends GuidePage {
    private final ItemStack input;
    private final ItemStack output;

    public PageFurnace(GuideBook book, int localizationKey, ItemStack output) {
        this(book, localizationKey, output, 0);
    }

    public PageFurnace(GuideBook book, int localizationKey, ItemStack output, int priority) {
        super(book, localizationKey, priority);
        this.output = output;
        this.input = PageFurnace.getInputForOutput(output);
    }

    private static ItemStack getInputForOutput(ItemStack output) {
        for (Map.Entry entry : FurnaceRecipes.func_77602_a().func_77599_b().entrySet()) {
            ItemStack stack = (ItemStack)entry.getValue();
            if (!StackHelper.isValid(stack) || !stack.func_77969_a(output)) continue;
            return (ItemStack)entry.getKey();
        }
        return null;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawScreenPre(GuiGuideBase gui, int startX, int startY, int mouseX, int mouseY, float partialTicks) {
        super.drawScreenPre(gui, startX, startY, mouseX, mouseY, partialTicks);
        gui.field_146297_k.func_110434_K().func_110577_a(this.book.getResourceGadgets());
        GuiUtils.drawTexturedModalRect((int)(startX + 23), (int)(startY + 10), (int)0, (int)146, (int)80, (int)26, (float)0.0f);
        gui.renderScaledAsciiString("(" + this.book.loc.getLocalizedString("guide.silentlib:furnaceRecipe", new Object[0]) + ")", startX + 32, startY + 42, 0, false, gui.getMediumFontSize());
        PageTextOnly.renderTextToPage(gui, this, startX + 6, startY + 57);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void initGui(GuiGuideBase gui, int startX, int startY) {
        super.initGui(gui, startX, startY);
        gui.addOrModifyItemRenderer(this.input, startX + 23 + 1, startY + 10 + 5, 1.0f, true);
        gui.addOrModifyItemRenderer(this.output, startX + 23 + 59, startY + 10 + 5, 1.0f, false);
    }

    @Override
    public void getItemStacksForPage(List<ItemStack> list) {
        super.getItemStacksForPage(list);
        list.add(this.output);
    }
}

