/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.lib.item;

import java.util.List;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.silentchaos512.lib.SilentLib;
import net.silentchaos512.lib.item.IItemSL;
import net.silentchaos512.lib.registry.IRegistryObject;
import net.silentchaos512.lib.util.LocalizationHelper;
import net.silentchaos512.lib.util.ModelHelper;

public class ItemFoodSL
extends ItemFood
implements IRegistryObject,
IItemSL {
    protected int subItemCount;
    protected String itemName;
    protected String modId;

    public ItemFoodSL(int subItemCount, String modId, String name, int amount, float saturation, boolean isWolfFood) {
        super(amount, saturation, isWolfFood);
        this.subItemCount = subItemCount;
        this.modId = modId.toLowerCase();
        this.func_77655_b(name);
    }

    public ItemFoodSL(int subItemCount, String modId, String name) {
        this(subItemCount, modId, name, 0, 0.0f, false);
    }

    @Override
    public void addRecipes() {
    }

    @Override
    public void addOreDict() {
    }

    @Override
    public String getName() {
        return this.itemName;
    }

    @Override
    public String getFullName() {
        return this.modId + ":" + this.getName();
    }

    @Override
    public String getModId() {
        return this.modId;
    }

    @Override
    public List<ModelResourceLocation> getVariants() {
        return ModelHelper.getVariants(this, this.subItemCount);
    }

    @Override
    public boolean registerModels() {
        return false;
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List<String> list, boolean advanced) {
        LocalizationHelper loc = SilentLib.instance.getLocalizationHelperForMod(this.modId);
        if (loc != null) {
            String name = this.getNameForStack(stack);
            list.addAll(loc.getItemDescriptionLines(name));
        }
    }

    public String func_77667_c(ItemStack stack) {
        return "item." + this.modId + ":" + this.getNameForStack(stack);
    }

    public String getNameForStack(ItemStack stack) {
        return this.itemName + (this.field_77787_bX ? Integer.valueOf(stack.func_77952_i()) : "");
    }

    public Item func_77655_b(String name) {
        this.itemName = name;
        return super.func_77655_b(name);
    }

    public ActionResult<ItemStack> func_77659_a(ItemStack stack, World worldIn, EntityPlayer playerIn, EnumHand hand) {
        return this.clOnItemRightClick(worldIn, playerIn, hand);
    }

    protected ActionResult<ItemStack> clOnItemRightClick(World worldIn, EntityPlayer playerIn, EnumHand hand) {
        return super.func_77659_a(playerIn.func_184586_b(hand), worldIn, playerIn, hand);
    }

    public EnumActionResult func_180614_a(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        return this.clOnItemUse(player, world, pos, hand, facing, hitX, hitY, hitZ);
    }

    protected EnumActionResult clOnItemUse(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        return super.func_180614_a(player.func_184586_b(hand), player, world, pos, hand, facing, hitX, hitY, hitZ);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item itemIn, CreativeTabs tab, List<ItemStack> subItems) {
        this.clGetSubItems(itemIn, tab, subItems);
    }

    @SideOnly(value=Side.CLIENT)
    protected void clGetSubItems(Item itemIn, CreativeTabs tab, List<ItemStack> subItems) {
        super.func_150895_a(itemIn, tab, subItems);
    }
}

