/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.lib.util;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;

public class LocalizationHelper {
    public final String modId;
    private boolean replacesAmpersandWithSectionSign = true;
    private boolean hideFormatErrors = false;

    public LocalizationHelper(String modId) {
        this.modId = modId.toLowerCase();
    }

    public LocalizationHelper setReplaceAmpersand(boolean value) {
        this.replacesAmpersandWithSectionSign = value;
        return this;
    }

    public LocalizationHelper setHideFormatErrors(boolean value) {
        this.hideFormatErrors = value;
        return this;
    }

    public String getLocalizedString(String key, Object ... parameters) {
        if (FMLCommonHandler.instance().getSide() == Side.SERVER) {
            return I18n.func_74837_a((String)key, (Object[])parameters);
        }
        String str = net.minecraft.client.resources.I18n.func_135052_a((String)key, (Object[])parameters).trim();
        if (this.replacesAmpersandWithSectionSign) {
            str = str.replaceAll("&", "\u00a7");
        }
        if (this.hideFormatErrors) {
            str = str.replaceFirst("Format error: ", "");
        }
        return str;
    }

    public String getLocalizedString(String prefix, String key, Object ... parameters) {
        return this.getLocalizedString(prefix + "." + this.modId + ":" + key, parameters);
    }

    public String getMiscText(String key, Object ... parameters) {
        return this.getLocalizedString("misc", key, parameters);
    }

    public String getWikiText(String key, Object ... parameters) {
        return this.getLocalizedString("wiki", key, parameters);
    }

    public String getBlockSubText(String blockName, String key, Object ... parameters) {
        return this.getLocalizedString("tile", blockName + "." + key, parameters);
    }

    public String getItemSubText(String itemName, String key, Object ... parameters) {
        return this.getLocalizedString("item", itemName + "." + key, parameters);
    }

    public List<String> getBlockDescriptionLines(String blockName) {
        return this.getDescriptionLines("tile." + this.modId + ":" + blockName + ".desc");
    }

    public List<String> getItemDescriptionLines(String itemName) {
        return this.getDescriptionLines("item." + this.modId + ":" + itemName + ".desc");
    }

    public List<String> getDescriptionLines(String key) {
        boolean oldHideFormatErrors = this.hideFormatErrors;
        this.hideFormatErrors = true;
        ArrayList list = Lists.newArrayList();
        int i = 1;
        String line = this.getLocalizedString(key + i, new Object[0]);
        while (!line.equals(key + i)) {
            list.add(line);
            line = this.getLocalizedString(key + ++i, new Object[0]);
        }
        if (list.isEmpty() && !(line = this.getLocalizedString(key, new Object[0])).equals(key)) {
            list.add(line);
        }
        this.hideFormatErrors = oldHideFormatErrors;
        return list;
    }
}

