/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.lib.util;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.oredict.OreDictionary;
import net.silentchaos512.lib.collection.ItemStackList;

public class StackHelper {
    @Nonnull
    public static ItemStack grow(@Nonnull ItemStack stack, int amount) {
        stack.field_77994_a += amount;
        if (stack.field_77994_a <= 0) {
            return null;
        }
        return stack;
    }

    @Nonnull
    public static ItemStack shrink(@Nonnull ItemStack stack, int amount) {
        return StackHelper.grow(stack, -amount);
    }

    @Nonnull
    public static ItemStack safeCopy(@Nullable ItemStack stack) {
        if (stack == null) {
            return null;
        }
        stack = stack.func_77946_l();
        if (stack.field_77994_a == 0) {
            stack.field_77994_a = 1;
        }
        return stack;
    }

    public static int getCount(@Nullable ItemStack stack) {
        if (stack == null) {
            return 0;
        }
        return stack.field_77994_a;
    }

    @Nonnull
    public static ItemStack setCount(@Nonnull ItemStack stack, int amount) {
        if (amount <= 0) {
            stack.field_77994_a = 0;
            return null;
        }
        stack.field_77994_a = amount;
        return stack;
    }

    public static boolean isEmpty(@Nullable ItemStack stack) {
        if (stack == null) {
            return true;
        }
        return stack.field_77994_a <= 0;
    }

    public static boolean isValid(@Nullable ItemStack stack) {
        if (stack == null) {
            return false;
        }
        return stack.field_77994_a > 0;
    }

    @Nullable
    public static ItemStack loadFromNBT(NBTTagCompound tags) {
        if (tags == null) {
            return StackHelper.empty();
        }
        return ItemStack.func_77949_a((NBTTagCompound)tags);
    }

    @Nonnull
    public static ItemStack empty() {
        return null;
    }

    @Nonnull
    public static ItemStack extractItem(@Nullable TileEntity tileEntity, int slot, int amount) {
        if (tileEntity != null && tileEntity.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)) {
            IItemHandler capability = (IItemHandler)tileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
            return capability.extractItem(slot, amount, false);
        }
        if (tileEntity instanceof IInventory) {
            IInventory inventory = (IInventory)tileEntity;
            return inventory.func_70298_a(slot, amount);
        }
        return StackHelper.empty();
    }

    public static void setStack(@Nullable TileEntity tileEntity, int slot, @Nonnull ItemStack stack) {
        if (tileEntity != null && tileEntity.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)) {
            IItemHandler capability = (IItemHandler)tileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
            capability.extractItem(slot, 64, false);
            capability.insertItem(slot, stack, false);
        } else if (tileEntity instanceof IInventory) {
            IInventory inventory = (IInventory)tileEntity;
            inventory.func_70299_a(slot, stack);
        }
    }

    public static List<ItemStack> getOres(String name) {
        return OreDictionary.getOres((String)name);
    }

    public static List<ItemStack> getOres(String name, boolean alwaysCreateEntry) {
        return OreDictionary.getOres((String)name, (boolean)alwaysCreateEntry);
    }

    public static ItemStack getAndSplit(ItemStackList stacks, int index, int amount) {
        return index >= 0 && index < stacks.size() && StackHelper.isValid(stacks.get(index)) && amount > 0 ? stacks.get(index).func_77979_a(amount) : StackHelper.empty();
    }

    public static ItemStack getAndRemove(ItemStackList stacks, int index) {
        return index >= 0 && index < stacks.size() ? stacks.set(index, StackHelper.empty()) : StackHelper.empty();
    }

    public static NBTTagCompound saveAllItems(NBTTagCompound tags, ItemStackList stacks) {
        return StackHelper.saveAllItems(tags, stacks, true);
    }

    public static NBTTagCompound saveAllItems(NBTTagCompound tags, ItemStackList stacks, boolean p_191281_2_) {
        NBTTagList nbttaglist = new NBTTagList();
        for (int i = 0; i < stacks.size(); ++i) {
            ItemStack itemstack = stacks.get(i);
            if (!StackHelper.isValid(itemstack)) continue;
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            nbttagcompound.func_74774_a("Slot", (byte)i);
            itemstack.func_77955_b(nbttagcompound);
            nbttaglist.func_74742_a((NBTBase)nbttagcompound);
        }
        if (!nbttaglist.func_82582_d() || p_191281_2_) {
            tags.func_74782_a("Items", (NBTBase)nbttaglist);
        }
        return tags;
    }

    public static void loadAllItems(NBTTagCompound tags, ItemStackList stacks) {
        NBTTagList nbttaglist = tags.func_150295_c("Items", 10);
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            NBTTagCompound nbttagcompound = nbttaglist.func_150305_b(i);
            int j = nbttagcompound.func_74771_c("Slot") & 0xFF;
            if (j < 0 || j >= stacks.size()) continue;
            stacks.set(j, StackHelper.loadFromNBT(nbttagcompound));
        }
    }
}

