/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.lib.config;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.silentchaos512.lib.config.ConfigBase;

public abstract class AdaptiveConfig
extends ConfigBase {
    public static final String CAT_LAST_VERSION = "zzlastversion";
    @Nonnull
    protected Adaptor adaptor;
    protected boolean adaptorEnabled;
    protected int currentBuild;

    public AdaptiveConfig(String modId, boolean adaptorEnabled, int currentBuild) {
        super(modId);
        this.adaptorEnabled = adaptorEnabled;
        this.currentBuild = currentBuild;
    }

    @Override
    public void init(File file) {
        this.config = new Configuration(file);
        int lastBuild = this.config.get(CAT_LAST_VERSION, "last_build", this.currentBuild).getInt(this.currentBuild);
        this.adaptor = new Adaptor(this.adaptorEnabled, lastBuild, this.currentBuild);
        this.load();
    }

    @Override
    public void save() {
        this.config.get(CAT_LAST_VERSION, "last_build", this.currentBuild).setValue(this.currentBuild);
        super.save();
    }

    @Override
    public int loadInt(String key, String category, int defaultValue, String comment) {
        Property prop = this.config.get(category, key, defaultValue);
        prop.setComment(comment);
        this.adaptor.adaptProperty(prop, prop.getInt(defaultValue));
        return prop.getInt(defaultValue);
    }

    @Override
    public int loadInt(String key, String category, int defaultValue, int min, int max, String comment) {
        Property prop = this.config.get(category, key, defaultValue);
        if (comment != null && !comment.isEmpty()) {
            prop.setComment(comment + " [range: " + min + " ~ " + max + ", default: " + defaultValue + "]");
        }
        prop.setMinValue(min);
        prop.setMaxValue(max);
        this.adaptor.adaptProperty(prop, prop.getInt(defaultValue));
        int val = prop.getInt(defaultValue);
        return val < min ? min : (val > max ? max : val);
    }

    @Override
    public double loadDouble(String key, String category, double defaultValue, String comment) {
        Property prop = this.config.get(category, key, defaultValue);
        prop.setComment(comment);
        this.adaptor.adaptProperty(prop, prop.getDouble(defaultValue));
        return prop.getDouble();
    }

    @Override
    public double loadDouble(String key, String category, double defaultValue, double min, double max, String comment) {
        Property prop = this.config.get(category, key, defaultValue);
        if (comment != null && !comment.isEmpty()) {
            prop.setComment(comment + " [range: " + min + " ~ " + max + ", default: " + defaultValue + "]");
        }
        prop.setMinValue(min);
        prop.setMaxValue(max);
        this.adaptor.adaptProperty(prop, prop.getDouble(defaultValue));
        double val = prop.getDouble(defaultValue);
        return val < min ? min : (val > max ? max : val);
    }

    public <T> void addAdaptorMapping(int version, String key, T val) {
        this.adaptor.addMapping(version, key, val);
    }

    public static class AdaptableValue<T> {
        public final int version;
        public final T value;
        public final Class<? extends T> valueType;

        public AdaptableValue(int version, T value) {
            this.version = version;
            this.value = value;
            this.valueType = value.getClass();
        }
    }

    public static class Adaptor {
        private boolean enabled;
        private int lastBuild;
        private int currentBuild;
        private final Map<String, List<AdaptableValue>> adaptableValues = Maps.newHashMap();
        private final List<String> changes = Lists.newArrayList();

        public Adaptor(boolean enabled, int lastBuild, int currentBuild) {
            this.enabled = enabled;
            this.lastBuild = lastBuild;
            this.currentBuild = currentBuild;
        }

        public <T> void adaptProperty(Property prop, T val) {
            if (!this.enabled) {
                return;
            }
            String name = prop.getName();
            if (!this.adaptableValues.containsKey(name)) {
                return;
            }
            AdaptableValue bestValue = null;
            for (AdaptableValue value : this.adaptableValues.get(name)) {
                if (value.version >= this.lastBuild || bestValue != null && value.version <= bestValue.version) continue;
                bestValue = value;
            }
            if (bestValue != null) {
                Object expected = bestValue.value;
                String def = prop.getDefault();
                if (this.areEqualNumbers(val, expected) && !this.areEqualNumbers(val, def)) {
                    prop.setValue(def.toString());
                    this.changes.add(" " + prop.getName() + ": " + val + " -> " + def);
                }
            }
        }

        public <T> void addMapping(int version, String key, T val) {
            if (!this.enabled) {
                return;
            }
            AdaptableValue<T> adapt = new AdaptableValue<T>(version, val);
            if (!this.adaptableValues.containsKey(key)) {
                this.adaptableValues.put(key, new ArrayList());
            }
            this.adaptableValues.get(key).add(adapt);
        }

        public boolean areEqualNumbers(Object v1, Object v2) {
            double epsilon = 1.0E-6;
            float v1f = ((Number)v1).floatValue();
            float v2f = v2 instanceof String ? Float.parseFloat((String)v2) : ((Number)v2).floatValue();
            return (double)Math.abs(v1f - v2f) < epsilon;
        }
    }
}

