/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.lib.registry;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemModelMesher;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.RecipeSorter;
import net.silentchaos512.lib.item.ItemBlockSL;
import net.silentchaos512.lib.registry.IRegistryObject;
import net.silentchaos512.lib.util.LogHelper;

public class SRegistry {
    protected final Map<String, Block> blocks = Maps.newHashMap();
    protected final Map<String, Item> items = Maps.newHashMap();
    protected final List<IRegistryObject> registryObjects = Lists.newArrayList();
    protected Object mod;
    protected LogHelper logHelper;
    protected int lastEntityId = -1;
    public final String modId;
    public final String resourcePrefix;
    protected boolean listModelsInPost = false;

    public SRegistry(String modId) {
        this.modId = modId;
        this.resourcePrefix = modId.toLowerCase() + ":";
    }

    public SRegistry(String modId, LogHelper logHelper) {
        this(modId);
        this.logHelper = logHelper;
    }

    public void setMod(Object mod) {
        this.mod = mod;
    }

    public <T extends Block> T registerBlock(T block) {
        return this.registerBlock(block, ((IRegistryObject)block).getName());
    }

    public <T extends Block> T registerBlock(T block, String key) {
        return this.registerBlock(block, key, new ItemBlockSL(block));
    }

    public <T extends Block> T registerBlock(T block, ItemBlock itemBlock) {
        return this.registerBlock(block, ((IRegistryObject)block).getName(), itemBlock);
    }

    public <T extends Block> T registerBlock(T block, String key, ItemBlock itemBlock) {
        this.blocks.put(key, block);
        if (block instanceof IRegistryObject) {
            this.registryObjects.add((IRegistryObject)block);
        }
        ResourceLocation resource = new ResourceLocation(this.resourcePrefix + key);
        block.setRegistryName(resource);
        GameRegistry.register(block);
        GameRegistry.register((IForgeRegistryEntry)itemBlock, (ResourceLocation)resource);
        return block;
    }

    public <T extends Item> T registerItem(T item) {
        return this.registerItem(item, ((IRegistryObject)item).getName());
    }

    public <T extends Item> T registerItem(T item, String key) {
        this.items.put(key, item);
        if (item instanceof IRegistryObject) {
            this.registryObjects.add((IRegistryObject)item);
        }
        ResourceLocation resource = new ResourceLocation(this.resourcePrefix + key);
        GameRegistry.register(item, (ResourceLocation)resource);
        return item;
    }

    public void registerTileEntity(Class<? extends TileEntity> tileClass, String key) {
        String fullKey = "tile." + this.resourcePrefix + key;
        GameRegistry.registerTileEntity(tileClass, (String)fullKey);
    }

    public void registerEntity(Class<? extends Entity> entityClass, String key) {
        this.registerEntity(entityClass, key, ++this.lastEntityId, this.mod, 64, 20, true);
    }

    public void registerEntity(Class<? extends Entity> entityClass, String key, int trackingRange, int updateFrequency, boolean sendsVelocityUpdates) {
        this.registerEntity(entityClass, key, ++this.lastEntityId, this.mod, trackingRange, updateFrequency, sendsVelocityUpdates);
    }

    public void registerEntity(Class<? extends Entity> entityClass, String key, int id, Object mod, int trackingRange, int updateFrequency, boolean sendsVelocityUpdates) {
        ResourceLocation resource = new ResourceLocation(this.modId, key);
        EntityRegistry.registerModEntity((ResourceLocation)resource, entityClass, (String)key, (int)id, (Object)mod, (int)trackingRange, (int)updateFrequency, (boolean)sendsVelocityUpdates);
    }

    @SideOnly(value=Side.CLIENT)
    public <T extends TileEntity> void registerTileEntitySpecialRenderer(Class<T> tileClass, TileEntitySpecialRenderer<T> renderer) {
        ClientRegistry.bindTileEntitySpecialRenderer(tileClass, renderer);
    }

    @SideOnly(value=Side.CLIENT)
    @Deprecated
    public void registerEntityRenderer(Class<? extends Entity> entityClass, Render renderer) {
        Minecraft.func_71410_x().func_175598_ae().field_78729_o.put(entityClass, renderer);
    }

    @SideOnly(value=Side.CLIENT)
    public <T extends Entity> void registerEntityRenderer(Class<T> entityClass, IRenderFactory<T> renderFactory) {
        RenderingRegistry.registerEntityRenderingHandler(entityClass, renderFactory);
    }

    public IRecipe addRecipeHandler(Class<? extends IRecipe> recipeClass, String name, RecipeSorter.Category category, String dependencies) throws InstantiationException, IllegalAccessException {
        IRecipe recipe = recipeClass.newInstance();
        GameRegistry.addRecipe((IRecipe)recipe);
        RecipeSorter.register((String)(this.resourcePrefix + name), recipeClass, (RecipeSorter.Category)category, (String)dependencies);
        return recipe;
    }

    public Block getBlock(String key) {
        return this.blocks.get(key);
    }

    public Item getItem(String key) {
        return this.items.get(key);
    }

    public void preInit() {
        if (this.mod == null) {
            ModContainer container = (ModContainer)Loader.instance().getIndexedModList().get(this.modId);
            if (container != null) {
                this.mod = container.getMod();
            } else if (this.logHelper != null) {
                this.logHelper.warning("SRegistry for this mod failed to get the mod instance! This could be because the provided mod ID is incorrect.");
            }
        }
        this.addOreDictEntries();
    }

    public void init() {
        this.addRecipes();
    }

    public void postInit() {
    }

    public void clientPreInit() {
    }

    public void clientInit() {
        this.registerModels();
    }

    public void clientPostInit() {
        if (this.listModelsInPost) {
            for (IRegistryObject obj : this.registryObjects) {
                for (ModelResourceLocation model : obj.getVariants()) {
                    if (model == null) continue;
                    System.out.println(model);
                }
            }
        }
    }

    @Deprecated
    protected void addRecipesAndOreDictEntries() {
        for (IRegistryObject obj : this.registryObjects) {
            obj.addOreDict();
            obj.addRecipes();
        }
    }

    protected void addRecipes() {
        for (IRegistryObject obj : this.registryObjects) {
            obj.addRecipes();
        }
    }

    protected void addOreDictEntries() {
        for (IRegistryObject obj : this.registryObjects) {
            obj.addOreDict();
        }
    }

    @SideOnly(value=Side.CLIENT)
    protected void registerModels() {
        ItemModelMesher mesher = Minecraft.func_71410_x().func_175599_af().func_175037_a();
        for (IRegistryObject obj : this.registryObjects) {
            if (obj.registerModels()) continue;
            Item item = obj instanceof Block ? Item.func_150898_a((Block)((Block)obj)) : (Item)obj;
            List<ModelResourceLocation> models = obj.getVariants();
            for (int i = 0; i < models.size(); ++i) {
                ModelResourceLocation model = models.get(i);
                if (model == null) continue;
                ModelLoader.registerItemVariants((Item)item, (ResourceLocation[])new ResourceLocation[]{model});
                mesher.func_178086_a(item, i, model);
            }
        }
    }
}

