/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.lib.util;

public class Color {
    public static final Color BLACK = new Color(0);
    public static final Color WHITE = new Color(0xFFFFFF);
    float red;
    float green;
    float blue;
    float alpha;

    public Color(int color) {
        this(color >> 16 & 0xFF, color >> 8 & 0xFF, color & 0xFF);
    }

    public Color(int red, int green, int blue) {
        this((float)red / 255.0f, (float)green / 255.0f, (float)blue / 255.0f, 1.0f);
    }

    public Color(int red, int green, int blue, int alpha) {
        this((float)red / 255.0f, (float)green / 255.0f, (float)blue / 255.0f, (float)alpha / 255.0f);
    }

    public Color(float red, float green, float blue) {
        this(red, green, blue, 1.0f);
    }

    public Color(float red, float green, float blue, float alpha) {
        this.red = red;
        this.green = green;
        this.blue = blue;
        this.alpha = alpha;
    }

    public int getColor() {
        int r = (int)(this.red * 255.0f) << 16;
        int g = (int)(this.green * 255.0f) << 8;
        int b = (int)(this.blue * 255.0f);
        return r + g + b;
    }

    public float getRed() {
        return this.red;
    }

    public float getGreen() {
        return this.green;
    }

    public float getBlue() {
        return this.blue;
    }

    public float getAlpha() {
        return this.alpha;
    }

    public int getRedInt() {
        return (int)(this.red * 255.0f);
    }

    public int getGreenInt() {
        return (int)(this.green * 255.0f);
    }

    public int getBlueInt() {
        return (int)(this.blue * 255.0f);
    }

    public int getAlphaInt() {
        return (int)(this.alpha * 255.0f);
    }
}

